/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class FormatQTest {
    @Test
    public void testQuoteFormatParsing() {
        Version aVer = Version.parseVersion((String)"raw:'a'");
        Assert.assertNotNull((Object)aVer);
        Version v = null;
        v = Version.parseVersion((String)"format(q):'a'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):\"a\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):=a=");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):#a#");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):!a!");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):|a|");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
    }

    @Test
    public void testQUnbalancedQuoteR() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):'a");
        });
    }

    @Test
    public void testQUnbalancedQuoteL() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):a'");
        });
    }

    @Test
    public void testQuotedFormatPairsParsing() {
        Version aVer = Version.parseVersion((String)"raw:'a'");
        Assert.assertNotNull((Object)aVer);
        Version v = null;
        v = Version.parseVersion((String)"format(q):(a)");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):<a>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):[a]");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):{a}");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)aVer, (Object)v);
    }

    @Test
    public void testQUnbalancedPair1() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):(a");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):a)");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):(a(");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):)a)");
        });
    }

    @Test
    public void testQUnbalancedPair2() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):[a");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):a]");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):[a[");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):]a]");
        });
    }

    @Test
    public void testQUnbalancedPair3() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):<a");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):a>");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):<a<");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):>a>");
        });
    }

    @Test
    public void testQUnbalancedPair4() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):{a");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):a}");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):{a{");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):}a}");
        });
    }

    @Test
    public void testQUnbalancedPair5() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):(a}");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):[a}");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):{a]");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q):<a)");
        });
    }

    @Test
    public void testExact() {
        Version v = Version.parseVersion((String)"format(q={4};q):<123a>\"bc456'def'\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2};q):<ab><c>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'ab'.'c'"), (Object)v);
        v = Version.parseVersion((String)"format(q={2};S):'12'3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'"), (Object)v);
        v = Version.parseVersion((String)"format(q={4};q={1};q={3};):<123a>'b'(c45)");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.'b'.'c45'"), (Object)v);
        v = Version.parseVersion((String)"format(q={2};.q={1};qq={3};):<12>.<3>'456'<abc>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'.'456'.'abc'"), (Object)v);
        Assert.assertThrows((String)"Error: quoted string is longer than 4", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={4};.q):123.(abc456)'def'");
        });
        Assert.assertThrows((String)"Error: quoted string is shorter than 4", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={4};q):<123>(abc456'def')");
        });
    }

    @Test
    public void testAtLeast() {
        Version v = Version.parseVersion((String)"format(q={2,};):(123abc456'def')");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:\"123abc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2,};):<123abc456'def'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:\"123abc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2,};.q):(123a).(bc456'def')");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2,};q):<123a>(bc456'def')");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        Assert.assertThrows((String)"Eror: first segment is shorter than 2", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={2,};.q):1.abc456'def'");
        });
        Assert.assertThrows((String)"Eror: firt segment is shorter than 2", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={2,};q):<1>(abc456'def')");
        });
        Assert.assertThrows((String)"Eror: last segment is shorter than 10", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={2,};.q={10,};):(12).(abc456'd')");
        });
        Assert.assertThrows((String)"Eror: fsecond segment is not quoted", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={2,};.q={10,};):<12>.abc456'd'");
        });
    }

    @Test
    public void testAtMost() {
        Version v = Version.parseVersion((String)"format(q={1,3};q={1,2};q):<123><ab><c456'def'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'ab'.\"c456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={1,4};q={1,4};q):<123><abc4><56'def'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'abc4'.\"56'def'\""), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={2,3};q):<1><abc456'def'>");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(q={2,3};q={2,3};):<12><abc456'd'>");
        });
    }
}

