/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class FormatRTest {
    @Test
    public void testNumeric() {
        Version v = Version.parseVersion((String)"format(r):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
    }

    @Test
    public void testNegativeNumeric() {
        Version v = Version.parseVersion((String)"format(r):-1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:-1"), (Object)v);
    }

    @Test
    public void testString() {
        Version v = Version.parseVersion((String)"format(r):'a'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(r):\"a\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
    }

    @Test
    public void testConcatentatedStrings() {
        Version v = Version.parseVersion((String)"format(r):'a''b'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'ab'"), (Object)v);
        v = Version.parseVersion((String)"format(r):'a has a \"hat\" it is '\"a's\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a has a \"hat\" it is '\"a's\""), (Object)v);
    }

    @Test
    public void testMaxString() {
        Version v = Version.parseVersion((String)"format(r):m");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:m"), (Object)v);
    }

    @Test
    public void testMaxNumeric() {
        Version v = Version.parseVersion((String)"format(r):M");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:M"), (Object)v);
    }

    @Test
    public void testArray() {
        Version v = Version.parseVersion((String)"format(r):<1>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:<1>"), (Object)v);
    }

    @Test
    public void testNonRElements() {
        Assert.assertThrows((String)"a is not a valid raw element", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(r):aaa");
        });
        Assert.assertThrows((String)"comma is not a delimiter in raw format", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(r):1,2");
        });
    }
}

