/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class FormatRangeTest
extends VersionTesting {
    public static String OSGI_PREFIX = "format(n[.n=0;[.n=0;[.S=[A-Za-z0-9_-];]]]):";

    @Test
    public void testRangeWithDefaultValues() {
        VersionRange range = new VersionRange(OSGI_PREFIX + "0");
        this.assertIncludedInRange("#1", range, OSGI_PREFIX + "0");
        this.assertIncludedInRange("#2", range, OSGI_PREFIX + "0.0");
        this.assertIncludedInRange("#3", range, OSGI_PREFIX + "0.0.0");
    }

    @Test
    public void testEmptyRange() {
        Assert.assertThrows((String)"Uncaught error: range can not be empty", IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange(OSGI_PREFIX);
        });
    }

    @Test
    public void testRangeDelimitersInVersionString() {
        VersionRange range = new VersionRange("format(S):[one\\,\\ two,three\\,\\ \\[and\\]\\ four]");
        this.assertIncludedInRange("#1", range, "format(S):one, two");
        this.assertIncludedInRange("#1", range, "format(S):three, [and] four");
    }

    @Test
    public void testSingleVersionRange() {
        VersionRange range = new VersionRange(OSGI_PREFIX + "[1.0.0, 1.0.0.x)");
        Assert.assertEquals((String)"0.1", (Object)Version.parseVersion((String)(OSGI_PREFIX + "1.0.0")), (Object)range.getMinimum());
        Assert.assertEquals((String)"0.2", (Object)Version.parseVersion((String)(OSGI_PREFIX + "1.0.0.x")), (Object)range.getMaximum());
        this.assertNotIncludedInRange("0.9", range, OSGI_PREFIX + "0.9");
        this.assertIncludedInRange("1.2", range, OSGI_PREFIX + "1.0.0");
        this.assertNotIncludedInRange("2.1", range, OSGI_PREFIX + "1.0.0.z");
        this.assertNotIncludedInRange("2.2", range, OSGI_PREFIX + "1.0.1");
        this.assertNotIncludedInRange("2.3", range, OSGI_PREFIX + "1.1");
        this.assertNotIncludedInRange("2.4", range, OSGI_PREFIX + "2");
    }

    @Test
    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange(OSGI_PREFIX + "1.0.0");
        this.assertNotIncludedInRange("1.0", lowerBound, OSGI_PREFIX + "0.9.0");
        this.assertIncludedInRange("1.1", lowerBound, OSGI_PREFIX + "1.0.0");
        this.assertIncludedInRange("1.2", lowerBound, OSGI_PREFIX + "1.9.9.x");
        this.assertIncludedInRange("1.3", lowerBound, OSGI_PREFIX + "999.999.999.foo");
    }

    @Test
    public void testGreaterThanMinimum() {
        VersionRange lowerBound = new VersionRange("raw:-M");
        this.assertIncludedInRange("0.1", lowerBound, "raw:-M");
        this.assertIncludedInRange("1.0", lowerBound, OSGI_PREFIX + "0.9.0");
        this.assertIncludedInRange("1.1", lowerBound, OSGI_PREFIX + "1.0.0");
        this.assertIncludedInRange("1.2", lowerBound, OSGI_PREFIX + "1.9.9.x");
        this.assertIncludedInRange("1.3", lowerBound, OSGI_PREFIX + "999.999.999.foo");
    }

    @Test
    public void testLowerThan() {
        VersionRange upperBound = new VersionRange(OSGI_PREFIX + "[0, 2.0.0)");
        this.assertIncludedInRange("1.0", upperBound, OSGI_PREFIX + "0.0");
        this.assertIncludedInRange("1.1", upperBound, OSGI_PREFIX + "0.9");
        this.assertIncludedInRange("1.2", upperBound, OSGI_PREFIX + "1.0");
        this.assertIncludedInRange("1.3", upperBound, OSGI_PREFIX + "1.9.9.x");
        this.assertNotIncludedInRange("1.4", upperBound, OSGI_PREFIX + "2.0");
        this.assertNotIncludedInRange("1.5", upperBound, OSGI_PREFIX + "2.1");
    }
}

