/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class FormatSTest {
    @Test
    public void testStringAcceptDigit() {
        Version v = Version.parseVersion((String)"format(S):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'1'"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: s should not accept digits", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s):1");
        });
    }

    @Test
    public void testStringAcceptAlpha() {
        Version v = Version.parseVersion((String)"format(s):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(S):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
    }

    @Test
    public void testStringDelimitedByNumeric() {
        Version v = Version.parseVersion((String)"format(sn):foobar123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'foobar'.123"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: S should eat entire string, no n found at the end", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(Sn):foobar123");
        });
    }

    @Test
    public void testStringWithSpace() {
        Version v = Version.parseVersion((String)"format(S=[^0-9];n):foo bar123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'foo bar'.123"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(s) can not match non letters (space).", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s=[^];n):foo bar123");
        });
    }

    @Test
    public void testStringDelimitedByDelimiter() {
        Version v = Version.parseVersion((String)"format(s.n):foobar.123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'foobar'.123"), (Object)v);
        v = Version.parseVersion((String)"format(S=[^.];.n):foobar.123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'foobar'.123"), (Object)v);
    }

    @Test
    public void testStringDelimitedByExplicitDelimiter() {
        Version v = Version.parseVersion((String)"format(s=[^r];d=[r];n):foobar123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'fooba'.123"), (Object)v);
    }

    @Test
    public void testStringWithAllowedSet() {
        Version v = Version.parseVersion((String)"format(s=[a-z];sn):fooBAR123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'foo'.'BAR'.123"), (Object)v);
    }

    @Test
    public void testStringWithDisallowedSet() {
        Version v = Version.parseVersion((String)"format(s=[^a-z];sn):FOObar123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'FOO'.'bar'.123"), (Object)v);
    }

    @Test
    public void testExact() {
        Version v = Version.parseVersion((String)"format(S={4};S):123abc456'def'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(s={2};s):abc");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'ab'.'c'"), (Object)v);
        v = Version.parseVersion((String)"format(S={2};S):abc");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'ab'.'c'"), (Object)v);
        v = Version.parseVersion((String)"format(S={2};S):123");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'"), (Object)v);
        v = Version.parseVersion((String)"format(S={4};S={1};S={3};):123abc45");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.'b'.'c45'"), (Object)v);
        v = Version.parseVersion((String)"format(S={2};.S={1};s={3};):12.3abc");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'.'abc'"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: first segment is less than 4 chars long", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s={4};.s):aaa.abc456'def'");
        });
        Assert.assertThrows((String)"Uncaught error: first segment has digits", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s={4};.s):123.abc456'def'");
        });
        Assert.assertThrows((String)"Uncaught error: first segment has only 3 characters", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(S={4}=[^.];.S):123.abc456'def'");
        });
    }

    @Test
    public void testAtLeast() {
        Version v = Version.parseVersion((String)"format(S={2,};):123abc456'def'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:\"123abc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(S={2,};=[^.];.S):123a.bc456'def'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        Assert.assertThrows((String)"Uncaught error: first segment is shorter than 2", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s={2,};.S):a.abc456'def'");
        });
        Assert.assertThrows((String)"Uncaught error: second segment too short", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s={2,};.s={10,};):aa.abcd");
        });
    }

    @Test
    public void testAtMost() {
        Version v = Version.parseVersion((String)"format(S={1,3};S={1,2};S):123abc456'def'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'ab'.\"c456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(S={1,4};=[^.];.S={1,4};.S):123.abc4.56'def'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'abc4'.\"56'def'\""), (Object)v);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s={2,3};s):a.abc456'def'");
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(s={2,3};.S={2,3};):aa.abc456'd'");
        });
    }
}

