/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.junit.Assert;
import org.junit.Test;

public class IntersectionTest {
    @Test
    public void testIntersectsEmpty() {
        VersionRange a = new VersionRange("raw:[1.0.0,3.0.0]");
        VersionRange b = new VersionRange("raw:[4.0.0,6.0.0]");
        Assert.assertTrue((String)"Non overlapping ranges a/b should be empty #1", (a.intersect(b) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non overlapping ranges b/a should be empty #2", (b.intersect(a) == null ? 1 : 0) != 0);
        a = new VersionRange("raw:[1.0.0,3.0.0]");
        b = new VersionRange("raw:(3.0.0,6.0.0]");
        Assert.assertTrue((String)"Non overlapping ranges a/b should be empty #3", (a.intersect(b) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non overlapping ranges b/a should be empty #4", (b.intersect(a) == null ? 1 : 0) != 0);
        a = new VersionRange("raw:[1.0.0,3.0.0)");
        b = new VersionRange("raw:[3.0.0,6.0.0]");
        Assert.assertTrue((String)"Non overlapping ranges a/b should be empty #5", (a.intersect(b) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non overlapping ranges b/a should be empty #6", (b.intersect(a) == null ? 1 : 0) != 0);
    }

    @Test
    public void testStraddleBoundary() {
        VersionRange a = new VersionRange("raw:[1.0.0,3.0.0]");
        VersionRange b = new VersionRange("raw:[2.0.0,6.0.0]");
        VersionRange r = a.intersect(b);
        Assert.assertEquals((String)"#1.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.3", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.4", (boolean)r.getIncludeMinimum());
        r = b.intersect(a);
        Assert.assertEquals((String)"#2.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.3", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#2.4", (boolean)r.getIncludeMinimum());
        a = new VersionRange("raw:[1.0.0,3.0.0)");
        b = new VersionRange("raw:(2.0.0,6.0.0]");
        r = a.intersect(b);
        Assert.assertEquals((String)"#3.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#3.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#3.3", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#3.4", (!r.getIncludeMinimum() ? 1 : 0) != 0);
        r = b.intersect(a);
        Assert.assertEquals((String)"#4.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#4.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#4.3", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#4.4", (!r.getIncludeMinimum() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualRanges() {
        VersionRange a = new VersionRange("raw:[1.0.0,3.0.0]");
        VersionRange b = new VersionRange("raw:[1.0.0,3.0.0]");
        VersionRange r = a.intersect(b);
        Assert.assertEquals((String)"#1.1", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.3", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.4", (boolean)r.getIncludeMinimum());
        r = b.intersect(a);
        Assert.assertEquals((String)"#1.5", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.6", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.7", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.8", (boolean)r.getIncludeMinimum());
        a = new VersionRange("raw:(1.0.0,3.0.0)");
        b = new VersionRange("raw:(1.0.0,3.0.0)");
        r = a.intersect(b);
        Assert.assertEquals((String)"#2.1", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.3", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#2.4", (!r.getIncludeMinimum() ? 1 : 0) != 0);
        r = b.intersect(a);
        Assert.assertEquals((String)"#2.5", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.6", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.7", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#2.8", (!r.getIncludeMinimum() ? 1 : 0) != 0);
    }

    @Test
    public void testPartialEqualLower() {
        VersionRange a = new VersionRange("raw:[1.0.0,3.0.0]");
        VersionRange b = new VersionRange("raw:[1.0.0,2.0.0]");
        VersionRange r = a.intersect(b);
        Assert.assertEquals((String)"#1.1", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.2", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.3", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.4", (boolean)r.getIncludeMinimum());
        r = b.intersect(a);
        Assert.assertEquals((String)"#1.4", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.6", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.7", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.8", (boolean)r.getIncludeMinimum());
        b = new VersionRange("raw:[1.0.0,2.0.0)");
        r = a.intersect(b);
        Assert.assertEquals((String)"#2.1", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.2", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.3", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#2.4", (boolean)r.getIncludeMinimum());
        r = b.intersect(a);
        Assert.assertEquals((String)"#2.4", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.6", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.7", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#2.8", (boolean)r.getIncludeMinimum());
    }

    @Test
    public void testPartialEqualUpper() {
        VersionRange a = new VersionRange("raw:[1.0.0,3.0.0]");
        VersionRange b = new VersionRange("raw:[2.0.0,3.0.0]");
        VersionRange r = a.intersect(b);
        Assert.assertEquals((String)"#1.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.3", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.4", (boolean)r.getIncludeMinimum());
        r = b.intersect(a);
        Assert.assertEquals((String)"#1.4", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.6", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.7", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.8", (boolean)r.getIncludeMinimum());
        b = new VersionRange("raw:(2.0.0,3.0.0]");
        r = a.intersect(b);
        Assert.assertEquals((String)"#2.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.2", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.3", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#2.4", (!r.getIncludeMinimum() ? 1 : 0) != 0);
        r = b.intersect(a);
        Assert.assertEquals((String)"#2.4", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.6", (Object)Version.parseVersion((String)"raw:3.0.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.7", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#2.8", (!r.getIncludeMinimum() ? 1 : 0) != 0);
    }

    @Test
    public void testFullyInside() {
        VersionRange a = new VersionRange("raw:[1.0.0,3.0.0]");
        VersionRange b = new VersionRange("raw:[2.0.0,2.5.0]");
        VersionRange r = a.intersect(b);
        Assert.assertEquals((String)"#1.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.2", (Object)Version.parseVersion((String)"raw:2.5.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.3", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.4", (boolean)r.getIncludeMinimum());
        r = b.intersect(a);
        Assert.assertEquals((String)"#1.5", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#1.6", (Object)Version.parseVersion((String)"raw:2.5.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#1.7", (boolean)r.getIncludeMaximum());
        Assert.assertTrue((String)"#1.8", (boolean)r.getIncludeMinimum());
        b = new VersionRange("raw:(2.0.0,2.5.0)");
        r = a.intersect(b);
        Assert.assertEquals((String)"#2.1", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.2", (Object)Version.parseVersion((String)"raw:2.5.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.3", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#2.4", (!r.getIncludeMinimum() ? 1 : 0) != 0);
        r = b.intersect(a);
        Assert.assertEquals((String)"#2.5", (Object)Version.parseVersion((String)"raw:2.0.0"), (Object)r.getMinimum());
        Assert.assertEquals((String)"#2.6", (Object)Version.parseVersion((String)"raw:2.5.0"), (Object)r.getMaximum());
        Assert.assertTrue((String)"#2.7", (!r.getIncludeMaximum() ? 1 : 0) != 0);
        Assert.assertTrue((String)"#2.8", (!r.getIncludeMinimum() ? 1 : 0) != 0);
    }
}

