/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Assert;
import org.junit.Test;

public class MultiplicityTest {
    @Test
    public void test01() {
        Version v = Version.parseVersion((String)"format(n?):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(n[.n]):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(n.?n?):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n?):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n?):a");
        });
        v = Version.parseVersion((String)"format([n]):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(s[n]):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n[.][n]):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format([n]):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format([n]):a");
        });
        v = Version.parseVersion((String)"format(n{0,1}):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(sn{0,1}):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n.?n{0,}):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n{0,1}):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{0,1}):a");
        });
    }

    @Test
    public void test1M() {
        Version v = Version.parseVersion((String)"format((nd?)+):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n+):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n+):", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n+):");
        });
        Assert.assertThrows((String)"Uncaught error: format(n+):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n+):a");
        });
        v = Version.parseVersion((String)"format((nd?){1,}):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{1,}):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n{1,}):", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{1,}):");
        });
        Assert.assertThrows((String)"Uncaught error: format(n{1,}):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{1,}):a");
        });
    }

    @Test
    public void test0M() {
        Version v = Version.parseVersion((String)"format((nd?)*):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n*):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(sn*):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n*):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n*):a");
        });
        v = Version.parseVersion((String)"format((nd?){0,}):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{0,}):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(sn{0,}):a");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n{0,}):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{0,}):a");
        });
    }

    @Test
    public void testExact() {
        Version v = Version.parseVersion((String)"format((nd?){3}):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{1}):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n{1}):", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{1}):");
        });
        Assert.assertThrows((String)"Uncaught error: format((nd?){3}):1.2", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){3}):1.2");
        });
        Assert.assertThrows((String)"Uncaught error: format(n{1}):a", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{1}):a");
        });
    }

    @Test
    public void testAtLeast() {
        Version v = null;
        v = Version.parseVersion((String)"format((nd?){2,}):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format((nd?){3,}):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{1,}):1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n{1,}):1", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{2,}):1");
        });
        Assert.assertThrows((String)"Uncaught error: format(n{3,1}):1.2", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){3,}):1.2");
        });
    }

    @Test
    public void testAtMost() {
        Version v = null;
        v = Version.parseVersion((String)"format((nd?){2,3}):1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format((nd?){2,3}):1.2");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)Version.parseVersion((String)"raw:1.2"), (Object)v);
        Assert.assertThrows((String)"Uncaught error: format(n{2,3}):1", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{2,3}):1");
        });
        Assert.assertThrows((String)"Uncaught error: format(n{2,3}):1.2.3.4", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{2,3}):1.2.3.4");
        });
    }

    @Test
    public void testZeroExact() {
        Assert.assertThrows((String)"Uncaught error: format(n{0}):", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{0}):");
        });
        Assert.assertThrows((String)"Uncaught error: fformat(n{0,0}):", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format(n{0,0}):");
        });
    }

    @Test
    public void testMinGreaterThanMax() {
        Assert.assertThrows((String)"Uncaught error: format((nd?){3,2}):1.2.3", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){3,2}):1.2.3");
        });
    }

    @Test
    public void testUnbalancedBraceR() {
        Assert.assertThrows((String)"Uncaught error: format((nd?){3,2):1.2.3", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){3,2):1.2.3");
        });
    }

    @Test
    public void testNegativeRange() {
        Assert.assertThrows((String)"Uncaught error: format((nd?){-1,2}):1.2.3", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){-1,2}):1.2.3");
        });
        Assert.assertThrows((String)"Uncaught error: format((nd?){1,-2}):1.2.3", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){1,-2}):1.2.3");
        });
    }

    @Test
    public void testStringRange() {
        Assert.assertThrows((String)"Uncaught error: format((nd?){a,2}):1.2.3", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){a,2}):1.2.3");
        });
        Assert.assertThrows((String)"Uncaught error: format((nd?){1,a}):1.2.3", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"format((nd?){1,a}):1.2.3");
        });
    }
}

