/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class OSGiRangeTest
extends VersionTesting {
    private static Version ONE = Version.parseVersion((String)"1");
    private static Version TWO = Version.parseVersion((String)"2");

    @Test
    public void testSingleVersionRange() {
        VersionRange range = new VersionRange("[1.0.0, 1.0.0.-)");
        Assert.assertEquals((String)"0.1", (Object)Version.parseVersion((String)"1.0"), (Object)range.getMinimum());
        Assert.assertTrue((String)"0.9", (!range.isIncluded(Version.parseVersion((String)"0.9")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.0", (boolean)range.isIncluded(Version.parseVersion((String)"1")));
        Assert.assertTrue((String)"1.1", (boolean)range.isIncluded(Version.parseVersion((String)"1.0")));
        Assert.assertTrue((String)"1.2", (boolean)range.isIncluded(Version.parseVersion((String)"1.0.0")));
        Assert.assertTrue((String)"2.1", (!range.isIncluded(Version.parseVersion((String)"1.0.0.0")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.2", (!range.isIncluded(Version.parseVersion((String)"1.0.1")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.3", (!range.isIncluded(Version.parseVersion((String)"1.1")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.4", (!range.isIncluded(Version.parseVersion((String)"2")) ? 1 : 0) != 0);
    }

    @Test
    public void testInvertedRange() {
        Assert.assertThrows((String)"Inverted range is not allowed", IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("[2.0.0, 1.0.0]");
        });
    }

    @Test
    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange("1.0.0");
        Assert.assertTrue((String)"1.0", (!lowerBound.isIncluded(Version.parseVersion((String)"0.9")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.1", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"1.0")));
        Assert.assertTrue((String)"1.2", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"1.9.9.x")));
        Assert.assertTrue((String)"1.3", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"999.999.999.foo")));
        Assert.assertTrue((String)"2.0", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"raw:M")));
        Assert.assertTrue((String)"2.1", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"raw:2147483647.2147483647.2147483647.0")));
    }

    @Test
    public void testLowerThan() {
        VersionRange upperBound = new VersionRange("[0,2.0)");
        Assert.assertTrue((String)"1.0", (boolean)upperBound.isIncluded(Version.parseVersion((String)"0.0")));
        Assert.assertTrue((String)"1.1", (boolean)upperBound.isIncluded(Version.parseVersion((String)"0.9")));
        Assert.assertTrue((String)"1.2", (boolean)upperBound.isIncluded(Version.parseVersion((String)"1.0")));
        Assert.assertTrue((String)"1.3", (boolean)upperBound.isIncluded(Version.parseVersion((String)"1.9.9.x")));
        Assert.assertTrue((String)"1.4", (!upperBound.isIncluded(Version.parseVersion((String)"2.0")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.5", (!upperBound.isIncluded(Version.parseVersion((String)"2.1")) ? 1 : 0) != 0);
    }

    @Test
    public void testRangeStrings() {
        VersionRange v = null;
        v = new VersionRange("1.0.0");
        Assert.assertEquals((Object)"1.0.0", (Object)v.toString());
        v = new VersionRange("[1.0.0,2.0.0]");
        Assert.assertEquals((Object)"[1.0.0,2.0.0]", (Object)v.toString());
        v = new VersionRange("(1.0.0,2.0.0]");
        Assert.assertEquals((Object)"(1.0.0,2.0.0]", (Object)v.toString());
        v = new VersionRange("[1.0.0,2.0.0)");
        Assert.assertEquals((Object)"[1.0.0,2.0.0)", (Object)v.toString());
        v = new VersionRange("(1.0.0,2.0.0)");
        Assert.assertEquals((Object)"(1.0.0,2.0.0)", (Object)v.toString());
        v = new VersionRange("1.0.0.abcdef");
        Assert.assertEquals((Object)"1.0.0.abcdef", (Object)v.toString());
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef]");
        Assert.assertEquals((Object)"[1.0.0.abcdef,2.0.0.abcdef]", (Object)v.toString());
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef]");
        Assert.assertEquals((Object)"(1.0.0.abcdef,2.0.0.abcdef]", (Object)v.toString());
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef)");
        Assert.assertEquals((Object)"[1.0.0.abcdef,2.0.0.abcdef)", (Object)v.toString());
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef)");
        Assert.assertEquals((Object)"(1.0.0.abcdef,2.0.0.abcdef)", (Object)v.toString());
    }

    @Test
    public void testEmptyRange() {
        this.assertBounds("", true, Version.emptyVersion, Version.MAX_VERSION, true);
    }

    @Test
    public void testExplicitLowerAndUpperBound() {
        this.assertBounds("[1,2)", true, ONE, TWO, false);
        this.assertBounds("[1,2]", true, ONE, TWO, true);
    }

    @Test
    public void testNoLowerBound() {
        this.assertBounds("(,1)", true, Version.emptyVersion, ONE, false);
        this.assertBounds("[,1)", true, Version.emptyVersion, ONE, false);
    }

    @Test
    public void testNoUpperBound() {
        this.assertBounds("[1,)", true, ONE, Version.MAX_VERSION, true);
        this.assertBounds("[1,]", true, ONE, Version.MAX_VERSION, true);
    }

    @Test
    public void testNoLowerAndUpperBound() {
        this.assertBounds("(,)", true, Version.emptyVersion, Version.MAX_VERSION, true);
        this.assertBounds("[,]", true, Version.emptyVersion, Version.MAX_VERSION, true);
    }

    @Test
    public void testNullConstructor() {
        VersionRange range = new VersionRange(null);
        Assert.assertEquals((String)"1.0", (Object)range.getMinimum(), (Object)Version.emptyVersion);
        Assert.assertEquals((String)"1.1", (Object)range.getMaximum(), (Object)Version.MAX_VERSION);
        range = new VersionRange(null, true, null, true);
        Assert.assertEquals((String)"2.0", (Object)range.getMinimum(), (Object)Version.emptyVersion);
        Assert.assertEquals((String)"2.1", (Object)range.getMaximum(), (Object)Version.MAX_VERSION);
    }

    @Test
    public void testSerialize() {
        VersionRange v = null;
        v = new VersionRange("1.0.0");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0,2.0.0]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0,2.0.0]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0,2.0.0)");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0,2.0.0)");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("1.0.0.abcdef");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef)");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef)");
        OSGiRangeTest.assertSerialized(v);
    }
}

