/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class OSGiVersionTest
extends VersionTesting {
    @Test
    public void testBasicParsing() {
        Assert.assertNotNull((Object)Version.parseVersion((String)"1"));
        Assert.assertNotNull((Object)Version.parseVersion((String)"1.0"));
        Assert.assertNotNull((Object)Version.parseVersion((String)"1.0.0"));
        Assert.assertNotNull((Object)Version.parseVersion((String)"1.0.0.9"));
        Assert.assertNotNull((Object)Version.parseVersion((String)"1.0.0.r12345"));
        Assert.assertNotNull((Object)Version.parseVersion((String)"1.0.0.r12345_hello"));
    }

    @Test
    public void testOSGiStrings() {
        Version v = Version.parseVersion(null);
        Assert.assertEquals((Object)"0.0.0", (Object)v.toString());
        v = Version.parseVersion((String)"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"0.0.0", (Object)v.toString());
        v = Version.parseVersion((String)"1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"1.0.0", (Object)v.toString());
        v = Version.parseVersion((String)"1.0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"1.0.0", (Object)v.toString());
        v = Version.parseVersion((String)"1.0.0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"1.0.0", (Object)v.toString());
        v = Version.parseVersion((String)"1.0.0.9");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"1.0.0.9", (Object)v.toString());
        v = Version.parseVersion((String)"1.0.0.r12345");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"1.0.0.r12345", (Object)v.toString());
        v = Version.parseVersion((String)"1.0.0.r12345_hello");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"1.0.0.r12345_hello", (Object)v.toString());
    }

    @Test
    public void testSerialize() {
        Version v = null;
        v = Version.parseVersion((String)"1");
        Assert.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0");
        Assert.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0");
        Assert.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0.9");
        Assert.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0.r12345");
        Assert.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
        v = Version.parseVersion((String)"1.0.0.r12345_hello");
        Assert.assertNotNull((Object)v);
        OSGiVersionTest.assertSerialized(v);
    }

    @Test
    public void testNegativeFirstValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"-1");
        });
    }

    @Test
    public void testPeriodInQualifier() {
        Assert.assertThrows((String)"Uncaught exception: period is not allowed in osgi qualifier", IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"1.0.0.sailor.moon");
        });
    }

    @Test
    public void testNegativeSecondValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"1.-1");
        });
    }

    @Test
    public void testNegativeThirdValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"1.0.-1");
        });
    }

    @Test
    public void testEmptyFourthValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"1.0.0.");
        });
    }

    @Test
    public void testStringFirstValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"a");
        });
    }

    @Test
    public void testStringSecondValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"1.a");
        });
    }

    @Test
    public void testStringThirdValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"1.0.a");
        });
    }

    @Test
    public void testSinglePeriod() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)".");
        });
    }

    @Test
    public void testTwoPeriods() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"..");
        });
    }

    @Test
    public void testThreePeriods() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"...");
        });
    }

    @Test
    public void testEquality() {
        Version v1 = Version.parseVersion((String)"1");
        Version v2 = Version.parseVersion((String)"1.0");
        Version v3 = Version.parseVersion((String)"1.0.0");
        Version v4 = Version.parseVersion((String)"1.0.0.9");
        Version v5 = Version.parseVersion((String)"1.0.0.r12345");
        Assert.assertEquals((Object)v1, (Object)v2);
        Assert.assertEquals((Object)v1, (Object)v3);
        Assert.assertEquals((Object)v2, (Object)v3);
        OSGiVersionTest.assertOrder(v3, v4);
        OSGiVersionTest.assertOrder(v4, v5);
    }

    @Test
    public void testVersionCompare() {
        Version v1 = Version.parseVersion((String)"1");
        Version v2 = Version.parseVersion((String)"1.0.1");
        Version v3 = Version.parseVersion((String)"1.1");
        Version v4 = Version.parseVersion((String)"1.1.1");
        Version v5 = Version.parseVersion((String)"1.1.1.-");
        Version v6 = Version.parseVersion((String)"1.2");
        Version v7 = Version.parseVersion((String)"2");
        Version v8 = Version.parseVersion((String)"10.0");
        OSGiVersionTest.assertOrder(v1, v2);
        OSGiVersionTest.assertOrder(v2, v3);
        OSGiVersionTest.assertOrder(v3, v4);
        OSGiVersionTest.assertOrder(v4, v5);
        OSGiVersionTest.assertOrder(v5, v6);
        OSGiVersionTest.assertOrder(v6, v7);
        OSGiVersionTest.assertOrder(v7, v8);
    }

    @Test
    public void testCompatability() {
        Version v = Version.parseVersion((String)"raw:1.2.3.'foo'");
        Assert.assertNotNull((Object)v);
        Assert.assertTrue((String)"a raw:1.2.3.'foo' compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3");
        Assert.assertNotNull((Object)v);
        Assert.assertTrue((String)"a raw:1.2.3 compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3p''");
        Assert.assertNotNull((Object)v);
        Assert.assertFalse((String)"a raw:1.2.3p'' not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3.4");
        Assert.assertNotNull((Object)v);
        Assert.assertFalse((String)"a raw (4th is int) not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3.'foo'.'bar'");
        Assert.assertNotNull((Object)v);
        Assert.assertFalse((String)"a raw (5 elements) not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2");
        Assert.assertNotNull((Object)v);
        Assert.assertFalse((String)"a raw (only 2 elements) not compatible with OSGi", (boolean)v.isOSGiCompatible());
        v = Version.parseVersion((String)"raw:1.2.3.' %@'");
        Assert.assertNotNull((Object)v);
        Assert.assertFalse((String)"a raw (illegal chars in qualifier) not compatible with OSGi", (boolean)v.isOSGiCompatible());
    }
}

