/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.junit.Test;

public class PerformanceTest {
    static final int MUL = 24;
    static final String qualifierTemplate = "r20090112-12345-abcdefghijklmnopqrstuvwxyz";

    @Test
    public void testStringCreationPerformance() {
        Version.MAX_VERSION.compareTo((Object)Version.emptyVersion);
        org.osgi.framework.Version.emptyVersion.compareTo(org.osgi.framework.Version.emptyVersion);
        String[] strings = PerformanceTest.createStrings();
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < 100) {
            PerformanceTest.osgiVersionCreateFromString(strings);
            ++idx;
        }
        long osgiTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < 100) {
            PerformanceTest.omniVersionCreateFromString(strings);
            ++idx2;
        }
        long omniTime = System.currentTimeMillis() - start;
        PerformanceTest.outputResult("String creation", 1382400L, osgiTime, omniTime);
    }

    @Test
    public void testCreationPerformance() {
        Version.MAX_VERSION.compareTo((Object)Version.emptyVersion);
        org.osgi.framework.Version.emptyVersion.compareTo(org.osgi.framework.Version.emptyVersion);
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < 100) {
            PerformanceTest.osgiVersionCreate();
            ++idx;
        }
        long osgiTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < 100) {
            PerformanceTest.omniVersionCreate();
            ++idx2;
        }
        long omniTime = System.currentTimeMillis() - start;
        PerformanceTest.outputResult("Creation", 1382400L, osgiTime, omniTime);
    }

    @Test
    public void testComparePerformance() {
        Version[] omniVersions = PerformanceTest.createOmniVersions();
        org.osgi.framework.Version[] osgiVersions = PerformanceTest.createOsgiVersions();
        long start = System.currentTimeMillis();
        PerformanceTest.osgiVersionCompare(osgiVersions);
        long osgiTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        PerformanceTest.omniVersionCompare(omniVersions);
        long omniTime = System.currentTimeMillis() - start;
        long units = 191102976L;
        PerformanceTest.outputResult("Compare", units, osgiTime, omniTime);
    }

    @Test
    public void testEqualsPerformance() {
        Version[] omniVersions = PerformanceTest.createOmniVersions();
        org.osgi.framework.Version[] osgiVersions = PerformanceTest.createOsgiVersions();
        long start = System.currentTimeMillis();
        PerformanceTest.osgiVersionEquals(osgiVersions);
        long osgiTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        PerformanceTest.omniVersionEquals(omniVersions);
        long omniTime = System.currentTimeMillis() - start;
        long units = 191102976L;
        PerformanceTest.outputResult("Equals", units, osgiTime, omniTime);
    }

    @Test
    public void testToStringPerformance() {
        Version[] omniVersions = PerformanceTest.createOmniVersions();
        org.osgi.framework.Version[] osgiVersions = PerformanceTest.createOsgiVersions();
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < 100) {
            PerformanceTest.osgiVersionToString(osgiVersions);
            ++idx;
        }
        long osgiTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < 100) {
            PerformanceTest.omniVersionToString(omniVersions);
            ++idx2;
        }
        long omniTime = System.currentTimeMillis() - start;
        long units = 1382400L;
        PerformanceTest.outputResult("To String", units, osgiTime, omniTime);
    }

    public static void osgiVersionToString(org.osgi.framework.Version[] versions) {
        int i = 0;
        while (i < 13824) {
            versions[i].toString();
            ++i;
        }
    }

    public static void omniVersionToString(Version[] versions) {
        int i = 0;
        while (i < 13824) {
            versions[i].toString();
            ++i;
        }
    }

    public static void omniVersionCreate() {
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    Version.createOSGi((int)i, (int)j, (int)k, (String)qualifierTemplate);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void omniVersionCompare(Version[] versions) {
        int i = 0;
        while (i < 13824) {
            int j = 0;
            while (j < 13824) {
                versions[i].compareTo((Object)versions[j]);
                ++j;
            }
            ++i;
        }
    }

    public static void omniVersionEquals(Version[] versions) {
        int i = 0;
        while (i < 13824) {
            int j = 0;
            while (j < 13824) {
                versions[i].equals(versions[j]);
                ++j;
            }
            ++i;
        }
    }

    public static void omniVersionCreateFromString(String[] strings) {
        int x = 0;
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    Version.create((String)strings[x++]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void osgiVersionCompare(org.osgi.framework.Version[] versions) {
        int i = 0;
        while (i < 13824) {
            int j = 0;
            while (j < 13824) {
                versions[i].compareTo(versions[j]);
                ++j;
            }
            ++i;
        }
    }

    public static void osgiVersionEquals(org.osgi.framework.Version[] versions) {
        int i = 0;
        while (i < 13824) {
            int j = 0;
            while (j < 13824) {
                versions[i].equals((Object)versions[j]);
                ++j;
            }
            ++i;
        }
    }

    public static void osgiVersionCreate() {
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    new org.osgi.framework.Version(i, j, k, qualifierTemplate);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void osgiVersionCreateFromString(String[] strings) {
        int x = 0;
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    org.osgi.framework.Version.parseVersion((String)strings[x++]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static Version[] createOmniVersions() {
        Version[] versions = new Version[13824];
        int x = 0;
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    versions[x++] = Version.createOSGi((int)i, (int)j, (int)k, (String)qualifierTemplate.substring(0, k + 1));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return versions;
    }

    private static org.osgi.framework.Version[] createOsgiVersions() {
        org.osgi.framework.Version[] versions = new org.osgi.framework.Version[13824];
        int x = 0;
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    versions[x++] = new org.osgi.framework.Version(i, j, k, qualifierTemplate.substring(0, k + 1));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return versions;
    }

    private static String[] createStrings() {
        String[] strings = new String[13824];
        StringBuilder buf = new StringBuilder(100);
        int x = 0;
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    buf.setLength(0);
                    buf.append(i);
                    buf.append(".");
                    buf.append(j);
                    buf.append(".");
                    buf.append(k);
                    buf.append(".");
                    buf.append(qualifierTemplate.substring(0, k + 1));
                    strings[x++] = buf.toString();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return strings;
    }

    private static double factor(long osgiTime, long omniTime) {
        double osgi = osgiTime;
        double omni = omniTime;
        return osgi / omni;
    }

    private static void outputResult(String message, long units, long osgiTime, long omniTime) {
        System.out.printf("%s (units %d): osgi=%d [%.2fus/unit], omni=%d [%.2fus/unit], factor=%.2f\n", message, units, osgiTime, PerformanceTest.perUnit(osgiTime, units), omniTime, PerformanceTest.perUnit(omniTime, units), PerformanceTest.factor(omniTime, osgiTime));
    }

    private static double perUnit(long timeMillisec, long units) {
        double time = timeMillisec * 1000L;
        double u = units;
        return time / u;
    }
}

