/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class RawRangeTest
extends VersionTesting {
    private static Version ONE = Version.parseVersion((String)"raw:1");
    private static Version TWO = Version.parseVersion((String)"raw:2");

    @Test
    public void testEmptyRange() {
        VersionRange range = new VersionRange("raw:''");
        this.assertIncludedInRange("#1", range, "raw:'a'");
        Assert.assertThrows((String)"Uncaught error: a raw range can not be empty.", IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:");
        });
    }

    @Test
    public void testRangeDelimitersInStrings() {
        VersionRange range = null;
        range = new VersionRange("raw:['one\\,\\ two','three\\,\\ \\[and\\]\\ four']");
        this.assertIncludedInRange("#1", range, "raw:'one, two'");
        this.assertIncludedInRange("#2", range, "raw:'three, [and] four'");
    }

    @Test
    public void testRangeDelimitersInStringstoString() {
        VersionRange range = null;
        String s = null;
        s = "raw:['one\\,\\ two','three\\,\\ \\[and\\]\\ four']";
        range = new VersionRange("raw:['one\\,\\ two','three\\,\\ \\[and\\]\\ four']");
        Assert.assertEquals((Object)s, (Object)range.toString());
    }

    @Test
    public void testSingleVersionRange() {
        VersionRange range = new VersionRange("raw:[1.0.0, 1.0.0.'-')");
        Assert.assertEquals((String)"0.1", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)range.getMinimum());
        Assert.assertEquals((String)"0.2", (Object)Version.parseVersion((String)"raw:1.0.0.'-'"), (Object)range.getMaximum());
        this.assertNotIncludedInRange("0.9", range, "raw:0.9");
        this.assertNotIncludedInRange("1.0", range, "raw:1");
        this.assertNotIncludedInRange("1.1", range, "raw:1.0");
        this.assertIncludedInRange("1.2", range, "raw:1.0.0");
        this.assertNotIncludedInRange("2.1", range, "raw:1.0.0.'0'");
        this.assertNotIncludedInRange("2.2", range, "raw:1.0.1");
        this.assertNotIncludedInRange("2.3", range, "raw:1.1");
        this.assertNotIncludedInRange("2.4", range, "raw:2");
    }

    @Test
    public void testInvertedRange() {
        Assert.assertThrows((String)"\"Inverted range is not allowed\"", IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[2.0.0, 1.0.0]");
        });
    }

    @Test
    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange("raw:1.0.0");
        this.assertNotIncludedInRange("1.0", lowerBound, "raw:0.9.0");
        this.assertIncludedInRange("1.1", lowerBound, "raw:1.0.0");
        this.assertIncludedInRange("1.2", lowerBound, "raw:1.9.9.'x'");
        this.assertIncludedInRange("1.3", lowerBound, "raw:999.999.999.'foo'");
        this.assertIncludedInRange("1.3", lowerBound, "raw:M.M.M.m");
    }

    @Test
    public void testGreaterThanSmallest() {
        VersionRange lowerBound = new VersionRange("raw:-M");
        this.assertIncludedInRange("#1", lowerBound, "raw:-M");
        this.assertIncludedInRange("#1.1", lowerBound, "raw:''");
        this.assertIncludedInRange("#1.1", lowerBound, "raw:m");
        this.assertIncludedInRange("#2", lowerBound, "raw:0.9.0");
        this.assertIncludedInRange("#3", lowerBound, "raw:1.0.0");
        this.assertIncludedInRange("#4", lowerBound, "raw:1.9.9.'x'");
        this.assertIncludedInRange("#5", lowerBound, "raw:999.999.999.'foo'");
        this.assertIncludedInRange("#6", lowerBound, "raw:M.M.M.m");
        this.assertIncludedInRange("#7", lowerBound, "raw:M");
        this.assertIncludedInRange("#8", lowerBound, "raw:MpM");
    }

    @Test
    public void testLowerThan() {
        VersionRange upperBound = new VersionRange("raw:[0, 2.0)");
        this.assertIncludedInRange("1.0", upperBound, "raw:0.0");
        this.assertIncludedInRange("1.1", upperBound, "raw:0.9");
        this.assertIncludedInRange("1.2", upperBound, "raw:1.0");
        this.assertIncludedInRange("1.3", upperBound, "raw:1.9.9.'x'");
        this.assertNotIncludedInRange("1.4", upperBound, "raw:2.0");
        this.assertNotIncludedInRange("1.5", upperBound, "raw:2.1");
    }

    @Test
    public void testExplicitLowerAndUpperBound() {
        this.assertBounds("raw:[1,2)", true, ONE, TWO, false);
        this.assertBounds("raw:[1,2]", true, ONE, TWO, true);
    }

    @Test
    public void testNoLowerBound() {
        this.assertBounds("raw:(,1)", true, Version.emptyVersion, ONE, false);
        this.assertBounds("raw:[,1)", true, Version.emptyVersion, ONE, false);
    }

    @Test
    public void testNoUpperBound() {
        this.assertBounds("raw:[1,)", true, ONE, Version.MAX_VERSION, true);
        this.assertBounds("raw:[1,]", true, ONE, Version.MAX_VERSION, true);
    }

    @Test
    public void testNoLowerAndUpperBound() {
        this.assertBounds("raw:(,)", true, Version.emptyVersion, Version.MAX_VERSION, true);
        this.assertBounds("raw:[,]", true, Version.emptyVersion, Version.MAX_VERSION, true);
    }

    @Test
    public void testSerialize() {
        VersionRange v = null;
        v = new VersionRange("raw:1.0.0");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0,2.0.0]");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0,2.0.0]");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0,2.0.0)");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0,2.0.0)");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:1.0.0.'abcdef'");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef']");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef']");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef')");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef')");
        RawRangeTest.assertSerialized(v);
    }

    @Test
    public void testToString() {
        VersionRange v = null;
        String s = null;
        s = "raw:1.0.0";
        v = new VersionRange("raw:1.0.0");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:[1.0.0,2.0.0]";
        v = new VersionRange("raw:[1.0.0,2.0.0]");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:(1.0.0,2.0.0]";
        v = new VersionRange("raw:(1.0.0,2.0.0]");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:[1.0.0,2.0.0)";
        v = new VersionRange("raw:[1.0.0,2.0.0)");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:(1.0.0,2.0.0)";
        v = new VersionRange("raw:(1.0.0,2.0.0)");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.0.'abcdef'";
        v = new VersionRange("raw:1.0.0.'abcdef'");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:[1.0.0.'abcdef',2.0.0.'abcdef']";
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef']");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:(1.0.0.'abcdef',2.0.0.'abcdef']";
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef']");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:[1.0.0.'abcdef',2.0.0.'abcdef')";
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef')");
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:(1.0.0.'abcdef',2.0.0.'abcdef')";
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef')");
        Assert.assertEquals((Object)s, (Object)v.toString());
    }
}

