/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class RawRangeWithOriginalTest
extends VersionTesting {
    @Test
    public void testRawWithUnknownFormat() {
        VersionRange v = new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S");
        Assert.assertEquals((Object)v, (Object)new VersionRange("raw:[1.0,2.0]"));
    }

    @Test
    public void testRawWithUnknownFormatToString() {
        Assert.assertEquals((Object)"raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S", (Object)new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S").toString());
    }

    @Test
    public void testRawWithUnknownFormatSerialized() {
        RawRangeWithOriginalTest.assertSerialized(new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S"));
        Assert.assertEquals((Object)"raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S", (Object)RawRangeWithOriginalTest.getSerialized(new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S")).toString());
    }

    @Test
    public void testRawWithSimpleFormat() {
        VersionRange v = new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]");
        Assert.assertEquals((Object)v, (Object)new VersionRange("raw:[1.0,2.0]"));
    }

    @Test
    public void testRawWithSimpleFormatToString() {
        Assert.assertEquals((Object)"raw:[1.0,2.0]/format(n.n):1.0,2.0", (Object)new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]").toString());
    }

    @Test
    public void testSimpleFormatToString() {
        Assert.assertEquals((Object)"raw:[1.0,2.0]/format(n.n):1.0,2.0", (Object)new VersionRange("format(n.n):[1.0,2.0]").toString());
    }

    @Test
    public void testRawWithSimpleFormatSerialized() {
        RawRangeWithOriginalTest.assertSerialized(new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]"));
        Assert.assertEquals((Object)"raw:[1.0,2.0]/format(n.n):1.0,2.0", (Object)RawRangeWithOriginalTest.getSerialized(new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]")).toString());
    }

    @Test
    public void testOriginalStatedButMissing() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/");
        });
    }

    @Test
    public void testOriginalAndUnknownStatedButMissing() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/:");
        });
    }

    @Test
    public void testOriginalIllegalFormat() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/foo:");
        });
    }

    @Test
    public void testOriginalIllegalFormat2() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/100:");
        });
    }

    @Test
    public void testOriginalIllegalFormat3() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/'format':");
        });
    }

    @Test
    public void testOriginalIllegalFormat4() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]//1.0");
        });
    }

    @Test
    public void testOriginalIllegalFormat5() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/format:");
        });
    }

    @Test
    public void testOriginalFormatUnbalancedLeft() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/formatn.n):");
        });
    }

    @Test
    public void testOriginalFormatUnbalancedRight() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/format(n.n:1.0");
        });
    }

    @Test
    public void testOriginalFormatOriginalMissing() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            VersionRange versionRange = new VersionRange("raw:[1.0,2.0]/format(n.n):");
        });
    }

    @Test
    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange("raw:2.1.0.M/format(n[.n=0;[.n=0;]][d?S=M;]):2.1");
        this.assertNotIncludedInRange("1.0", lowerBound, "raw:2.0.9");
        this.assertIncludedInRange("1.1", lowerBound, "raw:2.2");
        this.assertIncludedInRange("1.3", lowerBound, "raw:999.999.999.'foo'");
    }

    @Test
    public void testMinBoundary() {
        String rangeString = "raw:[-M,2.1.0.M]/format(n[.n=0;[.n=0;]][d?S=M;]):-M,2.1";
        VersionRange range = new VersionRange(rangeString);
        Assert.assertEquals((Object)rangeString, (Object)range.toString());
        VersionRange range1 = new VersionRange(range.getMinimum(), range.getIncludeMinimum(), range.getMaximum(), range.getIncludeMaximum());
        Assert.assertEquals((Object)range1, (Object)range);
        VersionRange range2 = new VersionRange(null, true, range.getMaximum(), range.getIncludeMaximum());
        Assert.assertEquals((Object)range2, (Object)range);
    }

    @Test
    public void testOSGiMinBoundary() {
        String rangeString = "raw:[-M,2.1.0.'']/format(n[.n=0;[.n=0;[.S='';=[A-Za-z0-9_-];]]]):-M,2.1.0";
        VersionRange range = new VersionRange(rangeString);
        VersionRange range1 = new VersionRange("[0.0.0,2.1.0]");
        Assert.assertEquals((Object)range1, (Object)range);
        Assert.assertEquals((Object)"[0.0.0,2.1.0]", (Object)range.toString());
        VersionRange range2 = new VersionRange(null, true, range.getMaximum(), range.getIncludeMaximum());
        Assert.assertEquals((Object)range2, (Object)range);
    }

    @Test
    public void testMaxBoundary() {
        String rangeString = "raw:[2.1.0.M,MpM]/format(n[.n=0;[.n=0;]][d?S=M;]):2.1,MpM";
        VersionRange range = new VersionRange(rangeString);
        Assert.assertEquals((Object)"raw:2.1.0.M/format(n[.n=0;[.n=0;]][d?S=M;]):2.1", (Object)range.toString());
        VersionRange range1 = new VersionRange(range.getMinimum(), range.getIncludeMinimum(), range.getMaximum(), range.getIncludeMaximum());
        Assert.assertEquals((Object)range1, (Object)range);
        VersionRange range2 = new VersionRange(range.getMinimum(), true, null, true);
        Assert.assertEquals((Object)range2, (Object)range);
    }

    @Test
    public void testRecreateUsingMaxUpper() {
        Version v = Version.create((String)"format(n[.n=0;[.n=0;]][d?S=M;]):2.1");
        VersionRange range = new VersionRange(v, true, null, true);
        Version min = range.getMinimum();
        Version max = range.getMaximum();
        VersionRange range2 = new VersionRange(min, true, max, true);
        Assert.assertEquals((Object)range2, (Object)range);
    }

    @Test
    public void testRecreateUsingMinLower() {
        Version v = Version.create((String)"format(n[.n=0;[.n=0;]][d?S=M;]):2.1");
        VersionRange range = new VersionRange(null, true, v, true);
        Version min = range.getMinimum();
        Version max = range.getMaximum();
        VersionRange range2 = new VersionRange(min, true, max, true);
        Assert.assertEquals((Object)range2, (Object)range);
    }

    @Test
    public void testOSGiMaxBoundary() {
        String rangeString = "raw:[2.1.0.'',MpM]/format(n[.n=0;[.n=0;[.S='';=[A-Za-z0-9_-];]]]):2.1.0,MpM";
        VersionRange range = new VersionRange(rangeString);
        VersionRange range1 = new VersionRange("2.1.0");
        Assert.assertEquals((Object)range1, (Object)range);
        Assert.assertEquals((Object)"2.1.0", (Object)range.toString());
        VersionRange range2 = new VersionRange(range.getMinimum(), true, null, true);
        Assert.assertEquals((Object)range2, (Object)range);
    }
}

