/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.internal.p2.metadata.VersionVector;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class RawVersionTest
extends VersionTesting {
    @Test
    public void testBasicParsing() {
        Assert.assertNotNull((Object)Version.create((String)"raw:1"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.0"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.0.9"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.0.'r12345'"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.0.'r12345.hello'"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.m"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.M"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.M"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.0.-M"));
    }

    @Test
    public void testEnumParsing() {
        Assert.assertThrows((String)"Parsing succeeded but enum had no ordinal indicator", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:{blue,green,yellow}");
        });
        Version.create((String)"raw:{blue,^green,yellow}");
    }

    @Test
    public void testEnumCompare() {
        Version v2;
        Version v1 = Version.create((String)"raw:{blue,^green,yellow}");
        Assert.assertTrue((v1.compareTo((Object)(v2 = Version.create((String)"raw:{^blue,green,yellow}"))) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{blue,green,^yellow}");
        v2 = Version.create((String)"raw:{blue,green,^yellow}");
        Assert.assertEquals((Object)v1, (Object)v2);
        v1 = Version.create((String)"raw:{blue,^green}");
        v2 = Version.create((String)"raw:{^blue,green,yellow}");
        Assert.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{blue,^green,yelllow}");
        v2 = Version.create((String)"raw:{green,^yellow}");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{^blue,green,yellow}");
        v2 = Version.create((String)"raw:{green,^yellow}");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{green,^yellow,blue}");
        v2 = Version.create((String)"raw:{^blue,green,yellow}");
        Assert.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{green,^yellow,blue}");
        v2 = Version.create((String)"raw:{^blue,green,yellow,purple}");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnumCompareWithOther() {
        Version v2;
        Version v1 = Version.create((String)"raw:{blue,^green,yellow}");
        Assert.assertTrue((v1.compareTo((Object)(v2 = Version.create((String)"raw:'green'"))) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:m");
        Assert.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:-M");
        Assert.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:0");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:<'foo'>");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:M");
        Assert.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerialize() {
        Version v = null;
        v = Version.create((String)"raw:1");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.9");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.'r12345'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.'r12345.hello'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.m");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.-M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:0");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:0.1.2.3.4.5.6.7.8.9");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:123456789.-1234567890");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:123456789.-1234567890");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:m");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:-M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.m");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.-M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'a'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:\"a\"");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'ab'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'abcdefghijklmnopqrstuvwxyz0123456789'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'-_!\"#$%&/()=?+*;,:.'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:\"'\"");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'\"'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:{green,^blue,yellow}");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.{dev,^alpha,beta}");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    @Test
    public void testVersionString() {
        Version v = null;
        String s = null;
        s = "raw:1";
        v = Version.create((String)"raw:1");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0";
        v = Version.create((String)"raw:1.0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.0";
        v = Version.create((String)"raw:1.0.0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.0.9";
        v = Version.create((String)"raw:1.0.0.9");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.0.'r12345'";
        v = Version.create((String)"raw:1.0.0.'r12345'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.0.'r12345.hello'";
        v = Version.create((String)"raw:1.0.0.'r12345.hello'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.m";
        v = Version.create((String)"raw:1.0.m");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.M";
        v = Version.create((String)"raw:1.0.M");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0.M";
        v = Version.create((String)"raw:1.0.M");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        v = Version.create((String)"raw:1.0.-M");
        Assert.assertNotNull((Object)v);
        s = "raw:1.0";
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:0";
        v = Version.create((String)"raw:0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:0.1.2.3.4.5.6.7.8.9";
        v = Version.create((String)"raw:0.1.2.3.4.5.6.7.8.9");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9";
        v = Version.create((String)"raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:123456789.-1234567890";
        v = Version.create((String)"raw:123456789.-1234567890");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:123456789.-1234567890";
        v = Version.create((String)"raw:123456789.-1234567890");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:m";
        v = Version.create((String)"raw:m");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:M";
        v = Version.create((String)"raw:M");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:-M";
        v = Version.create((String)"raw:-M");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"0.0.0", (Object)v.toString());
        s = "raw:1.m";
        v = Version.create((String)"raw:1.m");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.M";
        v = Version.create((String)"raw:1.M");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        v = Version.create((String)"raw:1.-M");
        Assert.assertNotNull((Object)v);
        s = "raw:1";
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:'a'";
        v = Version.create((String)"raw:'a'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:\"a\"";
        v = Version.create((String)"raw:\"a\"");
        Assert.assertNotNull((Object)v);
        s = "raw:'a'";
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:'ab'";
        v = Version.create((String)"raw:'ab'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:'abcdefghijklmnopqrstuvwxyz0123456789'";
        v = Version.create((String)"raw:'abcdefghijklmnopqrstuvwxyz0123456789'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'";
        v = Version.create((String)"raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:'-_!\"#$%&/()=?+*;,:.'";
        v = Version.create((String)"raw:'-_!\"#$%&/()=?+*;,:.'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:\"'\"";
        v = Version.create((String)"raw:\"'\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:'\"'";
        v = Version.create((String)"raw:'\"'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
    }

    @Test
    public void testIntegerParsing() {
        Version v = Version.create((String)"raw:0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)0);
        v = Version.create((String)"raw:0.1.2.3.4.5.6.7.8.9");
        Assert.assertNotNull((Object)v);
        int i = 0;
        while (i < 10) {
            Assert.assertEquals((Object)v.getSegment(i), (Object)i);
            ++i;
        }
        v = Version.create((String)"raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9");
        Assert.assertNotNull((Object)v);
        i = 0;
        while (i < 10) {
            Assert.assertEquals((Object)v.getSegment(i), (Object)(-i));
            ++i;
        }
        v = Version.create((String)"raw:123456789.-1234567890");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)123456789);
        Assert.assertEquals((Object)v.getSegment(1), (Object)-1234567890);
    }

    @Test
    public void testWhiteSpaceExceptions() {
        Assert.assertThrows((String)"space not allowed 1", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw: 0 ");
        });
        Assert.assertThrows((String)"space not allowed 2", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:0 .1  . 'a'.   'b c d'. 4. 5. 6.   7. 8 .  9");
        });
        Assert.assertThrows((String)"space not allowed in array 1", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:< 1.2.3>");
        });
        Assert.assertThrows((String)"space not allowed in array 2", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:<1.2.3 >");
        });
        Assert.assertThrows((String)"Uncaught error: space between minus and number in negative", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1.- 1");
        });
    }

    @Test
    public void testMaxParsing() {
        Assert.assertNotNull((Object)Version.create((String)"raw:m"));
        Assert.assertNotNull((Object)Version.create((String)"raw:M"));
        Assert.assertNotNull((Object)Version.create((String)"raw:-M"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.m"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.M"));
        Assert.assertNotNull((Object)Version.create((String)"raw:1.-M"));
    }

    @Test
    public void testStringParsing() {
        Version v = Version.create((String)"raw:'a'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"a");
        v = Version.create((String)"raw:\"a\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"a");
        v = Version.create((String)"raw:'ab'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"ab");
        v = Version.create((String)"raw:'abcdefghijklmnopqrstuvwxyz0123456789'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"abcdefghijklmnopqrstuvwxyz0123456789");
        v = Version.create((String)"raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
        v = Version.create((String)"raw:'-_!\"#$%&/()=?+*;,:.'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"-_!\"#$%&/()=?+*;,:.");
        v = Version.create((String)"raw:\"'\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"'");
        v = Version.create((String)"raw:'\"'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"\"");
    }

    @Test
    public void testEmptyStringParsing() {
        Version v = Version.create((String)"raw:''");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"");
        v = Version.create((String)"raw:\"\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"");
    }

    @Test
    public void testStringConcatenation() {
        Version v = Version.create((String)"raw:'ab''cd'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"abcd");
        v = Version.create((String)"raw:'ab'\"cd\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"abcd");
        v = Version.create((String)"raw:\"ab\"\"cd\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"abcd");
    }

    @Test
    public void testStringToString() {
        Assert.assertEquals((Object)"raw:'abcd'", (Object)Version.create((String)"raw:'ab''cd'").toString());
        Assert.assertEquals((Object)"raw:'abcd'", (Object)Version.create((String)"raw:'ab'\"cd\"").toString());
        Assert.assertEquals((Object)"raw:'abcd'", (Object)Version.create((String)"raw:\"ab\"\"cd\"").toString());
        Assert.assertEquals((Object)"raw:\"'\"", (Object)Version.create((String)"raw:\"'\"").toString());
        Assert.assertEquals((Object)"raw:'\"'", (Object)Version.create((String)"raw:'\"'").toString());
        Assert.assertEquals((Object)"raw:'abc\"xxx\"and '\"'yyy'\"", (Object)Version.create((String)"raw:'abc\"xxx\"'\"and 'yyy'\"").toString());
    }

    @Test
    public void testArrayParsing() {
        Version v = null;
        v = Version.create((String)"raw:<1>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1)}, null));
        v = Version.create((String)"raw:<1.0>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(0)}, null));
        v = Version.create((String)"raw:<'a'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{"a"}, null));
        v = Version.create((String)"raw:<'a'.'b'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{"a", "b"}, null));
        v = Version.create((String)"raw:<'a'.'b''c'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{"a", "bc"}, null));
        v = Version.create((String)"raw:<1.2.-M>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2)}, null));
        v = Version.create((String)"raw:<1.2.m>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2), VersionVector.MAXS_VALUE}, null));
        v = Version.create((String)"raw:<1.2.M>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2), VersionVector.MAX_VALUE}, null));
        v = Version.create((String)"raw:<<1>>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{new VersionVector(new Comparable[]{Integer.valueOf(1)}, null)}, null));
        v = Version.create((String)"raw:<<1.<2>>>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{new VersionVector(new Comparable[]{Integer.valueOf(1), new VersionVector(new Comparable[]{Integer.valueOf(2)}, null)}, null)}, null));
    }

    @Test
    public void testArraySerialize() {
        Version v = null;
        v = Version.create((String)"raw:<1>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.0>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<'a'>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<'a'.'b'>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<'a'.'b''c'>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.2.-M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.2.m>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.2.M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<<1>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<<1.<2>>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    @Test
    public void testArraytoString() {
        Version v = null;
        String s = null;
        s = "raw:<1>";
        v = Version.create((String)"raw:<1>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<1.0>";
        v = Version.create((String)"raw:<1.0>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<'a'>";
        v = Version.create((String)"raw:<'a'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<'a'.'b'>";
        v = Version.create((String)"raw:<'a'.'b'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<'a'.'bc'>";
        v = Version.create((String)"raw:<'a'.'bc'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        v = Version.create((String)"raw:<1.2.-M>");
        Assert.assertNotNull((Object)v);
        s = "raw:<1.2>";
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<1.2.m>";
        v = Version.create((String)"raw:<1.2.m>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<1.2.M>";
        v = Version.create((String)"raw:<1.2.M>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<<1>>";
        v = Version.create((String)"raw:<<1>>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:<<1.<2>>>";
        v = Version.create((String)"raw:<<1.<2>>>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
    }

    @Test
    public void testArrayOrder() {
        Version v1 = Version.create((String)"raw:<1.0.0>");
        Version v2 = Version.create((String)"raw:<1.1.0>");
        Version v3 = Version.create((String)"raw:<1.0.0>.<1.0.0>");
        Version v4 = Version.create((String)"raw:<1.0.0>.<1.0.0>.'a'");
        Version v5 = Version.create((String)"raw:<1.0.0>.<1.0.1>");
        Version v6 = Version.create((String)"raw:<2.0.0>");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
    }

    @Test
    public void testPadParsing1() {
        Version v = null;
        v = Version.create((String)"raw:1.0p0");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:0");
        v = Version.create((String)"raw:1.0p'foo'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:'foo'");
        v = Version.create((String)"raw:1.0p<0>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0>");
        v = Version.create((String)"raw:1.0p<'foo'>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<'foo'>");
        v = Version.create((String)"raw:1.0pm");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:m");
        v = Version.create((String)"raw:1.0pM");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:M");
        v = Version.create((String)"raw:1.0p-M");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getPad(), null);
        v = Version.create((String)"raw:1.0p<m>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<m>");
        v = Version.create((String)"raw:1.0p<M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<M>");
        v = Version.create((String)"raw:1.0p<-M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<-M>");
        v = Version.create((String)"raw:1.0p<1.0.0.'r12345'.m>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<1.0.0.'r12345'.m>");
    }

    @Test
    public void testPadSerialize() {
        Version v = null;
        v = Version.create((String)"raw:1.0p0");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p'foo'");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<'foo'>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0pm");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0pM");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p-M");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<m>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<-M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<1.0.0.'r12345'.m>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    @Test
    public void testPadtoString() {
        Version v = null;
        String s = null;
        v = Version.create((String)"raw:1.0p0");
        Assert.assertNotNull((Object)v);
        s = "raw:1p0";
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p'foo'";
        v = Version.create((String)"raw:1.0p'foo'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0>";
        v = Version.create((String)"raw:1.0p<0>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<'foo'>";
        v = Version.create((String)"raw:1.0p<'foo'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0pm";
        v = Version.create((String)"raw:1.0pm");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0pM";
        v = Version.create((String)"raw:1.0pM");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        v = Version.create((String)"raw:1.0p-M");
        Assert.assertNotNull((Object)v);
        s = "raw:1.0";
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<m>";
        v = Version.create((String)"raw:1.0p<m>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<M>";
        v = Version.create((String)"raw:1.0p<M>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<-M>";
        v = Version.create((String)"raw:1.0p<-M>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<1.0.0.'r12345'.m>";
        v = Version.create((String)"raw:1.0p<1.0.0.'r12345'.m>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
    }

    @Test
    public void testNestedPadParsing() {
        Version v = null;
        v = Version.create((String)"raw:1.0p<0p0>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p0>");
        this.assertPadPad(v, "raw:0");
        v = Version.create((String)"raw:1.0p<0p'foo'>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p'foo'>");
        this.assertPadPad(v, "raw:'foo'");
        v = Version.create((String)"raw:1.0p<0p<0>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p<0>>");
        this.assertPadPad(v, "raw:<0>");
        v = Version.create((String)"raw:1.0p<0p<'foo'>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p<'foo'>>");
        this.assertPadPad(v, "raw:<'foo'>");
        v = Version.create((String)"raw:1.0p<0pm>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0pm>");
        this.assertPadPad(v, "raw:m");
        v = Version.create((String)"raw:1.0p<0pM>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0pM>");
        this.assertPadPad(v, "raw:M");
        v = Version.create((String)"raw:1.0p<0p-M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p-M>");
        this.assertPadPad(v, null);
        Assert.assertEquals((Object)((VersionVector)v.getPad()).getPad(), null);
        v = Version.create((String)"raw:1.0p<0p<m>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p<m>>");
        this.assertPadPad(v, "raw:<m>");
        v = Version.create((String)"raw:1.0p<0pM>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0pM>");
        this.assertPadPad(v, "raw:M");
        v = Version.create((String)"raw:1.0p<0p-M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p-M>");
        this.assertPadPad(v, null);
    }

    @Test
    public void testNestedPadSerialize() {
        Version v = null;
        v = Version.create((String)"raw:1.0p<0p0>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p'foo'>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p<0>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p<'foo'>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0pm>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0pM>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p-M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p<m>>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0pM>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p-M>");
        Assert.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    @Test
    public void testNestedPadtoString() {
        Version v = null;
        String s = null;
        s = "raw:1.0p<0p0>";
        v = Version.create((String)"raw:1.0p<0p0>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0p'foo'>";
        v = Version.create((String)"raw:1.0p<0p'foo'>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0p<0>>";
        v = Version.create((String)"raw:1.0p<0p<0>>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0p<'foo'>>";
        v = Version.create((String)"raw:1.0p<0p<'foo'>>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0pm>";
        v = Version.create((String)"raw:1.0p<0pm>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0pM>";
        v = Version.create((String)"raw:1.0p<0pM>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        v = Version.create((String)"raw:1.0p<0p-M>");
        Assert.assertNotNull((Object)v);
        s = "raw:1.0p<0>";
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0p<m>>";
        v = Version.create((String)"raw:1.0p<0p<m>>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        s = "raw:1.0p<0pM>";
        v = Version.create((String)"raw:1.0p<0pM>");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)s, (Object)v.toString());
        v = Version.create((String)"raw:1.0p<0p-M>");
        Assert.assertNotNull((Object)v);
        s = "raw:1.0p<0>";
        Assert.assertEquals((Object)s, (Object)v.toString());
    }

    @Test
    public void testPadOrder() {
        Version v1 = Version.create((String)"raw:1p-M");
        Version v2 = Version.create((String)"raw:1.0.0");
        Version v3 = Version.create((String)"raw:1.0.0p0");
        Version v4 = Version.create((String)"raw:1p0");
        Version v5 = Version.create((String)"raw:1.1");
        Version v6 = Version.create((String)"raw:1.1.1");
        Version v7 = Version.create((String)"raw:1p1");
        Version v8 = Version.create((String)"raw:1.1p1");
        Version v9 = Version.create((String)"raw:1pM");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        Assert.assertEquals((Object)v3, (Object)v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
        Assert.assertEquals((Object)v7, (Object)v8);
        RawVersionTest.assertOrder(v8, v9);
    }

    @Test
    public void testPadTypeOrder() {
        Version v0 = Version.create((String)"raw:1p-M");
        Version v1 = Version.create((String)"raw:1p'a'");
        Version v2 = Version.create((String)"raw:1p<0>");
        Version v3 = Version.create((String)"raw:1.0.0");
        Version v4 = Version.create((String)"raw:1p0");
        Version v5 = Version.create((String)"raw:1p1");
        Version v6 = Version.create((String)"raw:1pM");
        RawVersionTest.assertOrder(v0, v1);
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
    }

    @Test
    public void testOriginalTerminator() {
        Version v = Version.create((String)"raw:'/'");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"/");
        v = Version.create((String)"raw:\"/\"");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v.getSegment(0), (Object)"/");
    }

    @Test
    public void testEmptyInput() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:");
        });
    }

    @Test
    public void testNewLine() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1.'\n'.2");
        });
    }

    @Test
    public void testSpaceInInt() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1 2.2");
        });
    }

    @Test
    public void testFloatingPointl() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1,2.2");
        });
    }

    @Test
    public void testScientific() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1E3");
        });
    }

    @Test
    public void testHex() {
        Assert.assertThrows((String)"Uncaught error: hexadecimal not allowed", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:0xABCD");
        });
    }

    @Test
    public void testUnbalancedSingleQuoteRight() {
        Assert.assertThrows((String)"Uncaught error: unbalanced sngle quote", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:'unbalanced");
        });
    }

    @Test
    public void testMixedQuotes1() {
        Assert.assertThrows((String)"Uncaught error: mixed quotes", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1.\"unbalanced'.10");
        });
    }

    @Test
    public void testMixedQuotes2() {
        Assert.assertThrows((String)"Uncaught error: mixed quotes", IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1.'unbalanced\".10");
        });
    }

    @Test
    public void testUnbalancedDoubleQuoteRight() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:\"unbalanced");
        });
    }

    @Test
    public void testUnbalancedArrayRight() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:<1.2.3");
        });
    }

    @Test
    public void testUnbalancedArrayLeft() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1.2.3>");
        });
    }

    @Test
    public void testBadDecimalInteger() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:12af");
        });
    }

    @Test
    public void testUnquotedStringFirstValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:a");
        });
    }

    @Test
    public void testUnquotedStringSecondValue() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:1.a");
        });
    }

    @Test
    public void testSinglePeriod() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:.");
        });
    }

    @Test
    public void testTwoPeriods() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:..");
        });
    }

    @Test
    public void testThreePeriods() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:...");
        });
    }

    @Test
    public void testPadNotLast() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:p10.10");
        });
    }

    @Test
    public void testEmptyPad() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10p");
        });
    }

    @Test
    public void testPadWithNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10p.");
        });
    }

    @Test
    public void testWrongPadSeparator() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10.p0");
        });
    }

    @Test
    public void testMultiplePadElements() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10p1.2");
        });
    }

    @Test
    public void testUnbalancedPadElementsSQ() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10p'abc");
        });
    }

    @Test
    public void testUnbalancedPadElementsDQ() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10p\"abc");
        });
    }

    @Test
    public void testUnbalancedPadArrayElementsRight() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10p<10");
        });
    }

    @Test
    public void testUnbalancedPadArrayElementsLeft() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.create((String)"raw:10p10>");
        });
    }

    @Test
    public void testOrder() {
        Version v1 = Version.create((String)"raw:1");
        Version v2 = Version.create((String)"raw:1.0");
        Version v3 = Version.create((String)"raw:1.0.0");
        Version v4 = Version.create((String)"raw:1.0.0.'9'");
        Version v5 = Version.create((String)"raw:1.0.0.'r12345'");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
    }

    @Test
    public void testTypeOrder() {
        Version v0 = Version.create((String)"raw:-M");
        Version v1 = Version.create((String)"raw:''");
        Version v2 = Version.create((String)"raw:'z'");
        Version v3 = Version.create((String)"raw:m");
        Version v4 = Version.create((String)"raw:<0>");
        Version v5 = Version.create((String)"raw:<M>");
        Version v6 = Version.create((String)"raw:0");
        Version v7 = Version.create((String)"raw:M");
        RawVersionTest.assertOrder(v0, v1);
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
    }

    @Test
    public void testTypeOrder2() {
        Version v0 = Version.create((String)"raw:0.-M");
        Version v1 = Version.create((String)"raw:0.''");
        Version v2 = Version.create((String)"raw:0.'z'");
        Version v3 = Version.create((String)"raw:0.m");
        Version v4 = Version.create((String)"raw:0.<0>");
        Version v5 = Version.create((String)"raw:0.<M>");
        Version v6 = Version.create((String)"raw:0.0");
        Version v7 = Version.create((String)"raw:0.M");
        RawVersionTest.assertOrder(v0, v1);
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
    }

    @Test
    public void testShorterIsOlder() {
        Version v1 = Version.create((String)"raw:1.0");
        Version v2 = Version.create((String)"raw:1.0.0");
        Version v3 = Version.create((String)"raw:1.0.0.0");
        Version v4 = Version.create((String)"raw:'a'");
        Version v5 = Version.create((String)"raw:'a'.'b'.'b'");
        Version v6 = Version.create((String)"raw:'a'.'b'.'b'.'b'");
        Version v7 = Version.create((String)"raw:<1>");
        Version v8 = Version.create((String)"raw:<1>.<0>.<0>");
        Version v9 = Version.create((String)"raw:<1>.<0>.<0>.<0>");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v7, v8);
        RawVersionTest.assertOrder(v8, v9);
    }

    @Test
    public void testNumericVersionOrder() {
        Version v1 = Version.create((String)"1");
        Version v2 = Version.create((String)"1.0.1");
        Version v3 = Version.create((String)"1.1");
        Version v4 = Version.create((String)"1.1.1");
        Version v5 = Version.create((String)"1.1.1.-");
        Version v6 = Version.create((String)"1.2");
        Version v7 = Version.create((String)"2");
        Version v8 = Version.create((String)"10.0");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
        RawVersionTest.assertOrder(v7, v8);
    }
}

