/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;
import org.junit.Assert;
import org.junit.Test;

public class RawWithOriginalTest
extends VersionTesting {
    @Test
    public void testRawWithUnknownFormat() {
        Version v = Version.parseVersion((String)"raw:1.0/:silver.moon");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v, (Object)Version.parseVersion((String)"raw:1.0"));
    }

    @Test
    public void testRawWithUnknownFormatToString() {
        Assert.assertEquals((Object)"raw:1.0/:silver.moon", (Object)Version.parseVersion((String)"raw:1.0/:silver.moon").toString());
    }

    @Test
    public void testRawWithUnknownFormatSerialized() {
        RawWithOriginalTest.assertSerialized(Version.parseVersion((String)"raw:1.0/:silver.moon"));
        Assert.assertEquals((Object)"raw:1.0/:silver.moon", (Object)RawWithOriginalTest.getSerialized(Version.create((String)"raw:1.0/:silver.moon")).toString());
    }

    @Test
    public void testRawWithSimpleFormat() {
        Version v = Version.parseVersion((String)"raw:1.0/format(n.n):1.0");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)v, (Object)Version.parseVersion((String)"raw:1.0"));
    }

    @Test
    public void testRawWithSimpleFormatToString() {
        Assert.assertEquals((Object)"raw:1.0/format(n.n):1.0", (Object)Version.parseVersion((String)"raw:1.0/format(n.n):1.0").toString());
    }

    @Test
    public void testRawWithSimpleFormatSerialized() {
        RawWithOriginalTest.assertSerialized(Version.parseVersion((String)"raw:1.0/format(n.n):1.0"));
        Assert.assertEquals((Object)"raw:1.0/format(n.n):1.0", (Object)RawWithOriginalTest.getSerialized(Version.create((String)"raw:1.0/format(n.n):1.0")).toString());
    }

    @Test
    public void testOriginalStatedButMissing() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/");
        });
    }

    @Test
    public void testOriginalAndUnknownStatedButMissing() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/:");
        });
    }

    @Test
    public void testOriginalIllegalFormat() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/foo:");
        });
    }

    @Test
    public void testOriginalIllegalFormat2() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/100:");
        });
    }

    @Test
    public void testOriginalIllegalFormat3() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/'format':");
        });
    }

    @Test
    public void testOriginalIllegalFormat4() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0//1.0");
        });
    }

    @Test
    public void testOriginalIllegalFormat5() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/format:");
        });
    }

    @Test
    public void testOriginalFormatUnbalancedLeft() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/formatn.n):");
        });
    }

    @Test
    public void testOriginalFormatUnbalancedRight() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/format(n.n:1.0");
        });
    }

    @Test
    public void testOriginalFormatOriginalMissing() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Version version = Version.parseVersion((String)"raw:1.0/format(n.n):");
        });
    }
}

