/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.equinox.internal.p2.metadata.VersionVector;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.junit.Assert;

public class VersionTesting {
    public void assertIncludedInRange(String message, VersionRange range, String versionString) {
        Assert.assertTrue((String)message, (boolean)range.isIncluded(Version.parseVersion((String)versionString)));
    }

    public void assertNotIncludedInRange(String message, VersionRange range, String versionString) {
        Assert.assertFalse((String)message, (boolean)range.isIncluded(Version.parseVersion((String)versionString)));
    }

    public void assertBounds(String rangeSpecification, boolean includeMin, Version lowerBound, Version upperBound, boolean includeMax) {
        VersionRange range = new VersionRange(rangeSpecification);
        Assert.assertEquals((Object)includeMin, (Object)range.getIncludeMinimum());
        Assert.assertEquals((Object)includeMax, (Object)range.getIncludeMaximum());
        Assert.assertEquals((Object)lowerBound, (Object)range.getMinimum());
        Assert.assertEquals((Object)upperBound, (Object)range.getMaximum());
    }

    public static void assertOrder(Object a, Object b) {
        if (!(a instanceof Comparable) || !(b instanceof Comparable)) {
            Assert.fail((String)"can not assert order on non Comparable instances");
        }
        if (((Comparable)a).compareTo(b) > 0) {
            Assert.fail((String)"a > b");
        } else if (((Comparable)b).compareTo(a) < 0) {
            Assert.fail((String)"b < a");
        } else if (((Comparable)b).compareTo(a) == 0) {
            Assert.fail((String)"b == a");
        } else if (((Comparable)a).compareTo(b) == 0) {
            Assert.fail((String)"a == b");
        }
        Assert.assertTrue((boolean)true);
    }

    public static void assertPad(Version v, String rawVersionString) {
        Assert.assertNotNull((Object)v);
        Comparable cmp = null;
        if (rawVersionString != null) {
            Version v2 = Version.create((String)rawVersionString);
            Assert.assertNotNull((Object)v2);
            Assert.assertTrue((v2.getSegmentCount() == 1 ? 1 : 0) != 0);
            cmp = v2.getSegment(0);
        }
        Assert.assertEquals((Object)v.getPad(), cmp);
    }

    public void assertPadPad(Version v, String rawVersionString) {
        Assert.assertNotNull((Object)v);
        Comparable pad = v.getPad();
        Assert.assertTrue((boolean)(pad instanceof VersionVector));
        Comparable cmp = null;
        if (rawVersionString != null) {
            Version v2 = Version.create((String)rawVersionString);
            Assert.assertNotNull((Object)v2);
            Assert.assertTrue((v2.getSegmentCount() == 1 ? 1 : 0) != 0);
            cmp = v2.getSegment(0);
        }
        Assert.assertEquals((Object)((VersionVector)pad).getPad(), cmp);
    }

    public static void assertSerialized(VersionRange range) {
        VersionRange serialized = VersionTesting.getSerialized(range);
        Assert.assertEquals((Object)range, (Object)serialized);
        Assert.assertEquals((Object)range.toString(), (Object)serialized.toString());
    }

    public static VersionRange getSerialized(VersionRange range) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream os = new ObjectOutputStream(out);){
                os.writeObject(range);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            Assert.fail((String)"close of output stream failed");
        }
        ObjectInputStream is = null;
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try {
            is = new ObjectInputStream(in);
        }
        catch (IOException e) {
            Assert.fail((String)"Can not create object input stream");
        }
        VersionRange range2 = null;
        try {
            range2 = (VersionRange)is.readObject();
        }
        catch (IOException e) {
            Assert.fail((String)"IO failure reading version range");
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"ClassNotFountException");
        }
        return range2;
    }

    public static void assertSerialized(Version v) {
        Version serialized = VersionTesting.getSerialized(v);
        Assert.assertEquals((Object)v, (Object)serialized);
        Assert.assertEquals((Object)v.toString(), (Object)serialized.toString());
    }

    public static Version getSerialized(Version v) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream os = new ObjectOutputStream(out);){
                os.writeObject(v);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            Assert.fail((String)"close of output stream failed");
        }
        ObjectInputStream is = null;
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try {
            is = new ObjectInputStream(in);
        }
        catch (IOException e) {
            Assert.fail((String)"Can not create object input stream");
        }
        Version v2 = null;
        try {
            v2 = (Version)is.readObject();
        }
        catch (IOException e) {
            Assert.fail((String)"IO failure reading version range");
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"ClassNotFountException");
        }
        return v2;
    }
}

