/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public abstract class AbstractPlannerTest
extends AbstractProvisioningTest {
    private IProfile profile;
    private File previousStoreValue = null;
    IMetadataRepository repo = null;

    protected abstract String getTestDataPath();

    protected abstract String getProfileId();

    protected IProfile getProfile() {
        return this.profile;
    }

    protected Collection<InstallableUnitOperand> compress(IProvisioningPlan plan) {
        Operand[] operands;
        HashMap<String, InstallableUnitOperand> result = new HashMap<String, InstallableUnitOperand>();
        Operand[] operandArray = operands = ((ProvisioningPlan)plan).getOperands();
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            Operand oper = operandArray[n2];
            if (oper instanceof InstallableUnitOperand) {
                InstallableUnitOperand operand = (InstallableUnitOperand)oper;
                String id = operand.first() == null ? operand.second().getId() : operand.first().getId();
                InstallableUnitOperand existing = (InstallableUnitOperand)result.get(id);
                if (existing == null) {
                    result.put(id, operand);
                } else {
                    IInstallableUnit first = existing.first() == null ? operand.first() : existing.first();
                    IInstallableUnit second = existing.second() == null ? operand.second() : existing.second();
                    result.put(id, new InstallableUnitOperand(first, second));
                }
            }
            ++n2;
        }
        return result.values();
    }

    protected ProvisioningContext getContext(Collection<URI> repoLocations) {
        ProvisioningContext result = new ProvisioningContext(AbstractPlannerTest.getAgent());
        result.setMetadataRepositories(repoLocations == null ? new URI[]{} : repoLocations.toArray(new URI[repoLocations.size()]));
        result.setArtifactRepositories(new URI[0]);
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = AbstractPlannerTest.getTestData("loading planner test data", this.getTestDataPath());
        File tempFolder = this.getTempFolder();
        AbstractPlannerTest.copy("0.2", reporegistry1, tempFolder);
        IProfileRegistry realProfileRegistry = this.getProfileRegistry();
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        this.previousStoreValue = (File)profileStore.get(realProfileRegistry);
        profileStore.set(realProfileRegistry, new File(tempFolder, "p2/org.eclipse.equinox.p2.engine/profileRegistry"));
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        this.profile = realProfileRegistry.getProfile(this.getProfileId());
        AbstractPlannerTest.assertNotNull((Object)this.profile);
        this.repo = this.loadMetadataRepository(AbstractPlannerTest.getTestData("planner test repo", this.getTestDataPath() + "/repo").toURI());
    }

    @Override
    protected void tearDown() throws Exception {
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        profileStore.set(realProfileRegistry, this.previousStoreValue);
        super.tearDown();
    }

    protected IProfileChangeRequest createProfileChangeRequest(Collection<IInstallableUnit> optionalAdds, Collection<IInstallableUnit> strictAdds, Collection<IInstallableUnit> toRemove) {
        ProfileChangeRequest result = new ProfileChangeRequest(this.profile);
        if (optionalAdds != null) {
            for (IInstallableUnit iu : optionalAdds) {
                result.add(iu);
                result.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
                result.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock", "1");
                result.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.reconciler.dropins", "true");
            }
        }
        if (strictAdds != null) {
            for (IInstallableUnit iu : strictAdds) {
                result.add(iu);
                result.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)iu));
            }
        }
        if (toRemove != null) {
            for (IInstallableUnit iu : toRemove) {
                result.remove(iu);
            }
        }
        return result;
    }

    protected void assertContains(String message, IProvisioningPlan expectedPlan, IProvisioningPlan actualPlan) {
        Operand[] expectedOperands = ((ProvisioningPlan)expectedPlan).getOperands();
        Operand[] actualOperands = ((ProvisioningPlan)actualPlan).getOperands();
        AbstractPlannerTest.assertFalse((String)"0.9 Plan is empty.", (expectedOperands.length == 0 ? 1 : 0) != 0);
        Operand[] operandArray = expectedOperands;
        int n = expectedOperands.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Operand expectedOperand = operandArray[n2];
                if (!(expectedOperand instanceof InstallableUnitOperand)) break block7;
                IInstallableUnit first = ((InstallableUnitOperand)expectedOperand).first();
                IInstallableUnit second = ((InstallableUnitOperand)expectedOperand).second();
                boolean found = false;
                Operand[] operandArray2 = actualOperands;
                int n3 = actualOperands.length;
                int n4 = 0;
                while (n4 < n3) {
                    block8: {
                        InstallableUnitOperand actual;
                        block9: {
                            Operand actualOperand = operandArray2[n4];
                            if (!(actualOperand instanceof InstallableUnitOperand)) break block8;
                            actual = (InstallableUnitOperand)actualOperand;
                            if (second != null) break block9;
                            if (actual.second() != null || !actual.first().getId().equals(first.getId())) break block8;
                            AbstractPlannerTest.assertEquals("0.5", first, actual.first());
                        }
                        AbstractPlannerTest.assertNotNull((String)("1.2 " + String.valueOf(actual)), (Object)actual.second());
                        if (actual.second().getId().equals(second.getId())) {
                            AbstractPlannerTest.assertEquals("2.0", second, actual.second());
                            found = true;
                        }
                    }
                    ++n4;
                }
                if (!found) {
                    AbstractPlannerTest.fail((String)("3.0 Plan is missing install operand for: " + String.valueOf(second)));
                }
            }
            ++n2;
        }
    }
}

