/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AgentPlanTestInRunningInstance
extends AbstractProvisioningTest {
    private IProfile initialProfile = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initialProfile = this.getProfile("_SELF_");
        if (this.initialProfile != null) {
            return;
        }
        this.setUpSelfProfile();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.initialProfile == null) {
            this.tearDownSelfProfile();
        } else {
            IProfile profileAfterTestRun = this.getProfile("_SELF_");
            IProvisioningPlan rollbackPlan = AgentPlanTestInRunningInstance.createPlanner().getDiffPlan(profileAfterTestRun, this.initialProfile, (IProgressMonitor)new NullProgressMonitor());
            AgentPlanTestInRunningInstance.assertOK("rollback plan", rollbackPlan.getStatus());
            AgentPlanTestInRunningInstance.assertOK("rollback execution", PlanExecutionHelper.executePlan((IProvisioningPlan)rollbackPlan, (IEngine)AgentPlanTestInRunningInstance.createEngine(), (ProvisioningContext)new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent()), (IProgressMonitor)new NullProgressMonitor()));
        }
        super.tearDown();
    }

    public void testGetAgentPlanActionNeededButUnavailable() {
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProfile profile = this.getProfile("_SELF_");
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        ProvisioningContext context = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        context.setMetadataRepositories(new URI[0]);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertNotOK(plan.getStatus());
    }

    public void testGetAgentPlanActionNeeded() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInRunningInstance.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1});
        IProfile profile = this.getProfile("_SELF_");
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertTrue((boolean)plan.getStatus().isOK());
        AgentPlanTestInRunningInstance.assertNotNull((Object)plan.getInstallerPlan());
    }

    public void testConflictBetweenActionAndThingBeingInstalled() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInRunningInstance.createIU("Action1", DEFAULT_VERSION, null, AgentPlanTestInRunningInstance.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "A", new VersionRange("[2.0.0, 2.0.0]")), new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IInstallableUnit a2 = AgentPlanTestInRunningInstance.createIU("A", Version.createOSGi((int)2, (int)0, (int)0));
        this.createTestMetdataRepository(new IInstallableUnit[]{a, a2, act1});
        IProfile profile = this.getProfile("_SELF_");
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertNotOK(plan.getStatus());
    }

    public void testSubsequentInstall() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInRunningInstance.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IInstallableUnit b = AgentPlanTestInRunningInstance.createEclipseIU("B");
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1, b});
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        IEngine engine = AgentPlanTestInRunningInstance.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(this.getProfile("_SELF_"));
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("install actions", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act1});
        AgentPlanTestInRunningInstance.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after initial install", this.getProfile("_SELF_"), new IInstallableUnit[]{a, act1});
        AgentPlanTestInRunningInstance.assertEquals((String)this.getProfile("_SELF_").getProfileId(), (String)plan.getInstallerPlan().getProfile().getProfileId());
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.getProfile("_SELF_"));
        request2.addInstallableUnits(new IInstallableUnit[]{b});
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)request2, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertNull((Object)plan2.getInstallerPlan());
        AgentPlanTestInRunningInstance.assertOK("install b", engine.perform(plan2, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after initial install", this.getProfile("_SELF_"), new IInstallableUnit[]{a, act1, b});
    }

    public void testWithOveralInDependency() {
        IInstallableUnit common = AgentPlanTestInRunningInstance.createEclipseIU("Common");
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInRunningInstance.createIU("Action1", DEFAULT_VERSION, null, AgentPlanTestInRunningInstance.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "Common"), new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, AgentPlanTestInRunningInstance.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "Common"), metaReq);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1, common});
        IProfile profile = this.getProfile("_SELF_");
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        IEngine engine = AgentPlanTestInRunningInstance.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("install actions", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act1, common});
        AgentPlanTestInRunningInstance.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{a, common, act1});
    }

    public void testTwoInstallWithActions() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInRunningInstance.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProvidedCapability act2Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action2", (Version)DEFAULT_VERSION);
        IInstallableUnit act2 = AgentPlanTestInRunningInstance.createIU("Action2", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act2Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq2 = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action2", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit b = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("B", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq2);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, b, act1, act2});
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        IEngine engine = AgentPlanTestInRunningInstance.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(this.getProfile("_SELF_"));
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("install actions", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act1});
        AgentPlanTestInRunningInstance.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{a, act1});
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.getProfile("_SELF_"));
        request2.addInstallableUnits(new IInstallableUnit[]{b});
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)request2, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("install actions", engine.perform(plan2.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act2, act1, a});
        AgentPlanTestInRunningInstance.assertOK("install A", engine.perform(plan2, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act2, act1, b, a});
    }

    public void testCompleteScenario() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInRunningInstance.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProvidedCapability act1bCap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1b", (Version)DEFAULT_VERSION);
        IInstallableUnit act1b = AgentPlanTestInRunningInstance.createIU("Action1b", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1bCap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReqb = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1b", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a111 = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", Version.createOSGi((int)1, (int)1, (int)1), true, (IRequirement[])NO_REQUIRES, metaReqb);
        IProvidedCapability act2Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action2", (Version)DEFAULT_VERSION);
        IInstallableUnit act2 = AgentPlanTestInRunningInstance.createIU("Action2", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act2Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq2 = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action2", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit b = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("B", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq2);
        IInstallableUnit c = AgentPlanTestInRunningInstance.createEclipseIU("C");
        this.createTestMetdataRepository(new IInstallableUnit[]{a, b, act1, act2, c, act1b, a111});
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        IEngine engine = AgentPlanTestInRunningInstance.createEngine();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(this.getProfile("_SELF_"));
        request.addInstallableUnits(new IInstallableUnit[]{a});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("install actions for A", engine.perform(plan.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act1});
        AgentPlanTestInRunningInstance.assertOK("install A", engine.perform(plan, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{a, act1});
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.getProfile("_SELF_"));
        request2.addInstallableUnits(new IInstallableUnit[]{b});
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)request2, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("install actions for B", engine.perform(plan2.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act2, act1, a});
        AgentPlanTestInRunningInstance.assertOK("install B", engine.perform(plan2, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act2, act1, b, a});
        ProfileChangeRequest requestForC = new ProfileChangeRequest(this.getProfile("_SELF_"));
        requestForC.addInstallableUnits(new IInstallableUnit[]{c});
        IProvisioningPlan planForC = planner.getProvisioningPlan((IProfileChangeRequest)requestForC, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertNull((Object)planForC.getInstallerPlan());
        AgentPlanTestInRunningInstance.assertOK("install C", engine.perform(planForC, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after C", this.getProfile("_SELF_"), new IInstallableUnit[]{act1, act2, a, b, c});
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act2, act1, b, a});
        ProfileChangeRequest requestUpdateA = new ProfileChangeRequest(this.getProfile("_SELF_"));
        requestUpdateA.removeInstallableUnits(new IInstallableUnit[]{a});
        requestUpdateA.addInstallableUnits(new IInstallableUnit[]{a111});
        IProvisioningPlan planUpdateA = planner.getProvisioningPlan((IProfileChangeRequest)requestUpdateA, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("Checking planUpdateA", planUpdateA.getStatus());
        AgentPlanTestInRunningInstance.assertOK("install actions for A 1.1.1", engine.perform(planUpdateA.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act1, act1b});
        AgentPlanTestInRunningInstance.assertOK("install A", engine.perform(planUpdateA, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act1b, a111, b, c});
        AgentPlanTestInRunningInstance.assertTrue((boolean)this.getProfile("_SELF_").query(QueryUtil.createIUQuery((String)"Action1", (Version)DEFAULT_VERSION), null).isEmpty());
        ProfileChangeRequest request3 = new ProfileChangeRequest(this.getProfile("_SELF_"));
        request3.removeInstallableUnits(new IInstallableUnit[]{a111});
        IProvisioningPlan plan3 = planner.getProvisioningPlan((IProfileChangeRequest)request3, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertOK("install actions", engine.perform(plan3.getInstallerPlan(), null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{act1b});
        AgentPlanTestInRunningInstance.assertOK("install A", engine.perform(plan3, null));
        AgentPlanTestInRunningInstance.assertProfileContainsAll("Checking profile after install of actions", this.getProfile("_SELF_"), new IInstallableUnit[]{c, b, act2});
    }

    public void testConflictBetweenActions() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = AgentPlanTestInRunningInstance.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        IProvidedCapability act1v2Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action2", (Version)Version.createOSGi((int)2, (int)0, (int)0));
        IInstallableUnit act1v2 = AgentPlanTestInRunningInstance.createIU("Action1", Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1v2Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReqd = AgentPlanTestInRunningInstance.createRequiredCapabilities("p2.action", "action2", new VersionRange("[2.0.0, 2.0.0]"));
        IInstallableUnit d = AgentPlanTestInRunningInstance.createIUWithMetaRequirement("D", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReqd);
        this.createTestMetdataRepository(new IInstallableUnit[]{a, act1, d, act1v2});
        IProfile profile = this.getProfile("_SELF_");
        IPlanner planner = AgentPlanTestInRunningInstance.createPlanner();
        ProvisioningContext ctx = new ProvisioningContext(AgentPlanTestInRunningInstance.getAgent());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{a, d});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        AgentPlanTestInRunningInstance.assertNotOK(plan.getStatus());
    }
}

