/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AllOrbit
extends AbstractProvisioningTest {
    IProfile profile1;
    IPlanner planner;
    IEngine engine;
    IMetadataRepository repo;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)AllOrbit.getAgent().getService(IMetadataRepositoryManager.class);
        this.repo = repoMan.loadRepository(AllOrbit.getTestData("repository for wsdl test", "testData/orbitRepo/").toURI(), (IProgressMonitor)new NullProgressMonitor());
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = AllOrbit.createPlanner();
        this.engine = AllOrbit.createEngine();
    }

    public void testInstallTwoVersionsOptionaly() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        IQueryResult allIUs = this.repo.query(QueryUtil.createIUAnyQuery(), null);
        req1.addInstallableUnits((IInstallableUnit[])allIUs.toArray(IInstallableUnit.class));
        for (IInstallableUnit iu : allIUs) {
            if (iu.getId().equals("javax.wsdl")) continue;
            req1.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
        }
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        AllOrbit.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }

    public void test2() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        IQueryResult allIUs = this.repo.query(QueryUtil.createIUAnyQuery(), null);
        ArrayList<IInstallableUnit> toInstall = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit toAdd : allIUs) {
            if (toAdd.getId().equals("com.ibm.icu")) continue;
            toInstall.add(toAdd);
        }
        req1.addInstallableUnits(toInstall.toArray(new IInstallableUnit[toInstall.size()]));
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        AllOrbit.assertEquals((int)178, (int)this.countPlanElements(plan1));
        AllOrbit.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }

    public void test3() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        IQueryResult allIUs = this.repo.query(QueryUtil.createIUAnyQuery(), null);
        ArrayList<IInstallableUnit> toInstall = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit toAdd : allIUs) {
            if (toAdd.getId().equals("com.ibm.icu")) continue;
            toInstall.add(toAdd);
            req1.setInstallableUnitInclusionRules(toAdd, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)toAdd));
        }
        req1.addInstallableUnits(toInstall.toArray(new IInstallableUnit[toInstall.size()]));
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        AllOrbit.assertEquals((int)178, (int)this.countPlanElements(plan1));
        AllOrbit.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }
}

