/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug252682
extends AbstractProvisioningTest {
    IProfile profile = null;
    ArrayList<IInstallableUnit> newIUs = new ArrayList();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug252682.getTestData("test data bug 252682", "testData/bug252682");
        File tempFolder = this.getTempFolder();
        Bug252682.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(Bug252682.getAgent(), tempFolder, null, false);
        this.profile = registry.getProfile("Bug252682");
        Bug252682.assertNotNull((Object)this.profile);
        this.newIUs.add(Bug252682.createEclipseIU("org.eclipse.equinox.p2.core", Version.createOSGi((int)1, (int)0, (int)100, (String)"v20081024")));
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        IProvisioningPlan plan = Bug252682.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, null, null);
        Bug252682.assertOK("validate profile", plan.getStatus());
    }

    public void testInstallFeaturePatch() {
        IInstallableUnit p2Feature = (IInstallableUnit)this.profile.query(QueryUtil.createIUQuery((String)"org.eclipse.equinox.p2.user.ui.feature.group"), (IProgressMonitor)new NullProgressMonitor()).iterator().next();
        System.out.println(p2Feature);
        IQueryResult c = this.profile.query(QueryUtil.createIUQuery((String)"org.eclipse.equinox.p2.core.patch"), (IProgressMonitor)new NullProgressMonitor());
        Bug252682.assertEquals((int)1, (int)Bug252682.queryResultSize(c));
        ProvisioningContext ctx = new ProvisioningContext(Bug252682.getAgent());
        ctx.setExtraInstallableUnits(this.newIUs);
        IInstallableUnit patch = (IInstallableUnit)c.iterator().next();
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.removeInstallableUnits(new IInstallableUnit[]{patch});
        IPlanner planner = Bug252682.createPlanner();
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        Bug252682.assertOK("Installation plan", plan.getStatus());
    }
}

