/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug278668
extends AbstractProvisioningTest {
    private IProfile profile;
    private IMetadataRepository repo;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile("test278668");
        IEngine engine = Bug278668.createEngine();
        IPlanner planner = Bug278668.createPlanner();
        ArrayList<IInstallableUnit> target = new ArrayList<IInstallableUnit>();
        target.add(Bug278668.createEclipseIU("com.borland.tg.modelrenaming"));
        target.add(Bug278668.createEclipseIU("com.borland.tg.xmldesign"));
        target.add(Bug278668.createEclipseIU("com.tssap.selena.dom"));
        target.add(Bug278668.createEclipseIU("com.tssap.selena.model.providers.rc"));
        target.add(Bug278668.createEclipseIU("com.tssap.selena.model.providers.resources"));
        target.add(Bug278668.createEclipseIUSingleton("com.tssap.selena.model", DEFAULT_VERSION));
        target.add(Bug278668.createEclipseIU("com.borland.tg.modelrenaming", Version.create((String)"8.1.2.v20090422-1800")));
        target.add(Bug278668.createEclipseIU("com.borland.tg.xmldesign", Version.create((String)"8.2.0.v20090422-1800")));
        target.add(Bug278668.createEclipseIU("com.tssap.selena.dom", Version.create((String)"8.2.0.v20090422-1800")));
        target.add(Bug278668.createEclipseIU("com.tssap.selena.model.providers.rc", Version.create((String)"8.2.0.v20090422-1800")));
        target.add(Bug278668.createEclipseIU("com.tssap.selena.model.providers.resources", Version.create((String)"8.1.2.v20090422-1800")));
        target.add(Bug278668.createEclipseIU("com.tssap.selena.model", Version.create((String)"8.1.5.v20090422-1800")));
        target.add(Bug278668.createEclipseIUSingleton("com.tssap.selena.dom", Version.create((String)"8.2.0.v20090326-1800")));
        this.createTestMetdataRepository(target.toArray(new IInstallableUnit[target.size()]));
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"com.borland.tg.modelrenaming", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false));
        requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"com.borland.tg.xmldesign", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false));
        requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"com.tssap.selena.dom", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false));
        requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"com.tssap.selena.model.providers.rc", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false));
        requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"com.tssap.selena.model.providers.resources", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false));
        requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"com.tssap.selena.model", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false));
        IInstallableUnit group = Bug278668.createIU("com.borland.tg.modeling.feature.group", Version.create((String)"8.2.0.v20081113-0500-_87S7nELRXmpf6G0dO3emm"), null, requirements.toArray(new IRequirement[requirements.size()]), new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"com.borland.tg.modeling", (Version)Version.create((String)"8.2.0.v20081113-0500-_87S7nELRXmpf6G0dO3emm"))}, new HashMap<String, String>(), null, null, true);
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{group});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        Bug278668.assertOK("plan should be OK", plan.getStatus());
        engine.perform(plan, null);
        this.repo = Bug278668.getMetadataRepositoryManager().loadRepository(Bug278668.getTestData("test data bug 278668", "testData/bug278668").toURI(), null);
    }

    @Override
    protected void tearDown() throws Exception {
        Bug278668.getMetadataRepositoryManager().removeRepository(Bug278668.getTestData("test data bug 278668", "testData/bug278668").toURI());
        super.tearDown();
    }

    public void testInstallFeaturePatch() {
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"com.borland.tg.modeling.8.2.0.hotfixexp.patch.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        Bug278668.assertEquals((int)1, (int)Bug278668.queryResultSize(c));
        IQueryResult c2 = this.repo.query(QueryUtil.createIUQuery((String)"com.borland.tg.modeling.8.2.0.nl.patch.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        Bug278668.assertEquals((int)1, (int)Bug278668.queryResultSize(c2));
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)c.iterator().next()});
        IPlanner planner = Bug278668.createPlanner();
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        Bug278668.assertOK("Plan OK", plan.getStatus());
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.profile);
        request2.addInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)c2.iterator().next()});
        IPlanner planner2 = Bug278668.createPlanner();
        IProvisioningPlan plan2 = planner2.getProvisioningPlan((IProfileChangeRequest)request2, null, (IProgressMonitor)new NullProgressMonitor());
        Bug278668.assertOK("Plan OK", plan2.getStatus());
        ProfileChangeRequest request3 = new ProfileChangeRequest(this.profile);
        request3.addInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)c.iterator().next(), (IInstallableUnit)c2.iterator().next()});
        IPlanner planner3 = Bug278668.createPlanner();
        IProvisioningPlan plan3 = planner3.getProvisioningPlan((IProfileChangeRequest)request3, null, (IProgressMonitor)new NullProgressMonitor());
        Bug278668.assertNotOK("Plan Not OK", plan3.getStatus());
        ProfileChangeRequest request4 = new ProfileChangeRequest(this.profile);
        request4.addInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)c.iterator().next(), (IInstallableUnit)c2.iterator().next()});
        request4.setInstallableUnitInclusionRules((IInstallableUnit)c.iterator().next(), ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)((IInstallableUnit)c.iterator().next())));
        request4.setInstallableUnitInclusionRules((IInstallableUnit)c2.iterator().next(), ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)((IInstallableUnit)c2.iterator().next())));
        IPlanner planner4 = Bug278668.createPlanner();
        IProvisioningPlan plan4 = planner4.getProvisioningPlan((IProfileChangeRequest)request4, null, (IProgressMonitor)new NullProgressMonitor());
        Bug278668.assertOK("Plan OK", plan4.getStatus());
    }
}

