/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.planner.AbstractPlannerTest;

public class Bug301446
extends AbstractPlannerTest {
    static final Map<String, Version> EXPECTED_VERSIONS = new HashMap<String, Version>();

    static {
        EXPECTED_VERSIONS.put("com.ibm.commerce.toolkit.internal.common", Version.create((String)"7.0.0.1"));
        EXPECTED_VERSIONS.put("com.ibm.commerce.toolkit.internal.dataaccess", Version.create((String)"7.0.0.1"));
        EXPECTED_VERSIONS.put("com.ibm.commerce.toolkit.internal.feature.enablement", Version.create((String)"7.0.0.5"));
        EXPECTED_VERSIONS.put("com.ibm.commerce.toolkit.internal.openlaszlo", Version.create((String)"7.0.0.6"));
        EXPECTED_VERSIONS.put("com.ibm.commerce.toolkit.internal.openlaszlo.migration", Version.create((String)"7.0.2.0"));
        EXPECTED_VERSIONS.put("com.ibm.commerce.toolkit.internal.openlaszlo.migration.validation", Version.create((String)"7.0.2.0"));
        EXPECTED_VERSIONS.put("com.ibm.commerce.toolkit.internal.plugin", Version.create((String)"7.0.0.7"));
    }

    @Override
    protected String getTestDataPath() {
        return "testData/bug301446";
    }

    @Override
    protected String getProfileId() {
        return "bootProfile";
    }

    public void testInstall() {
        Operand[] operands;
        IPlanner planner = Bug301446.createPlanner();
        IQueryResult allIUs = this.repo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        IProfileChangeRequest actualChangeRequest = this.createProfileChangeRequest(allIUs.toSet(), null, null);
        IProvisioningPlan actualPlan = planner.getProvisioningPlan(actualChangeRequest, null, (IProgressMonitor)new NullProgressMonitor());
        Operand[] operandArray = operands = ((ProvisioningPlan)actualPlan).getOperands();
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            Operand o = operandArray[n2];
            if (o instanceof InstallableUnitOperand) {
                IInstallableUnit iu = ((InstallableUnitOperand)o).second();
                if (iu == null) {
                    iu = ((InstallableUnitOperand)o).first();
                    expected = EXPECTED_VERSIONS.get(iu.getId());
                    if (expected != null) {
                        actual = iu.getVersion();
                        Bug301446.assertFalse((String)("Removing IU: " + iu.getId() + " Version: " + String.valueOf(expected)), (boolean)actual.equals(expected));
                    }
                } else {
                    expected = EXPECTED_VERSIONS.get(iu.getId());
                    if (expected != null) {
                        actual = iu.getVersion();
                        Bug301446.assertTrue((String)("Adding IU: " + iu.getId() + " Actual: " + String.valueOf(actual) + " Expected: " + String.valueOf(expected)), (boolean)actual.equals(expected));
                    }
                }
            }
            ++n2;
        }
    }
}

