/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug306424
extends AbstractProvisioningTest {
    private File previousStoreValue = null;
    private IProfile profile;

    protected String getTestDataPath() {
        return "testData/bug306424";
    }

    @Override
    protected void tearDown() throws Exception {
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        profileStore.set(realProfileRegistry, this.previousStoreValue);
        super.tearDown();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug306424.getTestData("loading planner test data", this.getTestDataPath());
        File tempFolder = this.getTempFolder();
        Bug306424.copy("0.2", reporegistry1, tempFolder);
        IProfileRegistry realProfileRegistry = this.getProfileRegistry();
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        this.previousStoreValue = (File)profileStore.get(realProfileRegistry);
        profileStore.set(realProfileRegistry, new File(tempFolder, "p2/org.eclipse.equinox.p2.engine/profileRegistry"));
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        this.profile = realProfileRegistry.getProfile("PlatformProfile");
        Bug306424.assertNotNull((Object)this.profile);
    }

    public void testInstall() {
        IPlanner planner = Bug306424.createPlanner();
        IInstallableUnit b = (IInstallableUnit)this.profile.query(QueryUtil.createIUQuery((String)"b"), (IProgressMonitor)new NullProgressMonitor()).iterator().next();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(this.profile);
        changeRequest.remove(b);
        IRequirement negateB = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)b.getId(), (VersionRange)new VersionRange(b.getVersion(), true, b.getVersion(), true), null, (int)0, (int)0, (boolean)false);
        ArrayList<IRequirement> extraReqs = new ArrayList<IRequirement>();
        extraReqs.add(negateB);
        changeRequest.addExtraRequirements(extraReqs);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, (IProgressMonitor)new NullProgressMonitor());
        IQueryable result = plan.getRemovals();
        IQueryResult r = result.query(QueryUtil.ALL_UNITS, this.getMonitor());
        Bug306424.assertFalse((String)"1.0", (boolean)r.isEmpty());
    }
}

