/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class IUProperties
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit b11;
    private IInstallableUnit c;
    private IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private String profileId;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = IUProperties.createIU("A", Version.create((String)"1.0.0"), IUProperties.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B1", new VersionRange("[1.0.0, 2.0.0)")));
        this.b1 = IUProperties.createIU("B1", Version.create((String)"1.0.0"), true);
        this.b11 = IUProperties.createIU("B1", Version.create((String)"1.1.0"), IUProperties.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "C", new VersionRange("[1.0.0, 3.0.0)")), NO_PROPERTIES, true);
        this.c = IUProperties.createIU("C", Version.createOSGi((int)2, (int)0, (int)0), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b11, this.c});
        this.profileId = "TestProfile." + this.getName();
        this.profile = this.createProfile(this.profileId);
        this.planner = IUProperties.createPlanner();
        this.engine = IUProperties.createEngine();
    }

    public void testRemoveIUProperty() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1});
        req1.setInstallableUnitProfileProperty(this.a1, "FOO", "BAR");
        req1.setInstallableUnitProfileProperty(this.b1, "FOO", "BAR");
        IProvisioningPlan pp1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        IUProperties.assertEquals((int)0, (int)pp1.getStatus().getSeverity());
        IStatus s = this.engine.perform(pp1, null);
        if (!s.isOK()) {
            LogHelper.log((IStatus)s);
        }
        IQueryResult queryResult = this.getProfile(this.profileId).query((IQuery)new IUProfilePropertyQuery("FOO", "*"), null);
        IUProperties.assertEquals((int)1, (int)IUProperties.queryResultSize(queryResult));
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile);
        req2.removeInstallableUnitProfileProperty(this.b1, "FOO");
        ProvisioningPlan pp2 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        IUProperties.assertEquals((int)0, (int)pp2.getOperands().length);
    }
}

