/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MissingOptionalWithDependencies
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit d;
    private IProfile profile;
    private IPlanner planner;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = MissingOptionalWithDependencies.createIU("A", Version.create((String)"1.0.0"), true);
        IRequirement[] reqB = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true)};
        this.b1 = MissingOptionalWithDependencies.createIU("B", Version.create((String)"1.0.0"), reqB);
        IRequirement[] req = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true)};
        this.d = MissingOptionalWithDependencies.createIU("D", req);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.d});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = MissingOptionalWithDependencies.createPlanner();
    }

    public void testInstallation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.d});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MissingOptionalWithDependencies.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        MissingOptionalWithDependencies.assertInstallOperand(plan, this.a1);
        MissingOptionalWithDependencies.assertInstallOperand(plan, this.b1);
        MissingOptionalWithDependencies.assertInstallOperand(plan, this.d);
    }
}

