/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class NegationTesting
extends AbstractProvisioningTest {
    private static final String NS = "theNamespace";
    private static final String N = "theName";

    public void testNot4() {
        MetadataFactory.InstallableUnitDescription iud1 = new MetadataFactory.InstallableUnitDescription();
        iud1.setId("TestNegation4");
        iud1.setVersion(Version.create((String)"1.0.0"));
        IRequirement req1 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.1.0, 1.2.0)"), null, (int)0, (int)0, (boolean)false);
        IRequirement req2 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        requirements.add(req1);
        requirements.add(req2);
        iud1.addRequirements(requirements);
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"TestNegation4", (Version)Version.create((String)"1.0.0")));
        iud1.addProvidedCapabilities(capabilities);
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud1);
        MetadataFactory.InstallableUnitDescription iud2 = new MetadataFactory.InstallableUnitDescription();
        iud2.setId("ProviderOf1");
        iud2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities2 = new ArrayList<IProvidedCapability>();
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        iud2.addProvidedCapabilities(capabilities2);
        IInstallableUnit iu2 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud2);
        MetadataFactory.InstallableUnitDescription iud3 = new MetadataFactory.InstallableUnitDescription();
        iud3.setId("ProviderOf1_1_1");
        iud3.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities3 = new ArrayList<IProvidedCapability>();
        capabilities3.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.1.1")));
        capabilities3.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"ProviderOf1_1_1", (Version)Version.create((String)"1.0.0")));
        iud3.addProvidedCapabilities(capabilities3);
        IInstallableUnit iu3 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud3);
        IMetadataRepository repo = this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iu2, iu3});
        Slicer slicer = new Slicer((IQueryable)repo, Collections.emptyMap(), false);
        IQueryable slice = slicer.slice(List.of(iu1), (IProgressMonitor)new NullProgressMonitor());
        NegationTesting.assertEquals((int)3, (int)NegationTesting.queryResultSize(slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IPlanner planner = NegationTesting.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
        changeRequest.add(iu1);
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, null);
        NegationTesting.assertEquals((int)0, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUQuery((String)"ProviderOf1_1_1"), null)));
        NegationTesting.assertEquals((int)2, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUAnyQuery(), null)));
        ProfileChangeRequest changeRequest2 = new ProfileChangeRequest(profile);
        ArrayList<IInstallableUnit> toAdd = new ArrayList<IInstallableUnit>();
        toAdd.add(iu1);
        toAdd.add(iu3);
        changeRequest2.addAll(toAdd);
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)changeRequest2, null, null);
        NegationTesting.assertNotOK("The resolution should be failing because of the negation requirement.", plan2.getStatus());
    }

    public void testNot5() {
        MetadataFactory.InstallableUnitDescription iud1 = new MetadataFactory.InstallableUnitDescription();
        iud1.setId("TestNegation4");
        iud1.setVersion(Version.create((String)"1.0.0"));
        IRequirement req1 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.1.0, 1.2.0)"), null, (int)0, (int)0, (boolean)false);
        IRequirement req2 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)false);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        requirements.add(req1);
        requirements.add(req2);
        iud1.addRequirements(requirements);
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"TestNegation4", (Version)Version.create((String)"1.0.0")));
        iud1.addProvidedCapabilities(capabilities);
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud1);
        MetadataFactory.InstallableUnitDescription iud2 = new MetadataFactory.InstallableUnitDescription();
        iud2.setId("ProviderOf1");
        iud2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities2 = new ArrayList<IProvidedCapability>();
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        iud2.addProvidedCapabilities(capabilities2);
        IInstallableUnit iu2 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud2);
        MetadataFactory.InstallableUnitDescription iud3 = new MetadataFactory.InstallableUnitDescription();
        iud3.setId("ProviderOf1_1_1");
        iud3.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities3 = new ArrayList<IProvidedCapability>();
        capabilities3.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.1.1")));
        capabilities3.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"ProviderOf1_1_1", (Version)Version.create((String)"1.0.0")));
        iud3.addProvidedCapabilities(capabilities3);
        IInstallableUnit iu3 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud3);
        IMetadataRepository repo = this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iu2, iu3});
        Slicer slicer = new Slicer((IQueryable)repo, Collections.emptyMap(), false);
        IQueryable slice = slicer.slice(List.of(iu1), (IProgressMonitor)new NullProgressMonitor());
        NegationTesting.assertEquals((int)0, (int)NegationTesting.queryResultSize(slice.query(QueryUtil.createIUQuery((String)"ProviderOf1_1_1"), (IProgressMonitor)new NullProgressMonitor())));
        NegationTesting.assertEquals((int)2, (int)NegationTesting.queryResultSize(slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testNot6() {
        MetadataFactory.InstallableUnitDescription iud1 = new MetadataFactory.InstallableUnitDescription();
        iud1.setId("TestNegation4");
        iud1.setVersion(Version.create((String)"1.0.0"));
        IRequirement req1 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.1.0, 1.2.0)"), null, (int)0, (int)0, (boolean)false);
        IRequirement req2 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)false);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        requirements.add(req1);
        requirements.add(req2);
        iud1.addRequirements(requirements);
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"TestNegation4", (Version)Version.create((String)"1.0.0")));
        iud1.addProvidedCapabilities(capabilities);
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud1);
        MetadataFactory.InstallableUnitDescription iud2 = new MetadataFactory.InstallableUnitDescription();
        iud2.setId("ProviderOf1");
        iud2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities2 = new ArrayList<IProvidedCapability>();
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        iud2.addProvidedCapabilities(capabilities2);
        IInstallableUnit iu2 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud2);
        IMetadataRepository repo = this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iu2});
        Slicer slicer = new Slicer((IQueryable)repo, Collections.emptyMap(), false);
        IQueryable slice = slicer.slice(List.of(iu1), (IProgressMonitor)new NullProgressMonitor());
        NegationTesting.assertEquals((int)0, (int)NegationTesting.queryResultSize(slice.query(QueryUtil.createIUQuery((String)"ProviderOf1_1_1"), (IProgressMonitor)new NullProgressMonitor())));
        NegationTesting.assertEquals((int)2, (int)NegationTesting.queryResultSize(slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IPlanner planner = NegationTesting.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
        changeRequest.add(iu1);
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, null);
        NegationTesting.assertEquals((int)0, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUQuery((String)"ProviderOf1_1_1"), null)));
        NegationTesting.assertEquals((int)2, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUAnyQuery(), null)));
    }

    public void testNot7() {
        MetadataFactory.InstallableUnitDescription iud1 = new MetadataFactory.InstallableUnitDescription();
        iud1.setId("TestNegation4");
        iud1.setVersion(Version.create((String)"1.0.0"));
        IRequirement req1 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.1.0, 1.2.0)"), null, (int)0, (int)0, (boolean)false);
        IRequirement req2 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        requirements.add(req1);
        requirements.add(req2);
        iud1.addRequirements(requirements);
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"TestNegation4", (Version)Version.create((String)"1.0.0")));
        iud1.addProvidedCapabilities(capabilities);
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud1);
        MetadataFactory.InstallableUnitDescription iud2 = new MetadataFactory.InstallableUnitDescription();
        iud2.setId("ProviderOf1");
        iud2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities2 = new ArrayList<IProvidedCapability>();
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        iud2.addProvidedCapabilities(capabilities2);
        IInstallableUnit iu2 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud2);
        MetadataFactory.InstallableUnitDescription iud3 = new MetadataFactory.InstallableUnitDescription();
        iud3.setId("ProviderOf1_1_1");
        iud3.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities3 = new ArrayList<IProvidedCapability>();
        capabilities3.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.1.1")));
        capabilities3.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"ProviderOf1_1_1", (Version)Version.create((String)"1.0.0")));
        iud3.addProvidedCapabilities(capabilities3);
        ArrayList<IRequirement> requirements3 = new ArrayList<IRequirement>();
        requirements3.add(MetadataFactory.createRequirement((String)"DOES-NOT-EXIST", (String)"NEVER", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false));
        iud3.addRequirements(requirements3);
        IInstallableUnit iu3 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud3);
        IMetadataRepository repo = this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iu2, iu3});
        Slicer slicer = new Slicer((IQueryable)repo, Collections.emptyMap(), false);
        IQueryable slice = slicer.slice(List.of(iu1), (IProgressMonitor)new NullProgressMonitor());
        NegationTesting.assertEquals((int)3, (int)NegationTesting.queryResultSize(slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IPlanner planner = NegationTesting.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
        changeRequest.add(iu1);
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, null);
        NegationTesting.assertEquals((int)0, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUQuery((String)"ProviderOf1_1_1"), null)));
        NegationTesting.assertEquals((int)2, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUAnyQuery(), null)));
        ProfileChangeRequest changeRequest2 = new ProfileChangeRequest(profile);
        ArrayList<IInstallableUnit> toAdd = new ArrayList<IInstallableUnit>();
        toAdd.add(iu1);
        toAdd.add(iu3);
        changeRequest2.addAll(toAdd);
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)changeRequest2, null, null);
        NegationTesting.assertNotOK("The resolution should be failing because of the negation requirement.", plan2.getStatus());
    }

    public void testNot8() {
        MetadataFactory.InstallableUnitDescription iud1 = new MetadataFactory.InstallableUnitDescription();
        iud1.setId("TestNegation4");
        iud1.setVersion(Version.create((String)"1.0.0"));
        IRequirement req1 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.1.0, 1.2.0)"), null, (int)0, (int)0, (boolean)false);
        IRequirement req2 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        requirements.add(req1);
        requirements.add(req2);
        iud1.addRequirements(requirements);
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"TestNegation4", (Version)Version.create((String)"1.0.0")));
        iud1.addProvidedCapabilities(capabilities);
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud1);
        MetadataFactory.InstallableUnitDescription iud2 = new MetadataFactory.InstallableUnitDescription();
        iud2.setId("ProviderOf1");
        iud2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities2 = new ArrayList<IProvidedCapability>();
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        iud2.addProvidedCapabilities(capabilities2);
        IInstallableUnit iu2 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud2);
        MetadataFactory.InstallableUnitDescription iud3 = new MetadataFactory.InstallableUnitDescription();
        iud3.setId("ProviderOf1_1_1");
        iud3.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities3 = new ArrayList<IProvidedCapability>();
        capabilities3.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.1.1")));
        capabilities3.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"ProviderOf1_1_1", (Version)Version.create((String)"1.0.0")));
        iud3.addProvidedCapabilities(capabilities3);
        IInstallableUnit iu3 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud3);
        MetadataFactory.InstallableUnitDescription iud4 = new MetadataFactory.InstallableUnitDescription();
        iud4.setId("AnotherRoot");
        iud4.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities4 = new ArrayList<IProvidedCapability>();
        capabilities4.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"AnotherRoot", (Version)Version.create((String)"1.0.0")));
        iud4.addProvidedCapabilities(capabilities4);
        ArrayList<IRequirement> reqs4 = new ArrayList<IRequirement>();
        reqs4.add(MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.1.1, 1.1.1]"), null, (boolean)false, (boolean)false));
        iud4.addRequirements(reqs4);
        IInstallableUnit iu4 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud4);
        IMetadataRepository repo = this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iu2, iu3, iu4});
        Slicer slicer = new Slicer((IQueryable)repo, Collections.emptyMap(), false);
        IQueryable slice = slicer.slice(List.of(iu1, iu4), (IProgressMonitor)new NullProgressMonitor());
        NegationTesting.assertEquals((int)4, (int)NegationTesting.queryResultSize(slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        Slicer slicer2 = new Slicer((IQueryable)repo, Collections.emptyMap(), false);
        IQueryable slice2 = slicer2.slice(List.of(iu4), (IProgressMonitor)new NullProgressMonitor());
        NegationTesting.assertEquals((int)2, (int)NegationTesting.queryResultSize(slice2.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IPlanner planner = NegationTesting.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
        changeRequest.add(iu1);
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, null);
        NegationTesting.assertEquals((int)0, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUQuery((String)"ProviderOf1_1_1"), null)));
        NegationTesting.assertEquals((int)2, (int)NegationTesting.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUAnyQuery(), null)));
        ProfileChangeRequest changeRequest2 = new ProfileChangeRequest(profile);
        ArrayList<IInstallableUnit> toAdd = new ArrayList<IInstallableUnit>();
        toAdd.add(iu1);
        toAdd.add(iu4);
        changeRequest2.addAll(toAdd);
        IProvisioningPlan plan2 = planner.getProvisioningPlan((IProfileChangeRequest)changeRequest2, null, null);
        NegationTesting.assertNotOK("The resolution should be failing because of the negation requirement.", plan2.getStatus());
    }

    public void testNegationThroughExtraRequirements() {
        IInstallableUnit iu = NegationTesting.createIU("TESTNEGATION");
        this.createTestMetdataRepository(new IInstallableUnit[]{iu});
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IPlanner planner = NegationTesting.createPlanner();
        IProfileChangeRequest request = planner.createChangeRequest(profile);
        request.add(iu);
        IRequirement req1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, (int)0, (int)0, (boolean)false, null);
        ArrayList<IRequirement> reqs = new ArrayList<IRequirement>();
        reqs.add(req1);
        request.addExtraRequirements(reqs);
        IProvisioningPlan plan = planner.getProvisioningPlan(request, null, null);
        NegationTesting.assertNotOK("plan should fail", plan.getStatus());
    }

    public void testUniqueCapability() {
        MetadataFactory.InstallableUnitDescription iud1 = new MetadataFactory.InstallableUnitDescription();
        iud1.setId("TestNegation4");
        iud1.setVersion(Version.create((String)"1.0.0"));
        IRequirement req1 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[0.0.0, 1.1.1)"), null, (int)0, (int)0, (boolean)false);
        IRequirement req2 = MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange(Version.create((String)"1.1.1"), false, Version.MAX_VERSION, false), null, (int)0, (int)0, (boolean)false);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        requirements.add(req1);
        requirements.add(req2);
        iud1.addRequirements(requirements);
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"TestNegation4", (Version)Version.create((String)"1.0.0")));
        capabilities.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.1.1")));
        iud1.addProvidedCapabilities(capabilities);
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud1);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IPlanner planner = NegationTesting.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
        changeRequest.add(iu1);
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, null);
        NegationTesting.assertOK(plan.getStatus());
        NegationTesting.assertFalse((boolean)plan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)iu1), (IProgressMonitor)new NullProgressMonitor()).isEmpty());
        MetadataFactory.InstallableUnitDescription iud2 = new MetadataFactory.InstallableUnitDescription();
        iud2.setId("ProviderOf1");
        iud2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities2 = new ArrayList<IProvidedCapability>();
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        iud2.addProvidedCapabilities(capabilities2);
        IInstallableUnit iu2 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud2);
        ProfileChangeRequest changeRequest2 = new ProfileChangeRequest(profile);
        changeRequest2.add(iu1);
        changeRequest2.add(iu2);
        ProvisioningPlan plan2 = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest2, null, null);
        NegationTesting.assertNotOK(plan2.getStatus());
    }
}

