/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTest3
extends AbstractProvisioningTest {
    IInstallableUnit f1;
    IInstallableUnit f2;
    IInstallableUnit a1;
    IInstallableUnit a3;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnitPatch p1;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.f1 = PatchTest3.createIU("F", Version.createOSGi((int)1, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.1.0]"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.f2 = PatchTest3.createIU("F", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[3.0.0, 4.0.0)"), null, (boolean)false, (boolean)false, (boolean)true)});
        IProvidedCapability[] cap = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"foo", (String)"bar", (Version)Version.createOSGi((int)1, (int)0, (int)0))};
        this.a1 = PatchTest3.createIU("A", Version.create((String)"1.0.0"), null, new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)false)}, cap, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        this.a3 = PatchTest3.createIU("A", Version.createOSGi((int)3, (int)0, (int)0), true);
        this.b1 = PatchTest3.createIU("B", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.b2 = PatchTest3.createIU("B", Version.createOSGi((int)2, (int)0, (int)0), true);
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0, 2.1.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"F", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)false, (boolean)false);
        this.p1 = PatchTest3.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.1.0]"), null, (boolean)false, (boolean)false, (boolean)false)}}, lifeCycle);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.p1, this.a3, this.f1, this.f2});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTest3.createPlanner();
        this.engine = PatchTest3.createEngine();
    }

    public void testCompleteScenario() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.f1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTest3.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        PatchTest3.assertInstallOperand(plan1, this.b1);
        PatchTest3.assertInstallOperand(plan1, this.a1);
        PatchTest3.assertInstallOperand(plan1, this.f1);
        this.engine.perform(plan1, null);
        PatchTest3.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        PatchTest3.assertProfileContainsAll("B1 is missing", this.profile1, new IInstallableUnit[]{this.b1});
        PatchTest3.assertProfileContainsAll("B1 is missing", this.profile1, new IInstallableUnit[]{this.f1});
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.p1});
        req2.setInstallableUnitInclusionRules((IInstallableUnit)this.p1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p1));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        PatchTest3.assertTrue((4 != plan2.getStatus().getSeverity() ? 1 : 0) != 0);
        PatchTest3.assertInstallOperand(plan2, (IInstallableUnit)this.p1);
        PatchTest3.assertInstallOperand(plan2, this.b2);
        this.engine.perform(plan2, null);
        PatchTest3.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        PatchTest3.assertProfileContainsAll("B2 is missing", this.profile1, new IInstallableUnit[]{this.b2});
        PatchTest3.assertProfileContainsAll("P1 is missing", this.profile1, new IInstallableUnit[]{this.p1});
        PatchTest3.assertProfileContainsAll("P1 is missing", this.profile1, new IInstallableUnit[]{this.f1});
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.removeInstallableUnits(new IInstallableUnit[]{this.p1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        PatchTest3.assertTrue((4 != plan3.getStatus().getSeverity() ? 1 : 0) != 0);
        PatchTest3.assertInstallOperand(plan3, this.b1);
        PatchTest3.assertUninstallOperand(plan3, this.b2);
        PatchTest3.assertUninstallOperand(plan3, (IInstallableUnit)this.p1);
        ProfileChangeRequest req4 = new ProfileChangeRequest(this.profile1);
        req4.removeInstallableUnits(new IInstallableUnit[]{this.f1});
        IProvisioningPlan plan4 = this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        PatchTest3.assertTrue((4 != plan4.getStatus().getSeverity() ? 1 : 0) != 0);
        PatchTest3.assertUninstallOperand(plan4, this.b2);
        PatchTest3.assertUninstallOperand(plan4, this.a1);
        PatchTest3.assertUninstallOperand(plan4, this.f1);
        PatchTest3.assertUninstallOperand(plan4, (IInstallableUnit)this.p1);
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile1);
        req5.removeInstallableUnits(new IInstallableUnit[]{this.f1});
        req5.addInstallableUnits(new IInstallableUnit[]{this.f2});
        IProvisioningPlan plan5 = this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        PatchTest3.assertTrue((4 != plan5.getStatus().getSeverity() ? 1 : 0) != 0);
        PatchTest3.assertUninstallOperand(plan5, this.b2);
        PatchTest3.assertUninstallOperand(plan5, this.a1);
        PatchTest3.assertUninstallOperand(plan5, this.f1);
        PatchTest3.assertUninstallOperand(plan5, (IInstallableUnit)this.p1);
        PatchTest3.assertInstallOperand(plan5, this.f2);
        PatchTest3.assertInstallOperand(plan5, this.a3);
        this.engine.perform(plan5, null);
        PatchTest3.assertProfileContainsAll("", this.profile1, new IInstallableUnit[]{this.f2, this.a3});
    }
}

