/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.planner.IUWithFilter;

public class SWTFragment
extends AbstractProvisioningTest {
    public void testFragmentPickedByCapability() {
        IRequirement[] reqs = SWTFragment.createRequiredCapabilities("swt.fragment", "swt.fragment", new VersionRange("[1.0.0, 2.0.0)"));
        IInstallableUnit swt = SWTFragment.createIU("SWT", reqs);
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId("SWT.WIN32");
        iud.setVersion(Version.create((String)"1.0.0"));
        iud.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"swt.fragment", (String)"swt.fragment", (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        iud.setFilter("(os=win32)");
        IInstallableUnit swtW = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
        MetadataFactory.InstallableUnitDescription iud2 = new MetadataFactory.InstallableUnitDescription();
        iud.setId("SWT.LINUX");
        iud.setVersion(Version.create((String)"1.0.0"));
        iud.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"swt.fragment", (String)"swt.fragment", (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        iud.setFilter("(os=linux)");
        IInstallableUnit swtL = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud2);
        this.createTestMetdataRepository(new IInstallableUnit[]{swt, swtL, swtW});
        IProfile profile = this.createProfile(IUWithFilter.class.getName());
        IPlanner planner = SWTFragment.createPlanner();
        ProfileChangeRequest req = new ProfileChangeRequest(profile);
        req.setProfileProperty("os", "win32");
        req.addInstallableUnits(new IInstallableUnit[]{swt});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SWTFragment.assertOK("plan", plan.getStatus());
        Collector c = new Collector();
        c.addAll(plan.getAdditions().query(QueryUtil.createIUQuery((String)"SWT"), null));
        c.addAll(plan.getAdditions().query(QueryUtil.createIUQuery((String)"SWT.WIN32"), null));
        SWTFragment.assertEquals((int)2, (int)c.size());
    }
}

