/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerOneInstalledReplacingIt
extends AbstractProvisioningTest {
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private IProfileChangeRequest originalRequest;
    private ProvisioningContext context;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile("TestProfile." + this.getName());
        IULoader.loadIUs((Object)this);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2});
        this.planner = TestRequestFlexerOneInstalledReplacingIt.createPlanner();
        this.engine = TestRequestFlexerOneInstalledReplacingIt.createEngine();
        TestRequestFlexerOneInstalledReplacingIt.assertOK(this.install(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        this.originalRequest = this.planner.createChangeRequest(this.profile);
        this.originalRequest.add(this.sdk2);
        this.originalRequest.setInstallableUnitInclusionRules(this.sdk2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.sdk2));
        TestRequestFlexerOneInstalledReplacingIt.assertNotOK(this.planner.getProvisioningPlan(this.originalRequest, this.context, null).getStatus());
        this.context = new ProvisioningContext(TestRequestFlexerOneInstalledReplacingIt.getAgent());
    }

    public void testRemoveInstalledElement() {
        IProfileChangeRequest requestToTest = this.planner.createChangeRequest(this.profile);
        requestToTest.add(this.sdk2);
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementRemoval(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(requestToTest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledReplacingIt.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerOneInstalledReplacingIt.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerOneInstalledReplacingIt.assertEquals((int)1, (int)realRequest.getRemovals().size());
        TestRequestFlexerOneInstalledReplacingIt.assertOK(this.install(realRequest, this.planner, this.engine));
    }

    public void testUpdateInstalledElement() {
        IProfileChangeRequest requestToTest = this.planner.createChangeRequest(this.profile);
        requestToTest.add(this.sdk2);
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(requestToTest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledReplacingIt.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerOneInstalledReplacingIt.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerOneInstalledReplacingIt.assertEquals((int)1, (int)realRequest.getRemovals().size());
        TestRequestFlexerOneInstalledReplacingIt.assertEquals((int)1, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledReplacingIt.assertOK(this.install(realRequest, this.planner, this.engine));
    }

    public void testUDifferentVersionAndUpdateInstalledElement() {
        IProfileChangeRequest requestToTest = this.planner.createChangeRequest(this.profile);
        requestToTest.add(this.sdk2);
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowDifferentVersion(true);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(requestToTest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledReplacingIt.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerOneInstalledReplacingIt.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerOneInstalledReplacingIt.assertEquals((int)1, (int)realRequest.getRemovals().size());
        TestRequestFlexerOneInstalledReplacingIt.assertEquals((int)1, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledReplacingIt.assertOK(this.install(realRequest, this.planner, this.engine));
    }
}

