/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerProduct
extends AbstractProvisioningTest {
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit egit1;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit egit2;
    @IUDescription(content="package: eppPackage \nsingleton: true\nversion: 2 \ndepends: SDK = 2")
    public IInstallableUnit eppPackage;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private IProfileChangeRequest originalRequest;
    private ProvisioningContext context;

    private void setupSDK1() {
        IRequirement[] reqPlatform1 = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"platform", (VersionRange)new VersionRange("[1.0.0,1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)};
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("org.eclipse.equinox.p2.type.product", Boolean.TRUE.toString());
        this.sdk1 = TestRequestFlexerProduct.createIU("SDK", Version.create((String)"1.0.0"), null, reqPlatform1, new IProvidedCapability[0], p, null, null, true);
    }

    private void setupSDK2() {
        IRequirement[] reqPlatform1 = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"platform", (VersionRange)new VersionRange("[2.0.0,2.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)};
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("org.eclipse.equinox.p2.type.product", Boolean.TRUE.toString());
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)"SDK", (VersionRange)new VersionRange("[1.0.0,2.0.0)"), (int)0, (String)"description");
        this.sdk2 = TestRequestFlexerProduct.createIU("SDK", Version.create((String)"2.0.0"), null, reqPlatform1, new IProvidedCapability[0], p, null, null, true, update, null);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context = new ProvisioningContext(TestRequestFlexerProduct.getAgent());
        this.profile = this.createProfile("TestProfile." + this.getName());
        IULoader.loadIUs((Object)this);
        this.setupSDK1();
        this.setupSDK2();
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2, this.eppPackage});
        this.planner = TestRequestFlexerProduct.createPlanner();
        this.engine = TestRequestFlexerProduct.createEngine();
        TestRequestFlexerProduct.assertOK(this.installAsRoots(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        this.originalRequest = this.planner.createChangeRequest(this.profile);
        this.originalRequest.add(this.egit2);
        this.originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        TestRequestFlexerProduct.assertNotOK(this.planner.getProvisioningPlan(this.originalRequest, this.context, null).getStatus());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.getProfileRegistry().removeProfile(this.profile.getProfileId());
    }

    public void testProductRemovalIsDetected() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(false);
        av.setAllowDifferentVersion(false);
        av.setAllowInstalledElementRemoval(true);
        av.setAllowInstalledElementChange(false);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerProduct.assertNull((Object)realRequest);
    }

    public void testProductNewProduct() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(false);
        av.setAllowDifferentVersion(false);
        av.setAllowInstalledElementRemoval(false);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerProduct.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerProduct.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
    }

    public void testProductNotAsRoot() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(false);
        av.setAllowDifferentVersion(false);
        av.setAllowInstalledElementRemoval(true);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest specialRequest = this.planner.createChangeRequest(this.profile);
        specialRequest.add(this.eppPackage);
        specialRequest.setInstallableUnitInclusionRules(this.eppPackage, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.eppPackage));
        IProfileChangeRequest realRequest = av.getChangeRequest(specialRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerProduct.assertTrue((boolean)realRequest.getAdditions().contains(this.eppPackage));
        TestRequestFlexerProduct.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
    }
}

