/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class TychoUsage
extends AbstractProvisioningTest {
    private static final String SIMREL_REPO = "https://download.eclipse.org/releases/2024-12";
    private static final String EMF_SDK_VERSION = "2.40.0.v20241018-1213";
    private IInstallableUnit topLevelIU;

    private void setupTopLevelIU() {
        IRequirement[] reqPlatform1 = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.emf.sdk.feature.group", (VersionRange)new VersionRange("[2.40.0.v20241018-1213,2.40.0.v20241018-1213]"), null, (boolean)false, (boolean)false, (boolean)true)};
        HashMap<String, String> p = new HashMap<String, String>();
        this.topLevelIU = TychoUsage.createIU("topLevelIU", Version.create((String)"1.0.0"), null, reqPlatform1, new IProvidedCapability[0], p, null, null, true);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setupTopLevelIU();
    }

    public void testEquivalentP2Call() throws ProvisionException, URISyntaxException {
        this.loadMetadataRepository(URIUtil.fromString((String)SIMREL_REPO));
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IProfileChangeRequest pcr = this.getPlanner(TychoUsage.getAgent()).createChangeRequest(profile);
        pcr.add(this.topLevelIU);
        this.assertResolve(pcr, this.getPlanner(TychoUsage.getAgent()));
    }

    public void testTychoUsage() throws ProvisionException, URISyntaxException {
        IMetadataRepository repo = this.loadMetadataRepository(URIUtil.fromString((String)SIMREL_REPO));
        IInstallableUnit newRoot1 = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"org.eclipse.emf.sdk.feature.group", (Version)Version.create((String)EMF_SDK_VERSION)), (IProgressMonitor)new NullProgressMonitor()).iterator().next();
        ArrayList<IInstallableUnit> newRoots = new ArrayList<IInstallableUnit>();
        newRoots.add(newRoot1);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("osgi.ws", "win32");
        context.put("osgi.os", "win32");
        context.put("osgi.arch", "x86_64");
        context.put("org.eclipse.update.install.features", "true");
        Slicer slicer = new Slicer((IQueryable)repo, context, false);
        IQueryable slice = slicer.slice(List.of(this.topLevelIU), (IProgressMonitor)new NullProgressMonitor());
        Projector p = new Projector(slice, context, new HashSet(), false);
        p.encode(this.topLevelIU, new IInstallableUnit[0], (IQueryable)new Collector(), newRoots, (IProgressMonitor)new NullProgressMonitor());
        IStatus result = p.invokeSolver((IProgressMonitor)new NullProgressMonitor());
        TychoUsage.assertTrue((result.isOK() || result.getSeverity() == 2 ? 1 : 0) != 0);
        TychoUsage.assertFalse((boolean)p.extractSolution().isEmpty());
    }
}

