/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ChecksumGenerationTest
extends AbstractProvisioningTest {
    @Parameterized.Parameter(value=0)
    public String checksumProperty;
    @Parameterized.Parameter(value=1)
    public String checksumValue;

    @Parameterized.Parameters
    public static Collection<Object[]> generateChecksums() {
        return Arrays.asList(new Object[][]{{"download.checksum".concat(".sha-256"), "11da2dd636ab76f460513cbcbfe8c56a6e5ad47aa9b38b36c6d04f8ee7722252"}});
    }

    @Test
    public void testGenerationFile() {
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IArtifactKey)new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0)), (File)ChecksumGenerationTest.getTestData("Artifact to generate from", "testData/artifactRepo/simpleWithMD5/plugins/aaPlugin_1.0.0.jar"));
        ChecksumGenerationTest.assertEquals((String)String.format("%s checksum property", this.checksumProperty), (String)this.checksumValue, (String)ad.getProperty(this.checksumProperty));
    }

    @Test
    public void testGenerationFolder() {
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IArtifactKey)new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0)), (File)ChecksumGenerationTest.getTestData("Artifact to generate from", "testData/artifactRepo/simpleWithMD5/plugins/"));
        ChecksumGenerationTest.assertEquals((String)String.format("%s checksum property", this.checksumProperty), null, (String)ad.getProperty(this.checksumProperty));
    }

    @Test
    public void testGenerationNoFolder() {
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IArtifactKey)new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0)), null);
        MatcherAssert.assertThat((Object)ad.getProperty(this.checksumProperty), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.checksumValue)));
    }
}

