/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.p2.publisher.QuotedTokenizer;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAndBundlesPublisherApplication;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.junit.Assert;
import org.junit.Test;

public class GeneralPublisherTests {
    @Test
    public void testBug255820_Product_normalize() throws Exception {
        Method normalizeMethod = ProductFile.class.getDeclaredMethod("normalize", String.class);
        normalizeMethod.setAccessible(true);
        Assert.assertNotNull((Object)normalizeMethod);
        Assert.assertEquals((Object)normalizeMethod.invoke(null, "a b  c\td\ne"), (Object)"a b c d e");
        Assert.assertEquals((Object)normalizeMethod.invoke(null, "a\fbd\r\n e"), (Object)"a bd e");
    }

    @Test
    public void testInvalidConfiguration1() {
        StringBuilder buffer;
        Integer retValue;
        FeaturesAndBundlesPublisherApplication application;
        block5: {
            application = new FeaturesAndBundlesPublisherApplication();
            retValue = 0;
            buffer = new StringBuilder();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    retValue = (Integer)application.run(new String[0]);
                }
                catch (Exception e) {
                    Assert.fail((String)"0.99");
                    System.setOut(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        Assert.assertTrue((boolean)buffer.toString().contains("A metadata repository must be specified."));
        Assert.assertEquals((String)"1.0", (long)1L, (long)retValue.intValue());
        Assert.assertEquals((String)"1.1", (Object)Messages.exception_noMetadataRepo, (Object)application.getStatus().getMessage());
    }

    @Test
    public void testInvalidConfiguration2() {
        StringBuilder buffer;
        Integer retValue;
        FeaturesAndBundlesPublisherApplication application;
        block5: {
            application = new FeaturesAndBundlesPublisherApplication();
            retValue = 0;
            buffer = new StringBuilder();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    retValue = (Integer)application.run(new String[]{"-metadataRepository foo", "-publishArtifacts"});
                }
                catch (Exception e) {
                    Assert.fail((String)"0.99");
                    System.setOut(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        Assert.assertTrue((boolean)buffer.toString().contains("An artifact repository must be specified in order to publish artifacts."));
        Assert.assertEquals((String)"1.0", (long)1L, (long)retValue.intValue());
        Assert.assertEquals((String)"1.1", (Object)Messages.exception_noArtifactRepo, (Object)application.getStatus().getMessage());
    }

    @Test
    public void testQuotedTokenizer() throws Exception {
        QuotedTokenizer tokenizer = new QuotedTokenizer("abra ca dabra");
        Assert.assertEquals((Object)"abra", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"ca", (Object)tokenizer.nextToken());
        Assert.assertTrue((boolean)tokenizer.hasMoreTokens());
        Assert.assertEquals((Object)"dabra", (Object)tokenizer.nextToken());
        Assert.assertFalse((boolean)tokenizer.hasMoreTokens());
        boolean exception = false;
        try {
            tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        tokenizer = new QuotedTokenizer("ab c\"de fg\" hi");
        Assert.assertEquals((Object)"ab", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"cde fg", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"hi", (Object)tokenizer.nextToken());
        Assert.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer("a,b c,d", ",");
        Assert.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"b c", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"d", (Object)tokenizer.nextToken());
        Assert.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer("a bcd\u7432e fg");
        Assert.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"bcd\u7432e", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"fg", (Object)tokenizer.nextToken());
        Assert.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer("    ");
        Assert.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer(",,,", ",");
        Assert.assertFalse((boolean)tokenizer.hasMoreElements());
        tokenizer = new QuotedTokenizer("a \"b\\\" c\" d");
        Assert.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"b\" c", (Object)tokenizer.nextToken());
        Assert.assertEquals((Object)"d", (Object)tokenizer.nextToken());
        Assert.assertFalse((boolean)tokenizer.hasMoreTokens());
    }
}

