/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.publisher.eclipse.DataLoader;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigCUsAction;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.LaunchingAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ANYConfigCUsActionTest
extends ActionTest {
    private static final String BUNDLE_VERSION = "5.0.0";
    private static final String ORG_ECLIPSE_CORE_COMMANDS = "org.eclipse.core.commands";
    private static File configLocation = new File(TestActivator.getTestDataFolder(), "ConfigCUsActionTest/level1/level2/config.ini");
    private static File executableLocation = new File(TestActivator.getTestDataFolder(), "ConfigCUsActionTest/level1/run.exe");
    private static Version version = Version.create((String)"1.0.0");
    private static String id = "id";
    private static String flavor = "tooling";
    private IMetadataRepository metadataRepo;
    private DataLoader loader;

    @Override
    public void setUp() throws Exception {
        String[] cfgSpecs = AbstractPublisherAction.parseConfigSpec((String)"ANY");
        this.configSpec = AbstractPublisherAction.createConfigSpec((String)cfgSpecs[0], (String)cfgSpecs[1], (String)cfgSpecs[2]);
        this.setupPublisherInfo();
        this.setupPublisherResult();
        this.testAction = new ConfigCUsAction(this.publisherInfo, flavor, id, version);
    }

    public void testAction() throws Exception {
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        this.verifyAction();
        this.debug("Completed ConfigCUsAction test.");
    }

    private void verifyAction() {
        ArrayList IUs = new ArrayList(this.publisherResult.getIUs(null, "root"));
        ANYConfigCUsActionTest.assertTrue((IUs.size() == 1 ? 1 : 0) != 0);
        InstallableUnit iu = (InstallableUnit)IUs.get(0);
        ANYConfigCUsActionTest.assertTrue((boolean)iu.getId().equalsIgnoreCase(flavor + id + ".configuration"));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.iu", iu.getId(), version);
        ANYConfigCUsActionTest.assertTrue((providedCapabilities.size() == 1 ? 1 : 0) != 0);
        List requiredCapability = iu.getRequirements();
        ANYConfigCUsActionTest.assertTrue((requiredCapability.size() == 3 ? 1 : 0) != 0);
        this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", flavor + id + ".config." + this.configSpec, new VersionRange(version, true, version, true));
        this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", flavor + id + ".ini." + this.configSpec, new VersionRange(version, true, version, true));
        this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", flavor + this.configSpec + ORG_ECLIPSE_CORE_COMMANDS, new VersionRange(version, true, version, true));
        this.verifyFragment("ini");
        this.verifyFragment("config");
        this.verifyBundleCU();
    }

    private void verifyFragment(String cuType) {
        for (IInstallableUnit iu : new ArrayList(this.publisherResult.getIUs(null, "non_root"))) {
            if (!iu.getId().equals(flavor + id + "." + cuType + "." + this.configSpec)) continue;
            ANYConfigCUsActionTest.assertNull((Object)iu.getFilter());
            ANYConfigCUsActionTest.assertTrue((boolean)iu.getVersion().equals(version));
            ANYConfigCUsActionTest.assertFalse((boolean)iu.isSingleton());
            Collection providedCapabilities = iu.getProvidedCapabilities();
            this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.iu", flavor + id + "." + cuType + "." + this.configSpec, version);
            this.verifyProvidedCapability(providedCapabilities, flavor + id, id + "." + cuType, version);
            ANYConfigCUsActionTest.assertTrue((providedCapabilities.size() == 2 ? 1 : 0) != 0);
            ANYConfigCUsActionTest.assertTrue((iu.getRequirements().size() == 0 ? 1 : 0) != 0);
            if (cuType.equals("ini")) {
                this.verifyLauncherArgs(iu);
            }
            if (cuType.equals("config")) {
                this.verifyConfigProperties(iu);
            }
            return;
        }
        ANYConfigCUsActionTest.fail((String)("Configuration unit of type " + cuType + " was not enocuntered among fragments"));
    }

    private void verifyBundleCU() {
        String bundleCUId = flavor + this.configSpec + ORG_ECLIPSE_CORE_COMMANDS;
        IQueryResult queryResult = this.publisherResult.query(QueryUtil.createIUQuery((String)bundleCUId), (IProgressMonitor)new NullProgressMonitor());
        ANYConfigCUsActionTest.assertEquals((int)1, (int)ANYConfigCUsActionTest.queryResultSize(queryResult));
        IInstallableUnitFragment fragment = (IInstallableUnitFragment)queryResult.iterator().next();
        ANYConfigCUsActionTest.assertNull((Object)fragment.getFilter());
        ANYConfigCUsActionTest.assertTrue((boolean)fragment.getVersion().equals(version));
        ANYConfigCUsActionTest.assertFalse((boolean)fragment.isSingleton());
        Collection providedCapabilities = fragment.getProvidedCapabilities();
        this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.iu", bundleCUId, version);
        this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.flavor", flavor + this.configSpec, version);
        ANYConfigCUsActionTest.assertEquals((int)2, (int)providedCapabilities.size());
        ANYConfigCUsActionTest.assertEquals((int)0, (int)fragment.getRequirements().size());
        Collection hostRequirements = fragment.getHost();
        this.verifyRequirement(hostRequirements, "osgi.bundle", ORG_ECLIPSE_CORE_COMMANDS, new VersionRange(BUNDLE_VERSION));
        this.verifyRequirement(hostRequirements, "org.eclipse.equinox.p2.eclipse.type", "bundle", new VersionRange(Version.create((String)"1.0.0"), true, Version.create((String)"2.0.0"), false), null, 1, 1, false);
        ANYConfigCUsActionTest.assertTrue((hostRequirements.size() == 2 ? 1 : 0) != 0);
        Collection touchpointData = fragment.getTouchpointData();
        ANYConfigCUsActionTest.assertEquals((int)1, (int)touchpointData.size());
        ITouchpointData data = (ITouchpointData)touchpointData.iterator().next();
        ITouchpointInstruction instruction = data.getInstruction("install");
        ANYConfigCUsActionTest.assertEquals((String)"installBundle(bundle:${artifact})", (String)instruction.getBody());
        instruction = data.getInstruction("uninstall");
        ANYConfigCUsActionTest.assertEquals((String)"uninstallBundle(bundle:${artifact})", (String)instruction.getBody());
        instruction = data.getInstruction("configure");
        ANYConfigCUsActionTest.assertEquals((String)"setStartLevel(startLevel:2);", (String)instruction.getBody());
        instruction = data.getInstruction("unconfigure");
        ANYConfigCUsActionTest.assertEquals((String)"setStartLevel(startLevel:-1);", (String)instruction.getBody());
    }

    private void verifyLauncherArgs(IInstallableUnit iu) {
        Collection touchpointData = iu.getTouchpointData();
        ANYConfigCUsActionTest.assertEquals((int)1, (int)touchpointData.size());
        ITouchpointData data = (ITouchpointData)touchpointData.iterator().next();
        ITouchpointInstruction instruction = data.getInstruction("configure");
        String body = instruction.getBody();
        ANYConfigCUsActionTest.assertTrue((String)"arg -foo bar", (boolean)body.contains("addProgramArg(programArg:-foo bar);"));
        ANYConfigCUsActionTest.assertTrue((String)"vmarg -agentlib", (boolean)body.contains("addJvmArg(jvmArg:-agentlib${#58}jdwp=transport=dt_socket${#44}server=y${#44}suspend=n${#44}address=8272);"));
        ANYConfigCUsActionTest.assertTrue((String)"arg -product com,ma", (boolean)body.contains("addProgramArg(programArg:-product);addProgramArg(programArg:com${#44}ma);"));
    }

    private void verifyConfigProperties(IInstallableUnit iu) {
        Collection touchpointData = iu.getTouchpointData();
        ANYConfigCUsActionTest.assertEquals((int)1, (int)touchpointData.size());
        ITouchpointData data = (ITouchpointData)touchpointData.iterator().next();
        ITouchpointInstruction instruction = data.getInstruction("configure");
        String body = instruction.getBody();
        ANYConfigCUsActionTest.assertTrue((String)"eclipse.product", (boolean)body.contains("setProgramProperty(propName:eclipse.product,propValue:org.eclipse.platform.ide);"));
        ANYConfigCUsActionTest.assertTrue((String)"eclipse.buildId", (boolean)body.contains("setProgramProperty(propName:eclipse.buildId,propValue:TEST-ID);"));
        ANYConfigCUsActionTest.assertTrue((String)"my.property", (boolean)body.contains("setProgramProperty(propName:my.property,propValue:${#123}a${#44}b${#58}c${#59}${#36}d${#125});"));
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        this.loader = new DataLoader(configLocation, executableLocation);
        LauncherData launcherData = this.loader.getLauncherData();
        LaunchingAdvice launchingAdvice = new LaunchingAdvice(launcherData, this.configSpec);
        ArrayList<Object> launchingList = new ArrayList<Object>();
        launchingList.add(launchingAdvice);
        ProductFileAdvice productAdvice = null;
        try {
            String productFileLocation = TestData.getFile("ProductActionTest", "productFileActionTest.product").toString();
            productAdvice = new ProductFileAdvice((IProductDescriptor)new ProductFile(productFileLocation), this.configSpec);
            launchingList.add(productAdvice);
        }
        catch (Exception e) {
            ANYConfigCUsActionTest.fail("Unable to create product file advice", e);
        }
        Mockito.when((Object)this.publisherInfo.getAdvice(ArgumentMatchers.matches((String)this.configSpec), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.anyString(), (Version)ArgumentMatchers.any(Version.class), (Class)ArgumentMatchers.eq(IExecutableAdvice.class))).thenReturn(launchingList);
        ConfigData configData = this.loader.getConfigData();
        ConfigAdvice configAdvice = new ConfigAdvice(configData, this.configSpec);
        ArrayList<Object> configList = new ArrayList<Object>();
        configList.add(configAdvice);
        configList.add(productAdvice);
        Mockito.when((Object)this.publisherInfo.getAdvice(ArgumentMatchers.matches((String)this.configSpec), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.anyString(), (Version)ArgumentMatchers.any(Version.class), (Class)ArgumentMatchers.eq(IConfigAdvice.class))).thenReturn(configList);
        IInstallableUnit[] ius = new IInstallableUnit[]{this.mockIU("foo", null), this.mockIU("bar", null)};
        this.metadataRepo = new TestMetadataRepository(ANYConfigCUsActionTest.getAgent(), ius);
        Mockito.when((Object)this.publisherInfo.getMetadataRepository()).thenReturn((Object)this.metadataRepo);
        Mockito.when((Object)this.publisherInfo.getContextMetadataRepository()).thenReturn(null);
    }

    @Override
    public void setupPublisherResult() {
        super.setupPublisherResult();
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        iuDescription.setId(ORG_ECLIPSE_CORE_COMMANDS);
        iuDescription.setVersion(Version.create((String)BUNDLE_VERSION));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription);
        this.publisherResult.addIU(iu, "non_root");
    }
}

