/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.AccumulateConfigDataAction;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.LaunchingAdvice;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AccumulateConfigDataActionTest
extends ActionTest {
    private static String EXECUTABLE_NAME = "run.exe";
    private static String FOO = "/AccumulateConfigDataActionTest/level1/plugins/foo_1.0.100.v20080509-1800.jar";
    private static String BAR = "/AccumulateConfigDataActionTest/level1/plugins/bar_1.0.100.v20080509-1800";
    private static File configLocation = new File(TestActivator.getTestDataFolder(), "AccumulateConfigDataActionTest/level1/level2/config.ini");
    private static File executableLocation = new File(TestActivator.getTestDataFolder(), "AccumulateConfigDataActionTest/level1/" + EXECUTABLE_NAME);
    private static String fwName = "osgi";
    private static String fwVersion = "3.4.0.qualifier";
    private static String launcherName = "launcherName";
    private static String launcherVersion = "0.0.0";
    ArgumentCaptor<IPublisherAdvice> capture;

    @Override
    public void setUp() throws Exception {
        this.capture = ArgumentCaptor.forClass(IPublisherAdvice.class);
        this.setupPublisherInfo();
        this.setupPublisherResult();
        this.testAction = new AccumulateConfigDataAction(this.publisherInfo, this.configSpec, configLocation, executableLocation);
    }

    public void testAccumulateConfigDataAction() throws Exception {
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        ((IPublisherInfo)Mockito.verify((Object)this.publisherInfo, (VerificationMode)Mockito.atLeastOnce())).addAdvice((IPublisherAdvice)this.capture.capture());
        this.verifyConfigAdvice();
        this.verifyLaunchAdvice();
        this.debug("Completed AccumulateConfigDataActionTest.");
    }

    private void verifyLaunchAdvice() throws URISyntaxException {
        LaunchingAdvice captured = (LaunchingAdvice)this.capture.getAllValues().stream().filter(LaunchingAdvice.class::isInstance).collect(Collectors.toList()).get(0);
        String[] programArgs = captured.getProgramArguments();
        AccumulateConfigDataActionTest.assertTrue((programArgs.length == 4 ? 1 : 0) != 0);
        AccumulateConfigDataActionTest.assertTrue((boolean)programArgs[0].equalsIgnoreCase("-startup"));
        IPath path1 = IPath.fromOSString((String)(TestActivator.getTestDataFolder().getPath() + FOO));
        AccumulateConfigDataActionTest.assertTrue((boolean)path1.toFile().toURI().equals(new URI(programArgs[1])));
        AccumulateConfigDataActionTest.assertTrue((boolean)programArgs[2].equalsIgnoreCase("--launcher.library"));
        IPath path2 = IPath.fromOSString((String)(TestActivator.getTestDataFolder().getPath() + BAR));
        AccumulateConfigDataActionTest.assertTrue((boolean)path2.toFile().toURI().equals(new URI(programArgs[3])));
        String[] vmArgs = captured.getVMArguments();
        AccumulateConfigDataActionTest.assertTrue((vmArgs.length == 0 ? 1 : 0) != 0);
    }

    private void verifyConfigAdvice() throws Exception {
        ConfigAdvice captured = (ConfigAdvice)this.capture.getAllValues().stream().filter(ConfigAdvice.class::isInstance).collect(Collectors.toList()).get(0);
        Map prop = captured.getProperties();
        AccumulateConfigDataActionTest.assertTrue((boolean)((String)prop.get("eclipse.buildId")).equalsIgnoreCase("TEST-ID"));
        AccumulateConfigDataActionTest.assertTrue((boolean)((String)prop.get("eclipse.p2.profile")).equalsIgnoreCase("PlatformProfile"));
        AccumulateConfigDataActionTest.assertTrue((boolean)((String)prop.get("org.eclipse.update.reconcile")).equalsIgnoreCase("false"));
        AccumulateConfigDataActionTest.assertTrue((boolean)((String)prop.get("eclipse.product")).equalsIgnoreCase("org.eclipse.platform.ide"));
        this.assertContainsSymbolicName(captured.getBundles(), "org.eclipse.swt");
        this.assertContainsSymbolicName(captured.getBundles(), "org.eclipse.swt.win32.win32.x86");
        this.assertContainsSymbolicName(captured.getBundles(), "org.eclipse.swt.gtk.linux.x86");
        this.assertContainsSymbolicName(captured.getBundles(), "org.eclipse.swt.carbon.macosx");
    }

    private void assertContainsSymbolicName(BundleInfo[] bundles, String symbolicName) {
        BundleInfo[] bundleInfoArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bundle = bundleInfoArray[n2];
            if (bundle.getSymbolicName().equals(symbolicName)) {
                return;
            }
            ++n2;
        }
        AccumulateConfigDataActionTest.fail();
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        ConfigData configData = new ConfigData(fwName, fwVersion, launcherName, launcherVersion);
        ConfigAdvice configAdvice = new ConfigAdvice(configData, this.configSpec);
        ArrayList<ConfigAdvice> configList = new ArrayList<ConfigAdvice>();
        configList.add(configAdvice);
    }
}

