/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.mockito.Mockito;

public abstract class ActionTest
extends AbstractProvisioningTest {
    protected static final String COMMA_SEPARATOR = ",";
    protected static final String JAR = "jar";
    private static final boolean DEBUG = false;
    protected String os = "win32";
    protected String ws = "win32";
    protected String arch = "x86";
    protected String configSpec = AbstractPublisherAction.createConfigSpec((String)this.ws, (String)this.os, (String)this.arch);
    protected String flavorArg = "tooling";
    protected String[] topLevel;
    protected AbstractPublisherAction testAction;
    protected IPublisherInfo publisherInfo;
    protected IPublisherResult publisherResult;

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void verifyProvidedCapability(Collection<IProvidedCapability> prov, String namespace, String name, Version version) {
        for (IProvidedCapability pc : prov) {
            if (!pc.getName().equalsIgnoreCase(name) || !pc.getNamespace().equalsIgnoreCase(namespace) || !pc.getVersion().equals(version)) continue;
            return;
        }
        Assert.fail((String)("Missing ProvidedCapability: " + name + version.toString()));
    }

    protected void verifyRequirement(Collection<IRequirement> actual, String namespace, String name, VersionRange range) {
        this.verifyRequirement(actual, namespace, name, range, null, 1, 1, true);
    }

    protected void verifyRequirement(Collection<IRequirement> actual, String namespace, String name, VersionRange range, String envFilter, int minCard, int maxCard, boolean greedy) {
        IRequirement expected = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, (IMatchExpression)InstallableUnit.parseFilter((String)envFilter), (int)minCard, (int)maxCard, (boolean)greedy);
        this.verifyRequirement(actual, expected);
    }

    protected void verifyRequirement(Collection<IRequirement> actual, String namespace, String propsFilter, String envFilter, int minCard, int maxCard, boolean greedy) {
        IRequirement expected = MetadataFactory.createRequirement((String)namespace, (String)propsFilter, (IMatchExpression)InstallableUnit.parseFilter((String)envFilter), (int)minCard, (int)maxCard, (boolean)greedy);
        this.verifyRequirement(actual, expected);
    }

    protected void verifyRequirement(Collection<IRequirement> actual, IRequirement expected) {
        for (IRequirement act : actual) {
            if (!expected.getMatches().equals(act.getMatches())) continue;
            String descr = "IRequirement " + String.valueOf(expected.getMatches());
            ActionTest.assertEquals((String)("Min of " + descr), (int)expected.getMin(), (int)act.getMin());
            ActionTest.assertEquals((String)("Max of " + descr), (int)expected.getMax(), (int)act.getMax());
            ActionTest.assertEquals((String)("Greedy of " + descr), (boolean)expected.isGreedy(), (boolean)act.isGreedy());
            return;
        }
        Assert.fail((String)("Missing IRequirement: " + String.valueOf(expected)));
    }

    protected IInstallableUnit mockIU(String id, Version version) {
        IInstallableUnit result = (IInstallableUnit)Mockito.mock(IInstallableUnit.class);
        Mockito.when((Object)result.getId()).thenReturn((Object)id);
        if (version == null) {
            version = Version.emptyVersion;
        }
        Mockito.when((Object)result.getVersion()).thenReturn((Object)version);
        Mockito.when((Object)result.getFilter()).thenReturn(null);
        return result;
    }

    protected Map<String, Object[]> getFileMap(Map<String, Object[]> map, File[] files, IPath root) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                map = this.getFileMap(map, file.listFiles(), root);
            } else if (!file.getPath().endsWith(JAR)) {
                try {
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    File contentBytes = file;
                    FileUtils.copyStream((InputStream)Files.newInputStream(contentBytes.toPath(), new OpenOption[0]), (boolean)false, (OutputStream)content, (boolean)true);
                    IPath entryPath = IPath.fromOSString((String)file.getAbsolutePath());
                    entryPath = entryPath.removeFirstSegments(root.matchingFirstSegments(entryPath));
                    entryPath = entryPath.setDevice(null);
                    map.put(entryPath.toString(), new Object[]{contentBytes, content.toByteArray()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return map;
    }

    public void setupPublisherResult() {
        this.publisherResult = new PublisherResult();
    }

    public void setupPublisherInfo() {
        this.publisherInfo = (IPublisherInfo)Mockito.mock(IPublisherInfo.class);
        String[] config = ActionTest.getArrayFromString(this.configSpec, COMMA_SEPARATOR);
        Mockito.when((Object)this.publisherInfo.getConfigurations()).thenReturn((Object)config);
        this.insertPublisherInfoBehavior();
    }

    protected void insertPublisherInfoBehavior() {
        Mockito.when((Object)this.publisherInfo.getMetadataRepository()).thenReturn((Object)this.createTestMetdataRepository(new IInstallableUnit[0]));
        Mockito.when((Object)this.publisherInfo.getContextMetadataRepository()).thenReturn((Object)this.createTestMetdataRepository(new IInstallableUnit[0]));
    }

    public void cleanup() {
        this.publisherInfo = null;
        this.publisherResult = null;
    }

    public void debug(String message) {
    }

    protected final void addContextIU(String unitId, String unitVersion) {
        this.publisherResult.addIU(ActionTest.createIU(unitId, Version.create((String)unitVersion)), "non_root");
    }

    protected final void addContextIU(String unitId, String unitVersion, String filter) {
        this.publisherResult.addIU(ActionTest.createIU(unitId, Version.create((String)unitVersion), filter, NO_PROVIDES), "non_root");
    }

    protected final IInstallableUnit getUniquePublishedIU(String id) {
        MatcherAssert.assertThat((Object)this.publisherResult, ActionTest.containsUniqueIU(id));
        IQueryResult queryResult = this.publisherResult.query(QueryUtil.createIUQuery((String)id), (IProgressMonitor)new NullProgressMonitor());
        return (IInstallableUnit)queryResult.iterator().next();
    }

    public static Matcher<IPublisherResult> containsIU(final String id) {
        final IQuery query = QueryUtil.createIUQuery((String)id);
        return new TypeSafeMatcher<IPublisherResult>(){

            public void describeTo(Description description) {
                description.appendText("contains a unit " + id);
            }

            public boolean matchesSafely(IPublisherResult item) {
                IQueryResult queryResult = item.query(query, null);
                return ActionTest.queryResultSize(queryResult) > 0;
            }
        };
    }

    public static Matcher<IPublisherResult> containsUniqueIU(final String id) {
        final IQuery query = QueryUtil.createIUQuery((String)id);
        return new TypeSafeMatcher<IPublisherResult>(){

            public void describeTo(Description description) {
                description.appendText("contains exactly one unit " + id);
            }

            public boolean matchesSafely(IPublisherResult item) {
                IQueryResult queryResult = item.query(query, null);
                return ActionTest.queryResultSize(queryResult) == 1;
            }
        };
    }
}

