/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AdviceFileParser;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.junit.Assert;
import org.junit.Test;

public class AdviceFileParserTest {
    @Test
    public void testNoAdvice() {
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, Collections.EMPTY_MAP);
        parser.parse();
        Assert.assertNull((Object)parser.getAdditionalInstallableUnitDescriptions());
        Assert.assertNull((Object)parser.getProperties());
        Assert.assertNull((Object)parser.getProvidedCapabilities());
        Assert.assertNull((Object)parser.getRequiredCapabilities());
        Assert.assertNull((Object)parser.getTouchpointInstructions());
    }

    @Test
    public void testAdviceVersion() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("advice.version", "1.0");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        map.put("advice.version", "999");
        Assert.assertThrows((String)"expected version parse problem", IllegalStateException.class, () -> new AdviceFileParser("id", Version.emptyVersion, map).parse());
    }

    @Test
    public void testUpdateDescriptorAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "testName");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        map.put("update.range", "(1.0.0,10.10.10)");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        Assert.assertEquals((Object)"testName", (Object)testName);
        Assert.assertEquals((Object)Version.parseVersion((String)"1.0.0"), (Object)testVersionRange.getMinimum());
        Assert.assertEquals((Object)Version.parseVersion((String)"10.10.10"), (Object)testVersionRange.getMaximum());
        Assert.assertEquals((long)10L, (long)updateDescriptor.getSeverity());
        Assert.assertEquals((Object)"Test Description", (Object)updateDescriptor.getDescription());
    }

    @Test
    public void testUpdateDescriptorAdviceDefaultBound() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "testName");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        map.put("update.range", "(1.0.0,$version$)");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        Assert.assertEquals((Object)"testName", (Object)testName);
        Assert.assertEquals((Object)Version.parseVersion((String)"1.0.0"), (Object)testVersionRange.getMinimum());
        Assert.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        Assert.assertEquals((long)10L, (long)updateDescriptor.getSeverity());
        Assert.assertEquals((Object)"Test Description", (Object)updateDescriptor.getDescription());
    }

    @Test
    public void testUpdateDescriptorWithMatch() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.matchExp", "providedCapabilities.exists(pc | pc.namespace == 'org.eclipse.equinox.p2.iu' && (pc.name == 'B' || pc.name == 'C'))");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        Assert.assertEquals((Object)"Test Description", (Object)updateDescriptor.getDescription());
        Assert.assertEquals((long)10L, (long)updateDescriptor.getSeverity());
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            String string = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        });
    }

    @Test
    public void testUpdateDescriptorAdviceDefaultBound2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "testName");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        Assert.assertEquals((Object)"testName", (Object)testName);
        Assert.assertEquals((Object)Version.parseVersion((String)"0.0.0"), (Object)testVersionRange.getMinimum());
        Assert.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        Assert.assertEquals((long)10L, (long)updateDescriptor.getSeverity());
        Assert.assertEquals((Object)"Test Description", (Object)updateDescriptor.getDescription());
    }

    @Test
    public void testUpdateDescriptorAdviceDefaultID() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        Assert.assertEquals((Object)"id", (Object)testName);
        Assert.assertEquals((Object)Version.parseVersion((String)"0.0.0"), (Object)testVersionRange.getMinimum());
        Assert.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        Assert.assertEquals((long)10L, (long)updateDescriptor.getSeverity());
        Assert.assertEquals((Object)"Test Description", (Object)updateDescriptor.getDescription());
    }

    @Test
    public void testUpdateDescriptorAdviceDefaults() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "id");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        Assert.assertEquals((Object)"id", (Object)testName);
        Assert.assertEquals((Object)Version.parseVersion((String)"0.0.0"), (Object)testVersionRange.getMinimum());
        Assert.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        Assert.assertEquals((long)0L, (long)updateDescriptor.getSeverity());
        Assert.assertEquals(null, (Object)updateDescriptor.getDescription());
    }

    @Test
    public void testPropertyAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("properties.0.name", "testName1");
        map.put("properties.0.value", "testValue1");
        map.put("properties.1.name", "testName2");
        map.put("properties.1.value", "testValue2");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        Assert.assertEquals((Object)"testValue1", parser.getProperties().get("testName1"));
        Assert.assertEquals((Object)"testValue2", parser.getProperties().get("testName2"));
    }

    @Test
    public void testProvidesAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("provides.0.namespace", "testNamespace1");
        map.put("provides.0.name", "testName1");
        map.put("provides.0.version", "1.2.3.$qualifier$");
        AdviceFileParser parser = new AdviceFileParser("id", Version.create((String)"1.0.0.v20090909"), map);
        parser.parse();
        IProvidedCapability[] capabilities = parser.getProvidedCapabilities();
        Assert.assertEquals((long)1L, (long)capabilities.length);
        Assert.assertEquals((Object)"testNamespace1", (Object)capabilities[0].getNamespace());
        Assert.assertEquals((Object)"testName1", (Object)capabilities[0].getName());
        Assert.assertEquals((Object)Version.create((String)"1.2.3.v20090909"), (Object)capabilities[0].getVersion());
        map.put("provides.1.namespace", "testNamespace2");
        map.put("provides.1.name", "testName2");
        map.put("provides.1.version", "$version$");
        parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        capabilities = parser.getProvidedCapabilities();
        Assert.assertEquals((long)2L, (long)capabilities.length);
        Assert.assertEquals((Object)"testNamespace1", (Object)capabilities[0].getNamespace());
        Assert.assertEquals((Object)"testName1", (Object)capabilities[0].getName());
        Assert.assertEquals((Object)Version.create((String)"1.2.3"), (Object)capabilities[0].getVersion());
        Assert.assertEquals((Object)"testNamespace2", (Object)capabilities[1].getNamespace());
        Assert.assertEquals((Object)"testName2", (Object)capabilities[1].getName());
        Assert.assertEquals((Object)Version.emptyVersion, (Object)capabilities[1].getVersion());
    }

    @Test
    public void testRequiresAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("requires.0.namespace", "testNamespace1");
        map.put("requires.0.name", "testName1");
        map.put("requires.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("requires.0.greedy", Boolean.TRUE.toString());
        map.put("requires.0.optional", Boolean.TRUE.toString());
        map.put("requires.0.multiple", Boolean.TRUE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.create((String)"1.0.0.v20090909"), map);
        parser.parse();
        IRequirement[] reqs = parser.getRequiredCapabilities();
        Assert.assertEquals((long)1L, (long)reqs.length);
        Assert.assertEquals((Object)"testNamespace1", (Object)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)"testName1", (Object)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)new VersionRange("[1.2.3.v20090909, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        map.put("requires.1.namespace", "testNamespace2");
        map.put("requires.1.name", "testName2");
        map.put("requires.1.range", "$version$");
        map.put("requires.1.greedy", Boolean.FALSE.toString());
        map.put("requires.1.optional", Boolean.FALSE.toString());
        parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        reqs = parser.getRequiredCapabilities();
        Assert.assertEquals((long)2L, (long)reqs.length);
        Assert.assertEquals((Object)"testNamespace1", (Object)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)"testName1", (Object)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)true, (Object)reqs[0].isGreedy());
        Assert.assertEquals((long)0L, (long)reqs[0].getMin());
        Assert.assertEquals((Object)"testNamespace2", (Object)RequiredCapability.extractNamespace((IMatchExpression)reqs[1].getMatches()));
        Assert.assertEquals((Object)"testName2", (Object)RequiredCapability.extractName((IMatchExpression)reqs[1].getMatches()));
        Assert.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[1].getMatches()));
        Assert.assertEquals((Object)false, (Object)reqs[1].isGreedy());
        Assert.assertEquals((long)1L, (long)reqs[1].getMin());
    }

    @Test
    public void testRequireWithExpression() {
        HashMap<String, String> map = new HashMap<String, String>();
        String matchExp = "properties[abc] == 'def'";
        map.put("requires.0.matchExp", matchExp);
        map.put("requires.0.greedy", Boolean.TRUE.toString());
        map.put("requires.0.min", "1");
        map.put("requires.0.max", "1");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        IRequirement[] reqs = parser.getRequiredCapabilities();
        reqs = parser.getRequiredCapabilities();
        Assert.assertEquals((long)1L, (long)reqs.length);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)matchExp), new Object[0]);
        Assert.assertEquals((Object)matchExpression, (Object)reqs[0].getMatches());
    }

    @Test
    public void testRequireWithExpressionAndOptional() {
        HashMap<String, String> map = new HashMap<String, String>();
        String matchExp = "properties[abc] == 'def'";
        map.put("requires.0.matchExp", matchExp);
        map.put("requires.0.greedy", Boolean.TRUE.toString());
        map.put("requires.0.optional", Boolean.TRUE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        IRequirement[] reqs = parser.getRequiredCapabilities();
        reqs = parser.getRequiredCapabilities();
        Assert.assertEquals((long)1L, (long)reqs.length);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)matchExp), new Object[0]);
        Assert.assertEquals((Object)matchExpression, (Object)reqs[0].getMatches());
        Assert.assertEquals((long)0L, (long)reqs[0].getMin());
        Assert.assertEquals((long)1L, (long)reqs[0].getMax());
    }

    @Test
    public void testMetaRequiresAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("metaRequirements.0.namespace", "testNamespace1");
        map.put("metaRequirements.0.name", "testName1");
        map.put("metaRequirements.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("metaRequirements.0.greedy", Boolean.TRUE.toString());
        map.put("metaRequirements.0.optional", Boolean.TRUE.toString());
        map.put("metaRequirements.0.multiple", Boolean.TRUE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.create((String)"1.0.0.v20090909"), map);
        parser.parse();
        IRequirement[] reqs = parser.getMetaRequiredCapabilities();
        Assert.assertEquals((long)1L, (long)reqs.length);
        Assert.assertEquals((Object)"testNamespace1", (Object)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)"testName1", (Object)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)new VersionRange("[1.2.3.v20090909, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        map.put("metaRequirements.1.namespace", "testNamespace2");
        map.put("metaRequirements.1.name", "testName2");
        map.put("metaRequirements.1.range", "$version$");
        map.put("metaRequirements.1.greedy", Boolean.FALSE.toString());
        map.put("metaRequirements.1.optional", Boolean.FALSE.toString());
        parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        reqs = parser.getMetaRequiredCapabilities();
        Assert.assertEquals((long)2L, (long)reqs.length);
        Assert.assertEquals((Object)"testNamespace1", (Object)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)"testName1", (Object)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        Assert.assertEquals((Object)true, (Object)reqs[0].isGreedy());
        Assert.assertEquals((long)0L, (long)reqs[0].getMin());
        Assert.assertEquals((Object)"testNamespace2", (Object)RequiredCapability.extractNamespace((IMatchExpression)reqs[1].getMatches()));
        Assert.assertEquals((Object)"testName2", (Object)RequiredCapability.extractName((IMatchExpression)reqs[1].getMatches()));
        Assert.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[1].getMatches()));
        Assert.assertEquals((Object)false, (Object)reqs[1].isGreedy());
        Assert.assertEquals((long)1L, (long)reqs[1].getMin());
    }

    @Test
    public void testInstructionsAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instructions.configure", "addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);");
        map.put("instructions.unconfigure", "removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)");
        map.put("instructions.unconfigure.import", "some.removeProgramArg");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        ITouchpointInstruction configure = (ITouchpointInstruction)parser.getTouchpointInstructions().get("configure");
        Assert.assertEquals(null, (Object)configure.getImportAttribute());
        Assert.assertEquals((Object)"addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);", (Object)configure.getBody());
        ITouchpointInstruction unconfigure = (ITouchpointInstruction)parser.getTouchpointInstructions().get("unconfigure");
        Assert.assertEquals((Object)"some.removeProgramArg", (Object)unconfigure.getImportAttribute());
        Assert.assertEquals((Object)"removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)", (Object)unconfigure.getBody());
    }

    @Test
    public void testAdditionalInstallableUnitDescriptionsAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("units.0.id", "testid0");
        map.put("units.0.version", "1.2.3");
        map.put("units.1.id", "testid1");
        map.put("units.1.version", "1.2.4");
        map.put("units.1.singleton", "true");
        map.put("units.1.copyright", "testCopyright");
        map.put("units.1.copyright.location", "http://localhost/test");
        map.put("units.1.filter", "(test=testFilter)");
        map.put("units.1.touchpoint.id", "testTouchpointId");
        map.put("units.1.touchpoint.version", "1.2.5");
        map.put("units.1.update.id", "testid1");
        map.put("units.1.update.range", "(1,2)");
        map.put("units.1.update.severity", "2");
        map.put("units.1.update.description", "some description");
        map.put("units.1.artifacts.0.id", "testArtifact1");
        map.put("units.1.artifacts.0.version", "1.2.6");
        map.put("units.1.artifacts.0.classifier", "testClassifier1");
        map.put("units.1.artifacts.1.id", "testArtifact2");
        map.put("units.1.artifacts.1.version", "1.2.7");
        map.put("units.1.artifacts.1.classifier", "testClassifier2");
        map.put("units.1.licenses.0", "testLicense");
        map.put("units.1.licenses.0.location", "http://localhost/license");
        map.put("units.1.properties.0.name", "testName1");
        map.put("units.1.properties.0.value", "testValue1");
        map.put("units.1.properties.1.name", "testName2");
        map.put("units.1.properties.1.value", "testValue2");
        map.put("units.1.requires.0.namespace", "testNamespace1");
        map.put("units.1.requires.0.name", "testName1");
        map.put("units.1.requires.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("units.1.requires.0.greedy", Boolean.TRUE.toString());
        map.put("units.1.requires.0.optional", Boolean.TRUE.toString());
        map.put("units.1.requires.0.multiple", Boolean.TRUE.toString());
        map.put("units.1.requires.1.namespace", "testNamespace2");
        map.put("units.1.requires.1.name", "testName2");
        map.put("units.1.requires.1.range", "$version$");
        map.put("units.1.requires.1.greedy", Boolean.FALSE.toString());
        map.put("units.1.requires.1.optional", Boolean.FALSE.toString());
        map.put("units.1.metaRequirements.0.namespace", "testNamespace1");
        map.put("units.1.metaRequirements.0.name", "testName1");
        map.put("units.1.metaRequirements.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("units.1.metaRequirements.0.greedy", Boolean.TRUE.toString());
        map.put("units.1.metaRequirements.0.optional", Boolean.TRUE.toString());
        map.put("units.1.metaRequirements.0.multiple", Boolean.TRUE.toString());
        map.put("units.1.metaRequirements.1.namespace", "testNamespace2");
        map.put("units.1.metaRequirements.1.name", "testName2");
        map.put("units.1.metaRequirements.1.range", "$version$");
        map.put("units.1.metaRequirements.1.greedy", Boolean.FALSE.toString());
        map.put("units.1.metaRequirements.1.optional", Boolean.FALSE.toString());
        map.put("units.1.provides.0.namespace", "testNamespace1");
        map.put("units.1.provides.0.name", "testName1");
        map.put("units.1.provides.0.version", "1.2.3.$qualifier$");
        map.put("units.1.provides.1.namespace", "testNamespace2");
        map.put("units.1.provides.1.name", "testName2");
        map.put("units.1.provides.1.version", "$version$");
        map.put("units.1.instructions.configure", "addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);");
        map.put("units.1.instructions.unconfigure", "removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)");
        map.put("units.1.instructions.unconfigure.import", "some.removeProgramArg");
        map.put("units.1.hostRequirements.0.namespace", "testNamespace1");
        map.put("units.1.hostRequirements.0.name", "testName1");
        map.put("units.1.hostRequirements.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("units.1.hostRequirements.0.greedy", Boolean.TRUE.toString());
        map.put("units.1.hostRequirements.0.optional", Boolean.TRUE.toString());
        map.put("units.1.hostRequirements.0.multiple", Boolean.TRUE.toString());
        map.put("units.1.hostRequirements.1.namespace", "testNamespace2");
        map.put("units.1.hostRequirements.1.name", "testName2");
        map.put("units.1.hostRequirements.1.range", "$version$");
        map.put("units.1.hostRequirements.1.greedy", Boolean.FALSE.toString());
        map.put("units.1.hostRequirements.1.optional", Boolean.FALSE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        MetadataFactory.InstallableUnitDescription[] descriptions = parser.getAdditionalInstallableUnitDescriptions();
        IInstallableUnit iu0 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptions[0]);
        Assert.assertEquals((Object)"testid0", (Object)iu0.getId());
        Assert.assertEquals((Object)Version.create((String)"1.2.3"), (Object)iu0.getVersion());
        Assert.assertFalse((boolean)iu0.isSingleton());
        Assert.assertFalse((boolean)QueryUtil.isFragment((IInstallableUnit)iu0));
        Assert.assertEquals((long)0L, (long)iu0.getArtifacts().size());
        Assert.assertEquals(null, (Object)iu0.getCopyright());
        Assert.assertEquals(null, (Object)iu0.getFilter());
        Assert.assertEquals((long)0L, (long)iu0.getLicenses().size());
        Assert.assertEquals((long)0L, (long)iu0.getProperties().size());
        Assert.assertEquals((long)0L, (long)iu0.getRequirements().size());
        Assert.assertEquals((long)0L, (long)iu0.getProvidedCapabilities().size());
        Assert.assertEquals((long)0L, (long)iu0.getMetaRequirements().size());
        Assert.assertEquals((long)0L, (long)iu0.getTouchpointData().size());
        Assert.assertEquals((Object)ITouchpointType.NONE, (Object)iu0.getTouchpointType());
        Assert.assertEquals(null, (Object)iu0.getUpdateDescriptor());
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptions[1]);
        Assert.assertEquals((Object)"testid1", (Object)iu1.getId());
        Assert.assertEquals((Object)Version.create((String)"1.2.4"), (Object)iu1.getVersion());
        Assert.assertTrue((boolean)iu1.isSingleton());
        Assert.assertEquals((long)2L, (long)iu1.getArtifacts().size());
        Iterator it = iu1.getArtifacts().iterator();
        IArtifactKey key0 = (IArtifactKey)it.next();
        IArtifactKey key1 = (IArtifactKey)it.next();
        Assert.assertEquals((Object)"testArtifact1", (Object)key0.getId());
        Assert.assertEquals((Object)Version.create((String)"1.2.6"), (Object)key0.getVersion());
        Assert.assertEquals((Object)"testClassifier1", (Object)key0.getClassifier());
        Assert.assertEquals((Object)"testArtifact2", (Object)key1.getId());
        Assert.assertEquals((Object)Version.create((String)"1.2.7"), (Object)key1.getVersion());
        Assert.assertEquals((Object)"testClassifier2", (Object)key1.getClassifier());
        Assert.assertEquals((Object)"testCopyright", (Object)iu1.getCopyright().getBody());
        Assert.assertEquals((Object)"http://localhost/test", (Object)iu1.getCopyright().getLocation().toString());
        Assert.assertEquals((Object)InstallableUnit.parseFilter((String)"(test=testFilter)"), (Object)iu1.getFilter());
        Assert.assertEquals((Object)"testLicense", (Object)((ILicense)iu1.getLicenses().iterator().next()).getBody());
        Assert.assertEquals((Object)"http://localhost/license", (Object)((ILicense)iu1.getLicenses().iterator().next()).getLocation().toString());
        Assert.assertEquals((Object)"testValue1", (Object)iu1.getProperty("testName1"));
        Assert.assertEquals((Object)"testValue2", (Object)iu1.getProperty("testName2"));
        Collection reqs = iu1.getRequirements();
        Iterator it2 = reqs.iterator();
        IRequirement req0 = (IRequirement)it2.next();
        IRequirement req1 = (IRequirement)it2.next();
        Assert.assertEquals((long)2L, (long)reqs.size());
        Assert.assertEquals((Object)"testNamespace1", (Object)RequiredCapability.extractNamespace((IMatchExpression)req0.getMatches()));
        Assert.assertEquals((Object)"testName1", (Object)RequiredCapability.extractName((IMatchExpression)req0.getMatches()));
        Assert.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)req0.getMatches()));
        Assert.assertEquals((Object)true, (Object)req0.isGreedy());
        Assert.assertEquals((long)0L, (long)req0.getMin());
        Assert.assertEquals((Object)"testNamespace2", (Object)RequiredCapability.extractNamespace((IMatchExpression)req1.getMatches()));
        Assert.assertEquals((Object)"testName2", (Object)RequiredCapability.extractName((IMatchExpression)req1.getMatches()));
        Assert.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)req1.getMatches()));
        Assert.assertEquals((Object)false, (Object)req1.isGreedy());
        Assert.assertEquals((long)1L, (long)req1.getMin());
        Collection provided = iu1.getProvidedCapabilities();
        Iterator it4 = provided.iterator();
        IProvidedCapability cap1 = (IProvidedCapability)it4.next();
        IProvidedCapability cap2 = (IProvidedCapability)it4.next();
        Assert.assertEquals((long)2L, (long)provided.size());
        Assert.assertEquals((Object)"testNamespace1", (Object)cap1.getNamespace());
        Assert.assertEquals((Object)"testName1", (Object)cap1.getName());
        Assert.assertEquals((Object)Version.create((String)"1.2.3"), (Object)cap1.getVersion());
        Assert.assertEquals((Object)"testNamespace2", (Object)cap2.getNamespace());
        Assert.assertEquals((Object)"testName2", (Object)cap2.getName());
        Assert.assertEquals((Object)Version.emptyVersion, (Object)cap2.getVersion());
        Collection metarequirements = iu1.getMetaRequirements();
        Assert.assertEquals((long)2L, (long)metarequirements.size());
        Iterator it3 = metarequirements.iterator();
        IRequirement metaReq0 = (IRequirement)it3.next();
        IRequirement metaReq1 = (IRequirement)it3.next();
        Assert.assertEquals((Object)"testNamespace1", (Object)RequiredCapability.extractNamespace((IMatchExpression)metaReq0.getMatches()));
        Assert.assertEquals((Object)"testName1", (Object)RequiredCapability.extractName((IMatchExpression)metaReq0.getMatches()));
        Assert.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)metaReq0.getMatches()));
        Assert.assertEquals((Object)true, (Object)metaReq0.isGreedy());
        Assert.assertEquals((long)0L, (long)metaReq0.getMin());
        Assert.assertEquals((Object)"testNamespace2", (Object)RequiredCapability.extractNamespace((IMatchExpression)metaReq1.getMatches()));
        Assert.assertEquals((Object)"testName2", (Object)RequiredCapability.extractName((IMatchExpression)metaReq1.getMatches()));
        Assert.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)metaReq1.getMatches()));
        Assert.assertEquals((Object)false, (Object)metaReq1.isGreedy());
        Assert.assertEquals((long)1L, (long)metaReq1.getMin());
        Assert.assertEquals((long)1L, (long)iu1.getTouchpointData().size());
        ITouchpointInstruction configure = ((ITouchpointData)iu1.getTouchpointData().iterator().next()).getInstruction("configure");
        Assert.assertEquals(null, (Object)configure.getImportAttribute());
        Assert.assertEquals((Object)"addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);", (Object)configure.getBody());
        ITouchpointInstruction unconfigure = ((ITouchpointData)iu1.getTouchpointData().iterator().next()).getInstruction("unconfigure");
        Assert.assertEquals((Object)"some.removeProgramArg", (Object)unconfigure.getImportAttribute());
        Assert.assertEquals((Object)"removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)", (Object)unconfigure.getBody());
        Assert.assertEquals((Object)MetadataFactory.createTouchpointType((String)"testTouchpointId", (Version)Version.create((String)"1.2.5")), (Object)iu1.getTouchpointType());
        Assert.assertEquals((Object)"testid1", (Object)RequiredCapability.extractName((IMatchExpression)((IMatchExpression)iu1.getUpdateDescriptor().getIUsBeingUpdated().iterator().next())));
        Assert.assertEquals((Object)new VersionRange("(1,2)"), (Object)RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)iu1.getUpdateDescriptor().getIUsBeingUpdated().iterator().next())));
        Assert.assertEquals((long)2L, (long)iu1.getUpdateDescriptor().getSeverity());
        Assert.assertEquals((Object)"some description", (Object)iu1.getUpdateDescriptor().getDescription());
        Assert.assertTrue((boolean)QueryUtil.isFragment((IInstallableUnit)iu1));
        Collection hostRequired = ((IInstallableUnitFragment)iu1).getHost();
        Assert.assertEquals((long)2L, (long)hostRequired.size());
        Iterator iterator = hostRequired.iterator();
        IRequirement requirement = (IRequirement)iterator.next();
        Assert.assertEquals((Object)"testNamespace1", (Object)RequiredCapability.extractNamespace((IMatchExpression)requirement.getMatches()));
        Assert.assertEquals((Object)"testName1", (Object)RequiredCapability.extractName((IMatchExpression)requirement.getMatches()));
        Assert.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)requirement.getMatches()));
        Assert.assertEquals((Object)true, (Object)requirement.isGreedy());
        Assert.assertEquals((long)0L, (long)requirement.getMin());
        IRequirement secondRequirement = (IRequirement)iterator.next();
        Assert.assertEquals((Object)"testNamespace2", (Object)RequiredCapability.extractNamespace((IMatchExpression)secondRequirement.getMatches()));
        Assert.assertEquals((Object)"testName2", (Object)RequiredCapability.extractName((IMatchExpression)secondRequirement.getMatches()));
        Assert.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)secondRequirement.getMatches()));
        Assert.assertEquals((Object)false, (Object)secondRequirement.isGreedy());
        Assert.assertEquals((long)1L, (long)secondRequirement.getMin());
    }
}

