/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.publisher.eclipse.DataLoader;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigCUsAction;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.LaunchingAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ConfigCUsActionTest
extends ActionTest {
    private static File configLocation = new File(TestActivator.getTestDataFolder(), "ConfigCUsActionTest/level1/level2/config.ini");
    private static File executableLocation = new File(TestActivator.getTestDataFolder(), "ConfigCUsActionTest/level1/run.exe");
    private static Version version = Version.create((String)"1.0.0");
    private static String id = "id";
    private static String flavor = "tooling";
    private IMetadataRepository metadataRepo;
    private DataLoader loader;

    @Override
    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
        this.testAction = new ConfigCUsAction(this.publisherInfo, flavor, id, version);
    }

    public void testAction() throws Exception {
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        this.verifyAction();
        this.debug("Completed ConfigCUsAction test.");
    }

    private void verifyAction() {
        ArrayList IUs = new ArrayList(this.publisherResult.getIUs(null, "root"));
        ConfigCUsActionTest.assertTrue((IUs.size() == 1 ? 1 : 0) != 0);
        InstallableUnit iu = (InstallableUnit)IUs.get(0);
        ConfigCUsActionTest.assertTrue((boolean)iu.getId().equalsIgnoreCase(flavor + id + ".configuration"));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.iu", iu.getId(), version);
        ConfigCUsActionTest.assertTrue((providedCapabilities.size() == 1 ? 1 : 0) != 0);
        List requiredCapability = iu.getRequirements();
        this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", flavor + id + ".config." + this.configSpec, new VersionRange(version, true, version, true));
        this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", flavor + id + ".ini." + this.configSpec, new VersionRange(version, true, version, true));
        ConfigCUsActionTest.assertTrue((requiredCapability.size() == 2 ? 1 : 0) != 0);
        this.verifyFragment("ini");
        this.verifyFragment("config");
    }

    private void verifyFragment(String cuType) {
        ArrayList IUs = new ArrayList(this.publisherResult.getIUs(null, "non_root"));
        ConfigCUsActionTest.assertTrue((IUs.size() == 2 ? 1 : 0) != 0);
        for (IInstallableUnit iu : IUs) {
            if (!iu.getId().equals(flavor + id + "." + cuType + "." + this.configSpec)) continue;
            ConfigCUsActionTest.assertTrue((boolean)iu.getFilter().equals(InstallableUnit.parseFilter((String)"(& (osgi.ws=win32)(osgi.os=win32)(osgi.arch=x86))")));
            ConfigCUsActionTest.assertTrue((boolean)iu.getVersion().equals(version));
            ConfigCUsActionTest.assertFalse((boolean)iu.isSingleton());
            Collection providedCapabilities = iu.getProvidedCapabilities();
            this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.iu", flavor + id + "." + cuType + "." + this.configSpec, version);
            this.verifyProvidedCapability(providedCapabilities, flavor + id, id + "." + cuType, version);
            ConfigCUsActionTest.assertTrue((providedCapabilities.size() == 2 ? 1 : 0) != 0);
            ConfigCUsActionTest.assertTrue((iu.getRequirements().size() == 0 ? 1 : 0) != 0);
            if (cuType.equals("ini")) {
                this.verifyLauncherArgs(iu);
            }
            if (cuType.equals("config")) {
                this.verifyConfigProperties(iu);
            }
            return;
        }
        ConfigCUsActionTest.fail();
    }

    private void verifyLauncherArgs(IInstallableUnit iu) {
        Collection touchpointData = iu.getTouchpointData();
        ConfigCUsActionTest.assertEquals((int)1, (int)touchpointData.size());
        ITouchpointData data = (ITouchpointData)touchpointData.iterator().next();
        ITouchpointInstruction instruction = data.getInstruction("configure");
        String body = instruction.getBody();
        ConfigCUsActionTest.assertTrue((String)"arg -foo bar", (boolean)body.contains("addProgramArg(programArg:-foo bar);"));
        ConfigCUsActionTest.assertTrue((String)"vmarg -agentlib", (boolean)body.contains("addJvmArg(jvmArg:-agentlib${#58}jdwp=transport=dt_socket${#44}server=y${#44}suspend=n${#44}address=8272);"));
        ConfigCUsActionTest.assertTrue((String)"arg -product com,ma", (boolean)body.contains("addProgramArg(programArg:-product);addProgramArg(programArg:com${#44}ma);"));
    }

    private void verifyConfigProperties(IInstallableUnit iu) {
        Collection touchpointData = iu.getTouchpointData();
        ConfigCUsActionTest.assertEquals((int)1, (int)touchpointData.size());
        ITouchpointData data = (ITouchpointData)touchpointData.iterator().next();
        ITouchpointInstruction instruction = data.getInstruction("configure");
        String body = instruction.getBody();
        ConfigCUsActionTest.assertTrue((String)"eclipse.product", (boolean)body.contains("setProgramProperty(propName:eclipse.product,propValue:org.eclipse.platform.ide);"));
        ConfigCUsActionTest.assertTrue((String)"eclipse.buildId", (boolean)body.contains("setProgramProperty(propName:eclipse.buildId,propValue:TEST-ID);"));
        ConfigCUsActionTest.assertTrue((String)"my.property", (boolean)body.contains("setProgramProperty(propName:my.property,propValue:${#123}a${#44}b${#58}c${#59}${#36}d${#125});"));
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        this.loader = new DataLoader(configLocation, executableLocation);
        ConfigData configData = this.loader.getConfigData();
        ConfigAdvice configAdvice = new ConfigAdvice(configData, this.configSpec);
        ArrayList<ConfigAdvice> configList = new ArrayList<ConfigAdvice>();
        configList.add(configAdvice);
        Mockito.when((Object)this.publisherInfo.getAdvice(ArgumentMatchers.matches((String)this.configSpec), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.anyString(), (Version)ArgumentMatchers.any(Version.class), (Class)ArgumentMatchers.eq(IConfigAdvice.class))).thenReturn(configList);
        LauncherData launcherData = this.loader.getLauncherData();
        LaunchingAdvice launchingAdvice = new LaunchingAdvice(launcherData, this.configSpec);
        ArrayList<Object> launchingList = new ArrayList<Object>();
        launchingList.add(launchingAdvice);
        try {
            String productFileLocation = TestData.getFile("ProductActionTest", "productFileActionTest.product").toString();
            ProductFileAdvice productAdvice = new ProductFileAdvice((IProductDescriptor)new ProductFile(productFileLocation), this.configSpec);
            launchingList.add(productAdvice);
        }
        catch (Exception productFileLocation) {
            // empty catch block
        }
        Mockito.when((Object)this.publisherInfo.getAdvice(ArgumentMatchers.matches((String)this.configSpec), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.anyString(), (Version)ArgumentMatchers.any(Version.class), (Class)ArgumentMatchers.eq(IExecutableAdvice.class))).thenReturn(launchingList);
        IInstallableUnit[] ius = new IInstallableUnit[]{this.mockIU("foo", null), this.mockIU("bar", null)};
        this.metadataRepo = new TestMetadataRepository(ConfigCUsActionTest.getAgent(), ius);
        Mockito.when((Object)this.publisherInfo.getMetadataRepository()).thenReturn((Object)this.metadataRepo);
        Mockito.when((Object)this.publisherInfo.getContextMetadataRepository()).thenReturn(null);
    }
}

