/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.eclipse.EquinoxExecutableAction;
import org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IMacOsBundleUrlType;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class EquinoxExecutableActionTest
extends ActionTest {
    private static final File MAC_EXEC = new File(TestActivator.getTestDataFolder(), "EquinoxExecutableActionTest/macosx/");
    private static final File LINUX_EXEC = new File(TestActivator.getTestDataFolder(), "EquinoxExecutableActionTest/linux/");
    private static final File WIN_EXEC = new File(TestActivator.getTestDataFolder(), "EquinoxExecutableActionTest/win/");
    private final String EXECUTABLE_NAME = "LauncherName";
    private final String macConfigCocoa = "cocoa.macosx.x86";
    private final String winConfig = "win32.win32.x86_64";
    private final String linuxConfig = "linux.gtk.x86_64";
    private ExecutablesDescriptor executablesDescriptor;
    private IArtifactRepository artifactRepository;
    private final Version version = Version.create((String)"1.2.3");
    private String id;
    private String[] expectedExecutablesContents;
    private static final Pattern PLIST_BUNDLE_URL_TYPES_PATTERN = Pattern.compile("<key>CFBundleURLTypes</key>\\s*<array>\\s*(.*</dict>.*?)\\s*</array>", 32);

    @Override
    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
        this.artifactRepository = new TestArtifactRepository(EquinoxExecutableActionTest.getAgent());
    }

    public void testMacCocoa() throws Exception {
        File icon = File.createTempFile("LauncherName", ".icns");
        Files.copy(new File(MAC_EXEC, "eclipse.app/Contents/Resources/eclipse.icns").toPath(), icon.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.expectedExecutablesContents = new String[]{"Info.plist", "MacOS/LauncherName", "MacOS/LauncherName.ini", "Resources/" + icon.getName()};
        this.testExecutableAction("macCocoa", "macosx", "cocoa.macosx.x86", MAC_EXEC, icon);
        icon.delete();
    }

    public void testWin() throws Exception {
        File icon = File.createTempFile("LauncherName", ".ico");
        Files.copy(new File(WIN_EXEC, "eclipse.ico").toPath(), icon.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.expectedExecutablesContents = new String[]{"LauncherName.exe"};
        this.testExecutableAction("win", "win32", "win32.win32.x86_64", WIN_EXEC, icon);
        icon.delete();
    }

    public void testLinux() throws Exception {
        File icon = File.createTempFile("LauncherName", ".xpm");
        Files.copy(new File(LINUX_EXEC, "eclipse.xpm").toPath(), icon.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.expectedExecutablesContents = new String[]{"LauncherName", "icon.xpm"};
        this.testExecutableAction("linux", "linux", "linux.gtk.x86_64", LINUX_EXEC, icon);
        icon.delete();
    }

    private void testExecutableAction(String idBase, String osArg, String config, File exec, File icon) {
        this.id = idBase;
        Mockito.when((Object)this.publisherInfo.getArtifactRepository()).thenReturn((Object)this.artifactRepository);
        Mockito.when((Object)this.publisherInfo.getArtifactOptions()).thenReturn((Object)2);
        Mockito.when((Object)this.publisherInfo.getAdvice(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class), (Version)ArgumentMatchers.nullable(Version.class), (Class)ArgumentMatchers.eq(IBrandingAdvice.class))).then(invocation -> this.setupBrandingAdvice(osArg, icon));
        this.executablesDescriptor = ExecutablesDescriptor.createDescriptor((String)osArg, (String)"eclipse", (File)exec);
        this.testAction = new EquinoxExecutableAction(this.executablesDescriptor, config, idBase, this.version, this.flavorArg);
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        this.verifyResults(idBase, config);
        this.debug("Completed EquinoxExecutableActionTest " + idBase + " test.");
    }

    private void verifyResults(String idBase, String confSpec) {
        ArrayList<IInstallableUnit> iuList = new ArrayList<IInstallableUnit>(this.publisherResult.getIUs(null, "root"));
        EquinoxExecutableActionTest.assertEquals((int)3, (int)iuList.size());
        this.verifyEclipseIU(iuList, idBase, confSpec);
        this.verifyCU(iuList, idBase, confSpec);
        this.verifyExecIU(iuList, idBase, confSpec);
    }

    private void verifyCU(ArrayList<IInstallableUnit> iuList, String idBase, String confSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec((String)confSpec);
        String _ws = config[0];
        String _os = config[1];
        String _arch = config[2];
        for (IInstallableUnit possibleEclipse : iuList) {
            if (!possibleEclipse.getId().equals(this.flavorArg + idBase + ".executable." + confSpec)) continue;
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)possibleEclipse;
            Collection providedCapability = fragment.getProvidedCapabilities();
            this.verifyProvidedCapability(providedCapability, "org.eclipse.equinox.p2.iu", this.flavorArg + idBase + ".executable." + confSpec, this.version);
            EquinoxExecutableActionTest.assertTrue((providedCapability.size() == 1 ? 1 : 0) != 0);
            Collection requiredCapability = fragment.getHost();
            this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", idBase + ".executable." + confSpec, new VersionRange(this.version, true, this.version, true));
            EquinoxExecutableActionTest.assertTrue((requiredCapability.size() == 1 ? 1 : 0) != 0);
            EquinoxExecutableActionTest.assertTrue((fragment.getFilter().getParameters()[0].toString().indexOf("(osgi.ws=" + _ws + ")") != -1 ? 1 : 0) != 0);
            EquinoxExecutableActionTest.assertTrue((fragment.getFilter().getParameters()[0].toString().indexOf("(osgi.os=" + _os + ")") != -1 ? 1 : 0) != 0);
            EquinoxExecutableActionTest.assertTrue((fragment.getFilter().getParameters()[0].toString().indexOf("(osgi.arch=" + _arch + ")") != -1 ? 1 : 0) != 0);
            EquinoxExecutableActionTest.assertTrue((boolean)fragment.getProperty("org.eclipse.equinox.p2.type.fragment").equals("true"));
            return;
        }
        EquinoxExecutableActionTest.fail();
    }

    private void verifyEclipseIU(ArrayList<IInstallableUnit> iuList, String idBase, String confSpec) {
        for (IInstallableUnit possibleEclipse : iuList) {
            if (!possibleEclipse.getId().equals(idBase + ".executable." + confSpec + ".LauncherName")) continue;
            EquinoxExecutableActionTest.assertEquals((Object)this.version, (Object)possibleEclipse.getVersion());
            Collection providedCapability = possibleEclipse.getProvidedCapabilities();
            this.verifyProvidedCapability(providedCapability, "org.eclipse.equinox.p2.iu", idBase + ".executable." + confSpec + ".LauncherName", this.version);
            EquinoxExecutableActionTest.assertEquals((int)1, (int)providedCapability.size());
            Collection req = possibleEclipse.getRequirements();
            EquinoxExecutableActionTest.assertEquals((int)0, (int)req.size());
            return;
        }
        EquinoxExecutableActionTest.fail((String)"No executable installable unit.");
    }

    private void verifyExecIU(ArrayList<IInstallableUnit> iuList, String idBase, String confSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec((String)confSpec);
        String _ws = config[0];
        String _os = config[1];
        String _arch = config[2];
        for (IInstallableUnit possibleExec : iuList) {
            if (!possibleExec.getId().equals(idBase + ".executable." + confSpec)) continue;
            EquinoxExecutableActionTest.assertTrue((boolean)possibleExec.getFilter().equals(InstallableUnit.parseFilter((String)("(& (osgi.ws=" + _ws + ")(osgi.os=" + _os + ")(osgi.arch=" + _arch + "))"))));
            IArtifactKey eKey = (IArtifactKey)possibleExec.getArtifacts().iterator().next();
            EquinoxExecutableActionTest.assertTrue((boolean)eKey.getClassifier().equals("binary"));
            EquinoxExecutableActionTest.assertTrue((boolean)eKey.getId().equals(idBase + ".executable." + confSpec));
            EquinoxExecutableActionTest.assertTrue((boolean)eKey.getVersion().equals(this.version));
            Collection providedCapabilities = possibleExec.getProvidedCapabilities();
            this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.iu", idBase + ".executable." + confSpec, this.version);
            this.verifyProvidedCapability(providedCapabilities, this.flavorArg + idBase, idBase + ".executable", this.version);
            EquinoxExecutableActionTest.assertTrue((providedCapabilities.size() == 2 ? 1 : 0) != 0);
            Collection requiredCapability = possibleExec.getRequirements();
            this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", "org.eclipse.equinox.launcher." + confSpec, VersionRange.emptyRange);
            EquinoxExecutableActionTest.assertTrue((requiredCapability.size() == 1 ? 1 : 0) != 0);
            try {
                this.checkExecutableContents(eKey);
            }
            catch (IOException e) {
                EquinoxExecutableActionTest.fail();
            }
            return;
        }
        EquinoxExecutableActionTest.fail();
    }

    private void checkExecutableContents(IArtifactKey key) throws IOException {
        File file = File.createTempFile("exec", ".zip");
        Throwable throwable = null;
        Object var4_6 = null;
        try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            IArtifactDescriptor ad = this.artifactRepository.createArtifactDescriptor(key);
            IStatus result = this.artifactRepository.getArtifact(ad, fos, (IProgressMonitor)new NullProgressMonitor());
            EquinoxExecutableActionTest.assertTrue((String)"executable not published?", (boolean)result.isOK());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try (ZipFile zip = new ZipFile(file);){
            String[] stringArray = this.expectedExecutablesContents;
            int n = this.expectedExecutablesContents.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                EquinoxExecutableActionTest.assertNotNull((String)("executable zip missing " + path), (Object)zip.getEntry(path));
                ++n2;
            }
            if (key.getId().contains("macosx")) {
                this.checkInfoPlist(zip);
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        file.delete();
    }

    private void checkInfoPlist(ZipFile zip) throws IOException {
        Optional<ZipEntry> candidate = zip.stream().filter(e -> e.getName().endsWith("Info.plist")).findFirst();
        EquinoxExecutableActionTest.assertTrue((boolean)candidate.isPresent());
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = zip.getInputStream(candidate.get());){
            String contents = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            EquinoxExecutableActionTest.assertEquals((String)this.id, (String)this.getPlistStringValue(contents, "CFBundleIdentifier"));
            EquinoxExecutableActionTest.assertEquals((String)"LauncherName", (String)this.getPlistStringValue(contents, "CFBundleExecutable"));
            EquinoxExecutableActionTest.assertEquals((String)"LauncherName", (String)this.getPlistStringValue(contents, "CFBundleName"));
            EquinoxExecutableActionTest.assertEquals((String)"LauncherName", (String)this.getPlistStringValue(contents, "CFBundleDisplayName"));
            EquinoxExecutableActionTest.assertEquals((String)this.version.toString(), (String)this.getPlistStringValue(contents, "CFBundleVersion"));
            EquinoxExecutableActionTest.assertEquals((String)"<dict>\n\t<key>CFBundleURLName</key>\n\t<string>Eclipse Command</string>\n\t<key>CFBundleURLSchemes</key>\n\t<array>\n\t\t<string>eclipse+command</string>\n\t</array>\n</dict>\n<dict>\n\t<key>CFBundleURLName</key>\n\t<string>Vendor Application</string>\n\t<key>CFBundleURLSchemes</key>\n\t<array>\n\t\t<string>vendor</string>\n\t</array>\n</dict>".replaceAll(">\\s+<", "><"), (String)this.getPlistBundleUrlTypesXmlWithoutWhitespace(contents));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getPlistStringValue(String contents, String key) {
        Pattern p = Pattern.compile("<key>" + key + "</key>\\s*<string>([^<]*)</string>");
        Matcher m = p.matcher(contents);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String getPlistBundleUrlTypesXmlWithoutWhitespace(String contents) {
        Matcher m = PLIST_BUNDLE_URL_TYPES_PATTERN.matcher(contents);
        if (m.find()) {
            return m.group(1).replace("\\n", "").replaceAll(">\\s+<", "><");
        }
        return null;
    }

    private List<IBrandingAdvice> setupBrandingAdvice(final String osArg, final File icon) {
        LinkedList<IBrandingAdvice> brandingAdvice = new LinkedList<IBrandingAdvice>();
        brandingAdvice.add(new IBrandingAdvice(){

            public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
                return true;
            }

            public String getOS() {
                return osArg;
            }

            public String[] getIcons() {
                String[] stringArray;
                if (icon == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = icon.getAbsolutePath();
                }
                return stringArray;
            }

            public String getExecutableName() {
                return "LauncherName";
            }

            public List<IMacOsBundleUrlType> getMacOsBundleUrlTypes() {
                IMacOsBundleUrlType scheme1 = (IMacOsBundleUrlType)Mockito.mock(IMacOsBundleUrlType.class);
                Mockito.when((Object)scheme1.getName()).thenReturn((Object)"Eclipse Command");
                Mockito.when((Object)scheme1.getScheme()).thenReturn((Object)"eclipse+command");
                IMacOsBundleUrlType scheme2 = (IMacOsBundleUrlType)Mockito.mock(IMacOsBundleUrlType.class);
                Mockito.when((Object)scheme2.getName()).thenReturn((Object)"Vendor Application");
                Mockito.when((Object)scheme2.getScheme()).thenReturn((Object)"vendor");
                return List.of(scheme1, scheme2);
            }
        });
        return brandingAdvice;
    }
}

