/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.publisher.eclipse.IBundleShapeAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FeaturesActionTest
extends ActionTest {
    public static IArtifactKey FOO_KEY = ArtifactKey.parse((String)"org.eclipse.update.feature,foo,1.0.0");
    public static IArtifactKey BAR_KEY = ArtifactKey.parse((String)"org.eclipse.update.feature,bar,1.1.1");
    private static File root = new File(TestActivator.getTestDataFolder().toString(), "FeaturesActionTest");
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(FeaturesActionTest.getAgent());
    protected TestMetadataRepository metadataRepository;
    private final Version fooVersion = Version.create((String)"1.0.0");
    private final Version barVersion = Version.create((String)"1.1.1");
    private final String BAR = "bar";
    private final String FOO = "foo";
    private final ArgumentCaptor<ITouchpointAdvice> capture = ArgumentCaptor.forClass(ITouchpointAdvice.class);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testAction = (AbstractPublisherAction)Mockito.spy((Object)new FeaturesAction(new File[]{root}));
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    public void testSimple() throws Exception {
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        ((IPublisherInfo)Mockito.verify((Object)this.publisherInfo, (VerificationMode)Mockito.atLeastOnce())).addAdvice((IPublisherAdvice)this.capture.capture());
        this.verifyRepositoryContents();
        this.debug("Completed FeaturesAction.");
    }

    public void testFeaturePatch() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testFilters");
        StringBuilder buffer = new StringBuilder();
        buffer.append("<feature id=\"test.feature\" version=\"1.0.0\" >                                       \n");
        buffer.append("   <requires>                                                                          \n");
        buffer.append("      <import feature=\"org.foo\" version=\"[1.0.0,2.0.0)\" match=\"versionRange\" patch=\"true\"/>  \n");
        buffer.append("   </requires>                                                                         \n");
        buffer.append("</feature>                                                                             \n");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, buffer);
        this.publisherInfo = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnitPatch iu = (IInstallableUnitPatch)this.publisherResult.getIU("test.feature.feature.group", Version.parseVersion((String)"1.0.0"), null);
        IRequirement[][] applicabilityScope = iu.getApplicabilityScope();
        FeaturesActionTest.assertEquals((int)1, (int)applicabilityScope.length);
        IRequiredCapability require = (IRequiredCapability)applicabilityScope[0][0];
        IRequirement expected = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.foo.feature.group", (VersionRange)VersionRange.create((String)"[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)true);
        this.verifyRequirement(Collections.singleton(expected), (IRequirement)require);
    }

    public void testMatchRange() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testFilters");
        StringBuilder buffer = new StringBuilder();
        buffer.append("<feature id=\"test.feature\" version=\"1.0.0\" >                                       \n");
        buffer.append("   <requires>                                                                          \n");
        buffer.append("      <import plugin=\"org.plug\" version=\"[1.0.0,2.0.0)\" match=\"versionRange\" />  \n");
        buffer.append("      <import feature=\"org.foo\" version=\"[1.0.0,2.0.0)\" match=\"versionRange\" />  \n");
        buffer.append("   </requires>                                                                         \n");
        buffer.append("</feature>                                                                             \n");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, buffer);
        this.publisherInfo = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = this.publisherResult.getIU("test.feature.feature.group", Version.parseVersion((String)"1.0.0"), null);
        Collection requires = iu.getRequirements();
        FeaturesActionTest.assertEquals((int)3, (int)requires.size());
        for (IRequirement require : requires) {
            IRequirement expected;
            String requireName = ((IRequiredCapability)require).getName();
            if (requireName.equals("org.foo.feature.group")) {
                expected = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.foo.feature.group", (VersionRange)VersionRange.create((String)"[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)true);
                this.verifyRequirement(Collections.singleton(expected), require);
                continue;
            }
            if (!requireName.equals("org.plug")) continue;
            expected = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.plug", (VersionRange)VersionRange.create((String)"[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)true);
            this.verifyRequirement(Collections.singleton(expected), require);
        }
    }

    public void testMatchGreaterOrEqual() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testFilters");
        StringBuilder buffer = new StringBuilder();
        buffer.append("<feature id=\"test.feature\" version=\"1.0.0\" >                                       \n");
        buffer.append("   <requires>                                                                          \n");
        buffer.append("      <import plugin=\"org.plug\" version=\"1.0.0\" match=\"greaterOrEqual\" />        \n");
        buffer.append("      <import feature=\"org.foo\" version=\"1.0.0\" match=\"greaterOrEqual\" />        \n");
        buffer.append("   </requires>                                                                         \n");
        buffer.append("</feature>                                                                             \n");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, buffer);
        this.publisherInfo = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = this.publisherResult.getIU("test.feature.feature.group", Version.parseVersion((String)"1.0.0"), null);
        Collection requires = iu.getRequirements();
        FeaturesActionTest.assertEquals((int)3, (int)requires.size());
        for (IRequirement require : requires) {
            IRequirement expected;
            String requireName = ((IRequiredCapability)require).getName();
            if (requireName.equals("org.foo.feature.group")) {
                expected = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.foo.feature.group", (VersionRange)VersionRange.create((String)"1.0.0"), null, (boolean)false, (boolean)false, (boolean)true);
                this.verifyRequirement(Collections.singleton(expected), require);
                continue;
            }
            if (!requireName.equals("org.plug")) continue;
            expected = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.plug", (VersionRange)VersionRange.create((String)"1.0.0"), null, (boolean)false, (boolean)false, (boolean)true);
            this.verifyRequirement(Collections.singleton(expected), require);
        }
    }

    public void testUnpack() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testUnpack");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, "<feature id=\"test.feature\" version=\"1.0.0\" >\n   <plugin id=\"org.plugin1\" version =\"1.0.0\" />\n   <plugin id=\"org.plugin2\" version =\"1.0.0\" unpack=\"true\" />\n   <plugin id=\"org.plugin3\" version =\"1.0.0\" unpack=\"false\" />\n   <requires>\n      <import plugin=\"org.import1\"/>\n      <import plugin=\"org.import2\" unpack=\"true\"/>\n   \t  <import plugin=\"org.import3\" unpack=\"false\"/>\n   </requires>\n</feature>\n");
        PublisherInfo info = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        PublisherResult results = new PublisherResult();
        action.perform((IPublisherInfo)info, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        this.assertShapeAdvice(info, "org.plugin1", "jar");
        this.assertShapeAdvice(info, "org.plugin2", "dir");
        this.assertShapeAdvice(info, "org.plugin3", "jar");
        this.assertShapeAdvice(info, "org.import1", "jar");
        this.assertShapeAdvice(info, "org.import2", "jar");
        this.assertShapeAdvice(info, "org.import3", "jar");
    }

    protected void assertShapeAdvice(PublisherInfo info, String bundle, String shape) {
        Iterator iterator = info.getAdvice(null, true, bundle, Version.create((String)"1.0.0"), IBundleShapeAdvice.class).iterator();
        if (iterator.hasNext()) {
            IBundleShapeAdvice shapeAdvice = (IBundleShapeAdvice)iterator.next();
            FeaturesActionTest.assertEquals((String)(bundle + " has wrong advice"), (String)shape, (String)shapeAdvice.getShape());
            return;
        }
        if ("jar".equals(shape)) {
            return;
        }
        FeaturesActionTest.fail((String)(shape + " was expected for " + bundle + " but no advice was found!"));
    }

    public void testFilters() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testFilters");
        StringBuilder buffer = new StringBuilder();
        buffer.append("<feature id=\"test.feature\" version=\"1.0.0\" >                                       \n");
        buffer.append("   <includes id=\"org.foo\" version=\"1.0.0\" filter=\"(osgi.os=win32)\"/>             \n");
        buffer.append("   <plugin id=\"org.plug\" version=\"1.0.0\" filter=\"(my.prop=foo)\" os=\"win32\" />  \n");
        buffer.append("   <requires>                                                                          \n");
        buffer.append("      <import plugin=\"org.plug2\" version=\"1.0.0\" filter=\"(my.prop=foo)\" />       \n");
        buffer.append("      <import feature=\"org.foo2\" version=\"1.0.0\" filter=\"(my.prop=foo)\" />       \n");
        buffer.append("   </requires>                                                                         \n");
        buffer.append("</feature>                                                                             \n");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, buffer);
        this.publisherInfo = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = this.publisherResult.getIU("test.feature.feature.group", Version.parseVersion((String)"1.0.0"), null);
        Collection requires = iu.getRequirements();
        FeaturesActionTest.assertEquals((int)5, (int)requires.size());
        for (IRequirement require : requires) {
            if (((IRequiredCapability)require).getName().equals("org.foo.feature.group")) {
                FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(osgi.os=win32)"), (Object)require.getFilter().getParameters()[0]);
                continue;
            }
            if (((IRequiredCapability)require).getName().equals("org.plug")) {
                FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(&(my.prop=foo)(osgi.os=win32))"), (Object)require.getFilter().getParameters()[0]);
                continue;
            }
            if (((IRequiredCapability)require).getName().equals("org.plug2")) {
                FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(&(my.prop=foo)(!(org.eclipse.equinox.p2.exclude.import=true)))"), (Object)require.getFilter().getParameters()[0]);
                continue;
            }
            if (!((IRequiredCapability)require).getName().equals("org.foo2.feature.group")) continue;
            FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(&(my.prop=foo)(!(org.eclipse.equinox.p2.exclude.import=true)))"), (Object)require.getFilter().getParameters()[0]);
        }
    }

    private void verifyRepositoryContents() throws Exception {
        this.verifyArtifacts();
        this.verifyMetadata();
    }

    private void verifyMetadata() {
        ArrayList fooIUs = new ArrayList(this.publisherResult.getIUs("foo.feature.jar", "non_root"));
        FeaturesActionTest.assertEquals((int)1, (int)fooIUs.size());
        IInstallableUnit foo = (IInstallableUnit)fooIUs.get(0);
        FeaturesActionTest.assertTrue((boolean)foo.getId().equalsIgnoreCase("foo.feature.jar"));
        FeaturesActionTest.assertEquals((Object)this.fooVersion, (Object)foo.getVersion());
        FeaturesActionTest.assertEquals((String)"Foo Feature", (String)foo.getProperty("org.eclipse.equinox.p2.name"));
        FeaturesActionTest.assertEquals((String)"Foo Description", (String)foo.getProperty("org.eclipse.equinox.p2.description"));
        FeaturesActionTest.assertEquals((String)"Foo License", (String)((ILicense)foo.getLicenses().iterator().next()).getBody());
        FeaturesActionTest.assertEquals((String)"Foo Copyright", (String)foo.getCopyright().getBody());
        FeaturesActionTest.assertEquals((String)"value1", (String)foo.getProperty("key1"));
        FeaturesActionTest.assertEquals((String)"value2", (String)foo.getProperty("key2"));
        FeaturesActionTest.assertEquals((Object)FOO_KEY, foo.getArtifacts().iterator().next());
        FeaturesActionTest.assertEquals((Object)foo.getFilter().getParameters()[0], (Object)ExpressionUtil.parseLDAP((String)"(org.eclipse.update.install.features=true)"));
        FeaturesActionTest.assertTrue((boolean)foo.getTouchpointType().getId().equalsIgnoreCase("org.eclipse.equinox.p2.osgi"));
        FeaturesActionTest.assertEquals((Object)this.fooVersion, (Object)foo.getTouchpointType().getVersion());
        Collection tpData = foo.getTouchpointData();
        String fooValue = ((ITouchpointInstruction)((ITouchpointData)tpData.iterator().next()).getInstructions().get("zipped")).getBody();
        FeaturesActionTest.assertTrue((boolean)fooValue.equalsIgnoreCase("true"));
        Collection fooRequiredCapabilities = foo.getRequirements();
        FeaturesActionTest.assertTrue((boolean)fooRequiredCapabilities.isEmpty());
        Collection fooProvidedCapabilities = foo.getProvidedCapabilities();
        this.verifyProvidedCapability(fooProvidedCapabilities, "org.eclipse.equinox.p2.iu", "foo.feature.jar", this.fooVersion);
        this.verifyProvidedCapability(fooProvidedCapabilities, "org.eclipse.equinox.p2.eclipse.type", "feature", this.fooVersion);
        this.verifyProvidedCapability(fooProvidedCapabilities, "org.eclipse.update.feature", "foo", this.fooVersion);
        FeaturesActionTest.assertEquals((int)3, (int)fooProvidedCapabilities.size());
        fooIUs = new ArrayList(this.publisherResult.getIUs("foo.feature.group", "root"));
        FeaturesActionTest.assertEquals((int)1, (int)fooIUs.size());
        IInstallableUnit fooGroup = (IInstallableUnit)fooIUs.get(0);
        ITouchpointAdvice tData = (ITouchpointAdvice)this.capture.getValue();
        ITouchpointInstruction instruction = tData.getTouchpointData(NO_TP_DATA).getInstruction("install");
        FeaturesActionTest.assertNotNull((Object)instruction);
        FeaturesActionTest.assertEquals((String)"ln(targetDir:@artifact,linkTarget:foo/lib.1.so,linkName:lib.so);chmod(targetDir:@artifact,targetFile:lib/lib.so,permissions:755);", (String)instruction.getBody());
        FeaturesActionTest.assertNull((Object)fooGroup.getFilter());
        ArrayList barIUs = new ArrayList(this.publisherResult.getIUs("bar.feature.jar", "non_root"));
        FeaturesActionTest.assertEquals((int)1, (int)barIUs.size());
        IInstallableUnit bar = (IInstallableUnit)barIUs.get(0);
        FeaturesActionTest.assertEquals((String)"bar.feature.jar", (String)bar.getId());
        FeaturesActionTest.assertEquals((Object)this.barVersion, (Object)bar.getVersion());
        FeaturesActionTest.assertEquals((String)"value1", (String)bar.getProperty("key1"));
        FeaturesActionTest.assertEquals((String)"value2", (String)bar.getProperty("key2"));
        FeaturesActionTest.assertTrue((boolean)bar.getProperties().containsKey("org.eclipse.update.installHandler"));
        FeaturesActionTest.assertTrue((boolean)bar.getProperties().containsValue("handler=bar handler"));
        FeaturesActionTest.assertEquals((Object)BAR_KEY, bar.getArtifacts().iterator().next());
        FeaturesActionTest.assertEquals((Object)bar.getFilter().getParameters()[0], (Object)ExpressionUtil.parseLDAP((String)"(org.eclipse.update.install.features=true)"));
        FeaturesActionTest.assertTrue((boolean)bar.isSingleton());
        barIUs = new ArrayList(this.publisherResult.getIUs("bar.feature.group", "root"));
        FeaturesActionTest.assertEquals((int)1, (int)fooIUs.size());
        IInstallableUnit barGroup = (IInstallableUnit)barIUs.get(0);
        Collection barRequiredCapabilities = barGroup.getRequirements();
        this.verifyRequirement(barRequiredCapabilities, "org.eclipse.equinox.p2.iu", "bar.feature.jar", new VersionRange(this.barVersion, true, this.barVersion, true), "(org.eclipse.update.install.features=true)", 1, 1, true);
        this.verifyRequirement(barRequiredCapabilities, "org.eclipse.equinox.p2.iu", "org.bar.feature.feature.group", VersionRange.emptyRange, "(&(|(osgi.nl=de)(osgi.nl=en)(osgi.nl=fr)))", 1, 1, true);
        FeaturesActionTest.assertEquals((Object)barGroup.getFilter().getParameters()[0], (Object)ExpressionUtil.parseLDAP((String)"(&(|(osgi.os=macosx)(osgi.os=win32))(|(osgi.ws=carbon)(osgi.ws=win32))(|(osgi.arch=ppc)(osgi.arch=x86))(osgi.nl=en))"));
        String barValue = ((ITouchpointInstruction)((ITouchpointData)bar.getTouchpointData().iterator().next()).getInstructions().get("zipped")).getBody();
        FeaturesActionTest.assertTrue((boolean)barValue.equalsIgnoreCase("true"));
        FeaturesActionTest.assertTrue((boolean)bar.getTouchpointType().getId().equalsIgnoreCase("org.eclipse.equinox.p2.osgi"));
        FeaturesActionTest.assertEquals((Object)this.fooVersion, (Object)bar.getTouchpointType().getVersion());
        barRequiredCapabilities = bar.getRequirements();
        FeaturesActionTest.assertTrue((boolean)barRequiredCapabilities.isEmpty());
        Collection barProvidedCapabilities = bar.getProvidedCapabilities();
        this.verifyProvidedCapability(barProvidedCapabilities, "org.eclipse.equinox.p2.iu", "bar.feature.jar", this.barVersion);
        this.verifyProvidedCapability(barProvidedCapabilities, "org.eclipse.equinox.p2.eclipse.type", "feature", this.fooVersion);
        this.verifyProvidedCapability(barProvidedCapabilities, "org.eclipse.update.feature", "bar", this.barVersion);
        FeaturesActionTest.assertEquals((int)3, (int)barProvidedCapabilities.size());
    }

    private void verifyArtifacts() throws IOException {
        ZipInputStream actualStream = this.artifactRepository.getZipInputStream(FOO_KEY);
        Map<String, Object[]> expected = this.getFileMap(new HashMap<String, Object[]>(), new File[]{new File(root, "foo")}, IPath.fromFile((File)new File(root, "foo")));
        TestData.assertContains(expected, actualStream, true);
        expected = this.getFileMap(new HashMap<String, Object[]>(), new File[]{new File(root, "bar")}, IPath.fromFile((File)new File(root, "bar")));
        actualStream = this.artifactRepository.getZipInputStream(BAR_KEY);
        TestData.assertContains(expected, actualStream, true);
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        this.metadataRepository = new TestMetadataRepository(FeaturesActionTest.getAgent(), this.mockIU("bar", null));
        List<IPropertyAdvice> adviceCollection = this.fillAdvice(new ArrayList<IPropertyAdvice>());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.jar", this.barVersion, IPropertyAdvice.class)).thenReturn(adviceCollection);
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar", this.barVersion, IPropertyAdvice.class)).thenReturn(adviceCollection);
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar", this.barVersion, IFeatureRootAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, IPropertyAdvice.class)).thenReturn(adviceCollection);
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, ITouchpointAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, ICapabilityAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, IAdditionalInstallableUnitAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.jar", this.fooVersion, IPropertyAdvice.class)).thenReturn(adviceCollection);
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, IUpdateDescriptorAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "foo", this.fooVersion, IPropertyAdvice.class)).thenReturn(adviceCollection);
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "foo", this.fooVersion, IFeatureRootAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, IPropertyAdvice.class)).thenReturn(adviceCollection);
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, ICapabilityAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, IAdditionalInstallableUnitAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, IUpdateDescriptorAdvice.class)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.publisherInfo.getArtifactOptions()).thenReturn((Object)7);
        Mockito.when((Object)this.publisherInfo.getArtifactRepository()).thenReturn((Object)this.artifactRepository);
        Mockito.when((Object)this.publisherInfo.getMetadataRepository()).thenReturn((Object)this.metadataRepository);
        Mockito.when((Object)this.publisherInfo.getContextMetadataRepository()).thenReturn(null);
    }

    private List<IPropertyAdvice> fillAdvice(ArrayList<IPropertyAdvice> adviceCollection) {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key1", "value1");
        prop.put("key2", "value2");
        IPropertyAdvice propertyAdvice = (IPropertyAdvice)Mockito.mock(IPropertyAdvice.class);
        Mockito.when((Object)propertyAdvice.getInstallableUnitProperties((MetadataFactory.InstallableUnitDescription)ArgumentMatchers.any(MetadataFactory.InstallableUnitDescription.class))).thenReturn(prop);
        Mockito.when((Object)propertyAdvice.getArtifactProperties((IInstallableUnit)ArgumentMatchers.any(IInstallableUnit.class), (IArtifactDescriptor)ArgumentMatchers.any(IArtifactDescriptor.class))).thenReturn(null);
        adviceCollection.add(propertyAdvice);
        return adviceCollection;
    }
}

