/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class JREActionTest
extends ActionTest {
    private final File J14 = new File(TestActivator.getTestDataFolder(), "JREActionTest/1.4/");
    private final File J15 = new File(TestActivator.getTestDataFolder(), "JREActionTest/1.5/");
    private final File J16 = new File(TestActivator.getTestDataFolder(), "JREActionTest/1.6/");
    private final File jreWithPackageVersionsFolder = new File(TestActivator.getTestDataFolder(), "JREActionTest/packageVersions/");
    private final File jreWithPackageVersionsProfile = new File(TestActivator.getTestDataFolder(), "JREActionTest/packageVersions/test-1.0.0.profile");
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(JREActionTest.getAgent());
    protected TestMetadataRepository metadataRepository;

    @Override
    @Before
    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    @Test
    public void test14() throws Exception {
        this.performAction(new JREAction(this.J14));
        Version jreVersion = Version.create((String)"1.4.0");
        this.verifyMetadataIU("a.jre.j2se", 91, 0, jreVersion);
        this.verifyConfigIU("a.jre.j2se", jreVersion);
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.j2se,1.4.0"), this.J14, "J2SE-1.4.profile");
    }

    @Test
    public void test15() throws Exception {
        this.performAction(new JREAction(this.J15));
        Version jreVersion = Version.create((String)"1.5.0");
        this.verifyMetadataIU("a.jre.j2se", 118, 0, jreVersion);
        this.verifyConfigIU("a.jre.j2se", jreVersion);
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.j2se,1.5.0"), this.J15, "J2SE-1.5.profile");
    }

    @Test
    public void test16() throws Exception {
        this.performAction(new JREAction(this.J16));
        Version jreVersion = Version.create((String)"1.6.0");
        this.verifyMetadataIU("a.jre.javase", 116, 0, jreVersion);
        this.verifyConfigIU("a.jre.javase", jreVersion);
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.javase,1.6.0"), this.J16, "JavaSE-1.6.profile");
    }

    @Test
    public void testOSGiMin() throws Exception {
        this.performAction(new JREAction("OSGi/Minimum-1.2"));
        Version jreVersion = Version.create((String)"1.2.0");
        this.verifyMetadataIU("a.jre.osgi.minimum", 16, 3, jreVersion);
    }

    @Test
    public void testPackageVersionsFromJreFolder() throws Exception {
        this.performAction(new JREAction(this.jreWithPackageVersionsFolder));
        Collection<IProvidedCapability> providedCapabilities = this.getPublishedCapabilitiesOf("a.jre.test");
        MatcherAssert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", null)));
        MatcherAssert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", (Version)Version.create((String)"1.0.0"))));
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.test,1.0.0"), this.jreWithPackageVersionsFolder, "test-1.0.0.profile");
    }

    @Test
    public void testPackageVersionsFromJavaProfile() throws Exception {
        this.performAction(new JREAction(this.jreWithPackageVersionsProfile));
        Collection<IProvidedCapability> providedCapabilities = this.getPublishedCapabilitiesOf("a.jre.test");
        MatcherAssert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", null)));
        MatcherAssert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", (Version)Version.create((String)"1.0.0"))));
    }

    @Test
    public void testDefaultJavaProfile() throws Exception {
        this.performAction(new JREAction(null));
        int runtimeVersion = Runtime.version().feature();
        this.verifyMetadataIU("a.jre.javase", 226, 23, Version.parseVersion((String)(runtimeVersion + ".0.0")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonExistingJreLocation() {
        File nonExistingProfile = new File(this.jreWithPackageVersionsFolder, "no.profile");
        this.performAction(new JREAction(nonExistingProfile));
    }

    @Test
    public void testOsgiEECapabilities() {
        this.performAction(new JREAction("J2SE-1.5"));
        Collection<IProvidedCapability> capabilities = this.getPublishedCapabilitiesOf("a.jre.j2se");
        MatcherAssert.assertThat(capabilities, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)JREActionTest.createEECapability("JavaSE", "1.6"))));
        MatcherAssert.assertThat(capabilities, (Matcher)CoreMatchers.hasItem((Object)JREActionTest.createEECapability("JavaSE", "1.5")));
        MatcherAssert.assertThat(capabilities, (Matcher)CoreMatchers.hasItem((Object)JREActionTest.createEECapability("OSGi/Minimum", "1.0")));
        MatcherAssert.assertThat(capabilities, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)JREActionTest.createEECapability("J2SE", "1.5"))));
    }

    @Test
    public void testSingleOsgiEECapability() {
        this.performAction(new JREAction("OSGi/Minimum-1.0"));
        Collection<IProvidedCapability> capabilities = this.getPublishedCapabilitiesOf("a.jre.osgi.minimum");
        MatcherAssert.assertThat(capabilities, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)JREActionTest.createEECapability("JavaSE", "1.5"))));
        MatcherAssert.assertThat(capabilities, (Matcher)CoreMatchers.hasItem((Object)JREActionTest.createEECapability("OSGi/Minimum", "1.0")));
    }

    @Test
    public void testInvalidOsgiEECapabilitySpec() {
        this.testAction = new JREAction(new File(TestActivator.getTestDataFolder(), "JREActionTest/invalidOsgiEE/ee-capability-syntax-test.profile"));
        IStatus status = this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.errorStatus()));
        IStatus eeStatus = status.getChildren()[0];
        MatcherAssert.assertThat((Object)eeStatus.getMessage(), (Matcher)CoreMatchers.containsString((String)"org.osgi.framework.system.capabilities"));
        MatcherAssert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Attribute 'osgi.ee' is missing"))));
        MatcherAssert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Either 'version:Version' or 'version:List<Version>' must be specified"))));
        MatcherAssert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Syntax error in version '1.a.invalidversion'"))));
        MatcherAssert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Ignoring unknown capability namespace 'other.namespace'"))));
        MatcherAssert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Cannot specify both 'version:Version' and 'version:List<Version>'"))));
        JREActionTest.assertEquals((int)5, (int)eeStatus.getChildren().length);
    }

    private void performAction(JREAction jreAction) {
        IStatus status = jreAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
    }

    private void verifyMetadataIU(String id, int expectedProvidedPackages, int expectedProvidedEEs, Version jreVersion) {
        IInstallableUnit foo = this.getPublishedUnit(id);
        JREActionTest.assertEquals((Object)jreVersion, (Object)foo.getVersion());
        JREActionTest.assertTrue((boolean)foo.getTouchpointType().getId().equalsIgnoreCase("org.eclipse.equinox.p2.native"));
        JREActionTest.assertEquals((Object)Version.create((String)"1.0.0"), (Object)foo.getTouchpointType().getVersion());
        Collection fooProvidedCapabilities = foo.getProvidedCapabilities();
        int expected = expectedProvidedPackages + expectedProvidedEEs;
        JREActionTest.assertTrue((fooProvidedCapabilities.size() >= expected ? 1 : 0) != 0);
    }

    private void verifyConfigIU(String id, Version jreVersion) {
        IInstallableUnit bar = this.getPublishedUnit("config." + id);
        Map instructions = ((ITouchpointData)bar.getTouchpointData().iterator().next()).getInstructions();
        JREActionTest.assertEquals((String)"unzip(source:@artifact, target:${installFolder});", (String)((ITouchpointInstruction)instructions.get("install")).getBody());
        JREActionTest.assertEquals((String)"cleanupzip(source:@artifact, target:${installFolder});", (String)((ITouchpointInstruction)instructions.get("uninstall")).getBody());
        JREActionTest.assertTrue((boolean)(bar instanceof IInstallableUnitFragment));
        Collection requiredCapability = ((IInstallableUnitFragment)bar).getHost();
        this.verifyRequirement(requiredCapability, "org.eclipse.equinox.p2.iu", id, new VersionRange(jreVersion, true, Version.MAX_VERSION, true));
        JREActionTest.assertEquals((int)1, (int)requiredCapability.size());
        Collection providedCapability = bar.getProvidedCapabilities();
        this.verifyProvidedCapability(providedCapability, "org.eclipse.equinox.p2.iu", "config." + id, jreVersion);
        JREActionTest.assertEquals((int)1, (int)providedCapability.size());
        JREActionTest.assertEquals((String)"true", (String)bar.getProperty("org.eclipse.equinox.p2.type.fragment"));
        JREActionTest.assertEquals((Object)jreVersion, (Object)bar.getVersion());
    }

    private void verifyArtifactRepository(IArtifactKey key, File JRELocation, String fileName) throws IOException {
        JREActionTest.assertTrue((boolean)this.artifactRepository.contains(key));
        FileFilter fileFilter = file -> file.getName().endsWith(fileName);
        File[] contentBytes = JRELocation.listFiles(fileFilter);
        ZipInputStream zipInputStream = this.artifactRepository.getZipInputStream(key);
        HashMap<String, Object[]> fileMap = new HashMap<String, Object[]>();
        fileMap.put(fileName, new Object[]{contentBytes[0], Files.readAllBytes(contentBytes[0].toPath())});
        TestData.assertContains(fileMap, zipInputStream, true);
    }

    private IInstallableUnit getPublishedUnit(String id) {
        Collection units = this.publisherResult.getIUs(id, "root");
        JREActionTest.assertEquals((int)1, (int)units.size());
        return (IInstallableUnit)units.iterator().next();
    }

    private Collection<IProvidedCapability> getPublishedCapabilitiesOf(String id) {
        Collection ius = this.publisherResult.getIUs(id, "root");
        JREActionTest.assertEquals((int)1, (int)ius.size());
        IInstallableUnit iu = (IInstallableUnit)ius.iterator().next();
        return iu.getProvidedCapabilities();
    }

    private static IProvidedCapability createEECapability(String ee, String version) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("osgi.ee", ee);
        attrs.put("version", (String)Version.parseVersion((String)version));
        return MetadataFactory.createProvidedCapability((String)"osgi.ee", attrs);
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        Mockito.when((Object)this.publisherInfo.getArtifactRepository()).thenReturn((Object)this.artifactRepository);
        Mockito.when((Object)this.publisherInfo.getArtifactOptions()).thenReturn((Object)2);
    }
}

