/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.LocalUpdateSiteAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LocalUpdateSiteActionTest
extends ActionTest {
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(LocalUpdateSiteActionTest.getAgent());

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setupPublisherResult();
        this.setupPublisherInfo();
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        super.insertPublisherInfoBehavior();
        Mockito.when((Object)this.publisherInfo.getArtifactRepository()).thenReturn((Object)this.artifactRepository);
        Mockito.when((Object)this.publisherInfo.getArtifactOptions()).thenReturn((Object)7);
        Mockito.when((Object)this.publisherInfo.getAdvice(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString(), (Version)ArgumentMatchers.any(Version.class), (Class)ArgumentMatchers.any(Class.class))).thenReturn(Collections.emptyList());
    }

    public void testUnzipTouchpointAction() throws Exception {
        File file = TestData.getFile("updatesite/site", "");
        LocalUpdateSiteAction action = new LocalUpdateSiteAction(file.getAbsolutePath(), "qualifier");
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        Collection ius = this.publisherResult.getIUs("test.feature.feature.jar", null);
        LocalUpdateSiteActionTest.assertEquals((String)"1.0", (int)1, (int)ius.size());
        IInstallableUnit iu = (IInstallableUnit)ius.iterator().next();
        Collection touchpointData = iu.getTouchpointData();
        LocalUpdateSiteActionTest.assertEquals((String)"1.1", (int)1, (int)touchpointData.size());
        Map instructions = ((ITouchpointData)touchpointData.iterator().next()).getInstructions();
        Set keys = instructions.keySet();
        LocalUpdateSiteActionTest.assertEquals((String)"1.2", (int)1, (int)keys.size());
        String unzip = (String)keys.iterator().next();
        LocalUpdateSiteActionTest.assertEquals((String)"1.3", (String)"zipped", (String)unzip);
    }
}

