/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;

public class LocalizationTests
extends AbstractProvisioningTest {
    private PublisherInfo info;
    private IProgressMonitor monitor;
    private PublisherResult results;

    private TranslationSupport getTranslationSupport() {
        TranslationSupport utils = new TranslationSupport();
        utils.setTranslationSource((IQueryable)this.results.query(QueryUtil.createIUQuery(null), this.monitor));
        return utils;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.info = new PublisherInfo();
        this.info.setMetadataRepository((IMetadataRepository)new TestMetadataRepository(LocalizationTests.getAgent(), new IInstallableUnit[0]));
        this.results = new PublisherResult();
        this.monitor = new NullProgressMonitor();
    }

    public void testBundleLocalizationDE() throws IOException {
        File file = TestData.getFile("localizationtests/foobundle", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo German Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo German Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testBundleLocalizationDefaultDE() throws IOException {
        File file = TestData.getFile("localizationtests/foobundle_default", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo German Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo German Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testBundleLocalizationDefaultDEJar() throws IOException {
        File file = TestData.getFile("localizationtests/foobundle_1.0.0.qualifier.jar", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo German Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo German Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testBundleLocalizationOSGI_INF_DE() throws IOException {
        File file = TestData.getFile("localizationtests/foobundle_osgi-inf", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo German Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo German Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testBundleLocalizationDE_alternatePropFile() throws IOException {
        File file = TestData.getFile("localizationtests/barbundle", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"barbundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Bar German Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Bar German Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testBundleLocalizationDE_alternatePropFile_fragment() throws IOException {
        File bundle = TestData.getFile("localizationtests/barbundle2", "");
        File fragment = TestData.getFile("localizationtests/barfragment2", "");
        BundlesAction action = new BundlesAction(new File[]{bundle, fragment});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"barbundle2"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Bar German Bundle - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Bar German Provider - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testBundleLocalizationDE_fragment() throws IOException {
        File bundle = TestData.getFile("localizationtests/foobundle2", "");
        File fragment = TestData.getFile("localizationtests/foofragment2", "");
        BundlesAction action = new BundlesAction(new File[]{bundle, fragment});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle2"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo German Bundle - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo German Provider - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testBundleLocalizationOSGI_INF_EN() throws IOException {
        File file = TestData.getFile("localizationtests/foobundle_osgi-inf", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
    }

    public void testBundleLocalizationEN() throws IOException {
        File file = TestData.getFile("localizationtests/foobundle", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
    }

    public void testBundleLocalizationENDefault() throws IOException {
        File file = TestData.getFile("localizationtests/foobundle_default", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
    }

    public void testBundleLocalizationEN_alternatePropFile() throws IOException {
        File file = TestData.getFile("localizationtests/barbundle", "");
        BundlesAction action = new BundlesAction(new File[]{file});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"barbundle"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Bar English Bundle", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Bar English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
    }

    public void testBundleLocalizationEN_alternatePropFile_fragment() throws IOException {
        File bundle = TestData.getFile("localizationtests/barbundle2", "");
        File fragment = TestData.getFile("localizationtests/barfragment2", "");
        BundlesAction action = new BundlesAction(new File[]{bundle, fragment});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"barbundle2"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Bar English Bundle - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Bar English Provider - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
    }

    public void testBundleLocalizationEN_fragment() throws IOException {
        File bundle = TestData.getFile("localizationtests/foobundle2", "");
        File fragment = TestData.getFile("localizationtests/foofragment2", "");
        BundlesAction action = new BundlesAction(new File[]{bundle, fragment});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foobundle2"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Bundle - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider - Translated in the Fragment", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
    }

    public void testFeatureJarLocalizatioDE() throws IOException {
        File file = TestData.getFile("localizationtests/foofeature", "");
        FeaturesAction featuresAction = new FeaturesAction(new File[]{file});
        featuresAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"fooFeature.feature.jar"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo German Feature", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo German Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.3", (String)"Foo German Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.4", (String)"Foo German Copyright", (String)utils.getCopyright(iu, Locale.GERMAN.toString()).getBody());
        LocalizationTests.assertEquals((String)"1.5", (String)"Foo German License", (String)utils.getLicenses(iu, Locale.GERMAN.toString())[0].getBody());
    }

    public void testFeatureJarLocalizationDefault() throws IOException {
        File file = TestData.getFile("localizationtests/foofeature", "");
        FeaturesAction featuresAction = new FeaturesAction(new File[]{file});
        featuresAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"fooFeature.feature.jar"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Feature", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name"));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider"));
        LocalizationTests.assertEquals((String)"1.3", (String)"Foo English Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description"));
        LocalizationTests.assertEquals((String)"1.4", (String)"Foo English Copyright", (String)utils.getCopyright(iu, null).getBody());
        LocalizationTests.assertEquals((String)"1.5", (String)"Foo English License", (String)utils.getLicenses(iu, null)[0].getBody());
    }

    public void testFeatureJarLocalizationEN() throws IOException {
        File file = TestData.getFile("localizationtests/foofeature", "");
        FeaturesAction featuresAction = new FeaturesAction(new File[]{file});
        featuresAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"fooFeature.feature.jar"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Feature", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.3", (String)"Foo English Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.4", (String)"Foo English Copyright", (String)utils.getCopyright(iu, Locale.ENGLISH.toString()).getBody());
        LocalizationTests.assertEquals((String)"1.5", (String)"Foo English License", (String)utils.getLicenses(iu, Locale.ENGLISH.toString())[0].getBody());
    }

    public void testFeatureLocalizatioDE() throws IOException {
        File file = TestData.getFile("localizationtests/foofeature", "");
        FeaturesAction featuresAction = new FeaturesAction(new File[]{file});
        featuresAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"fooFeature.feature.group"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo German Feature", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo German Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.3", (String)"Foo German Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.4", (String)"Foo German Copyright", (String)utils.getCopyright(iu, Locale.GERMAN.toString()).getBody());
        LocalizationTests.assertEquals((String)"1.5", (String)"Foo German License", (String)utils.getLicenses(iu, Locale.GERMAN.toString())[0].getBody());
    }

    public void testFeatureLocalizationDefault() throws IOException {
        File file = TestData.getFile("localizationtests/foofeature", "");
        FeaturesAction featuresAction = new FeaturesAction(new File[]{file});
        featuresAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"fooFeature.feature.group"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Feature", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name"));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider"));
        LocalizationTests.assertEquals((String)"1.3", (String)"Foo English Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description"));
        LocalizationTests.assertEquals((String)"1.4", (String)"Foo English Copyright", (String)utils.getCopyright(iu, null).getBody());
        LocalizationTests.assertEquals((String)"1.5", (String)"Foo English License", (String)utils.getLicenses(iu, null)[0].getBody());
    }

    public void testFeatureLocalizationEN() throws IOException {
        File file = TestData.getFile("localizationtests/foofeature", "");
        FeaturesAction featuresAction = new FeaturesAction(new File[]{file});
        featuresAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"fooFeature.feature.group"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"Foo English Feature", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"Foo English Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.3", (String)"Foo English Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.4", (String)"Foo English Copyright", (String)utils.getCopyright(iu, Locale.ENGLISH.toString()).getBody());
        LocalizationTests.assertEquals((String)"1.5", (String)"Foo English License", (String)utils.getLicenses(iu, Locale.ENGLISH.toString())[0].getBody());
    }

    public void testFragmentTranslation_DE() throws IOException {
        File bundle = TestData.getFile("localizationtests/barbundle2", "");
        File fragment = TestData.getFile("localizationtests/barfragment2", "");
        BundlesAction action = new BundlesAction(new File[]{bundle, fragment});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"barfragment2"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"German Fragment Name", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"German Fragment Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.GERMAN.toString()));
    }

    public void testFragmentTranslation_EN() throws IOException {
        File bundle = TestData.getFile("localizationtests/barbundle2", "");
        File fragment = TestData.getFile("localizationtests/barfragment2", "");
        BundlesAction action = new BundlesAction(new File[]{bundle, fragment});
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"barfragment2"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"English Fragment Name", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"English Fragment Provider", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.provider", Locale.ENGLISH.toString()));
    }

    public void testSite_DE() throws IOException {
        File feature = TestData.getFile("localizationtests/foofeature", "");
        URI site = TestData.getFile("localizationtests/site", "").toURI();
        FeaturesAction action = new FeaturesAction(new File[]{feature});
        SiteXMLAction siteAction = new SiteXMLAction(site, "foo");
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        siteAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foo.new_category_1"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"German Category Name", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"German Category Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description", Locale.GERMAN.toString()));
    }

    public void testSite_EN() throws IOException {
        File feature = TestData.getFile("localizationtests/foofeature", "");
        URI site = TestData.getFile("localizationtests/site", "").toURI();
        FeaturesAction action = new FeaturesAction(new File[]{feature});
        SiteXMLAction siteAction = new SiteXMLAction(site, "foo");
        action.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        siteAction.perform((IPublisherInfo)this.info, (IPublisherResult)this.results, this.monitor);
        TranslationSupport utils = this.getTranslationSupport();
        IQueryResult queryResult = this.results.query(QueryUtil.createIUQuery((String)"foo.new_category_1"), this.monitor);
        IInstallableUnit iu = (IInstallableUnit)queryResult.iterator().next();
        LocalizationTests.assertEquals((String)"1.0", (String)"English Category Name", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.ENGLISH.toString()));
        LocalizationTests.assertEquals((String)"1.1", (String)"English Category Description", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.description", Locale.ENGLISH.toString()));
    }
}

