/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProductActionCapturingTest
extends ActionTest {
    File executablesFeatureLocation = null;
    String source = "";
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(ProductActionCapturingTest.getAgent());

    @Override
    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    public void testSetBundleConfigData() throws Exception {
        ArgumentCaptor productFileAdviceCapture = ArgumentCaptor.forClass(IPublisherAdvice.class);
        this.addContextIU("org.eclipse.rcp.feature.group", "3.5.0.v20081110-9C9tEvNEla71LZ2jFz-RFB-t");
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "startLevel.product").toString());
        this.testAction = (AbstractPublisherAction)Mockito.spy((Object)new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation));
        IStatus status = this.testAction.perform(this.publisherInfo, this.publisherResult, null);
        ((IPublisherInfo)Mockito.verify((Object)this.publisherInfo, (VerificationMode)Mockito.atLeastOnce())).addAdvice((IPublisherAdvice)productFileAdviceCapture.capture());
        MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        IConfigAdvice configAdvice = (IConfigAdvice)productFileAdviceCapture.getAllValues().stream().filter(IConfigAdvice.class::isInstance).collect(Collectors.toList()).get(0);
        BundleInfo[] bundles = configAdvice.getBundles();
        ProductActionCapturingTest.assertEquals((String)"1.0", (int)2, (int)bundles.length);
        ProductActionCapturingTest.assertEquals((String)"1.1", (String)"org.eclipse.equinox.common", (String)bundles[0].getSymbolicName());
        ProductActionCapturingTest.assertEquals((String)"1.2", (String)"1.0.0", (String)bundles[0].getVersion());
        ProductActionCapturingTest.assertEquals((String)"1.3", (int)13, (int)bundles[0].getStartLevel());
        ProductActionCapturingTest.assertEquals((String)"1.4", (boolean)false, (boolean)bundles[0].isMarkedAsStarted());
        ProductActionCapturingTest.assertEquals((String)"2.1", (String)"org.eclipse.core.runtime", (String)bundles[1].getSymbolicName());
        ProductActionCapturingTest.assertEquals((String)"2.2", (String)"2.0.0", (String)bundles[1].getVersion());
        ProductActionCapturingTest.assertEquals((String)"2.3", (int)6, (int)bundles[1].getStartLevel());
        ProductActionCapturingTest.assertEquals((String)"2.4", (boolean)true, (boolean)bundles[1].isMarkedAsStarted());
    }

    public void testPlatformProduct() throws Exception {
        ArgumentCaptor productFileAdviceCapture = ArgumentCaptor.forClass(IPublisherAdvice.class);
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "platform.product").toString());
        this.addContextIU("org.eclipse.platform.feature.group", "1.2.3");
        this.testAction = (AbstractPublisherAction)Mockito.spy((Object)new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation));
        IStatus status = this.testAction.perform(this.publisherInfo, this.publisherResult, null);
        ((IPublisherInfo)Mockito.verify((Object)this.publisherInfo, (VerificationMode)Mockito.atLeastOnce())).addAdvice((IPublisherAdvice)productFileAdviceCapture.capture());
        MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        IExecutableAdvice launchAdvice = (IExecutableAdvice)productFileAdviceCapture.getAllValues().stream().filter(ProductFileAdvice.class::isInstance).collect(Collectors.toList()).get(0);
        ProductActionCapturingTest.assertEquals((String)"1.0", (String)"eclipse", (String)launchAdvice.getExecutableName());
        String[] programArgs = launchAdvice.getProgramArguments();
        ProductActionCapturingTest.assertEquals((String)"2.0", (int)0, (int)programArgs.length);
        String[] vmArgs = launchAdvice.getVMArguments();
        ProductActionCapturingTest.assertEquals((String)"3.0", (int)0, (int)vmArgs.length);
    }
}

