/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class ProductContentTypeTest
extends ActionTest {
    private static final String TEST_DATA_FOLDER = "ProductContentTypeTest";
    private static final String flavor = "tooling";
    private List<IInstallableUnit> requiredUnits;
    private List<IInstallableUnit> additionalPublishedUnits;
    private final IInstallableUnit featureIU = ProductContentTypeTest.createIU("TestFeature.feature.group");
    private final IInstallableUnit bundleIU = ProductContentTypeTest.createIU("TestBundle");

    @Override
    public void setUp() throws Exception {
        this.setupPublisherResult();
        this.initCUsList();
    }

    public void test01PublishWithBundle() throws Exception {
        this.testTemplate("ProductWithBundle.product", "1", this.requiredUnits.size() + 3, this.bundleIU);
    }

    public void test02PublishWithFeature() throws Exception {
        this.testTemplate("ProductWithFeature.product", "1", this.requiredUnits.size() + 3, this.featureIU);
    }

    public void test03PublishWithMixedContent() throws Exception {
        this.testTemplate("MixedContentProduct.product", "1", this.requiredUnits.size() + 4, this.bundleIU, this.featureIU);
    }

    public void test04PublishWithInvalidContentType() throws Exception {
        File productFileLocation = TestData.getFile(TEST_DATA_FOLDER, "InvalidContentType.product");
        try {
            new ProductFile(productFileLocation.toString());
            ProductContentTypeTest.fail((String)"Parsing of product file with invalid content type was successful");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test05PublishWithEmptyContentType() throws Exception {
        File productFileLocation = TestData.getFile(TEST_DATA_FOLDER, "EmptyContentType.product");
        try {
            new ProductFile(productFileLocation.toString());
            ProductContentTypeTest.fail((String)"Parsing of product file with empty content type was successful");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test06OverrideUseFeaturesAttr() throws Exception {
        this.testTemplate("OverrideUseFeaturesAttr.product", "1", this.requiredUnits.size() + 3, this.bundleIU);
    }

    public void test07OverrideUseFeaturesAttr2() throws Exception {
        this.testTemplate("OverrideUseFeaturesAttr2.product", "1", this.requiredUnits.size() + 4, this.bundleIU, this.featureIU);
    }

    private void initCUsList() {
        this.requiredUnits = new ArrayList<IInstallableUnit>(3);
        this.requiredUnits.add(ProductContentTypeTest.createIU("tooling.source.default"));
        this.requiredUnits.add(ProductContentTypeTest.createIU("tooling.osgi.bundle.default"));
        this.requiredUnits.add(ProductContentTypeTest.createIU("tooling.org.eclipse.update.feature.default"));
        this.additionalPublishedUnits = new ArrayList<IInstallableUnit>(2);
        this.additionalPublishedUnits.add(ProductContentTypeTest.createIU("a.jre.javase", Version.create((String)"9.0")));
        this.additionalPublishedUnits.add(ProductContentTypeTest.createIU("config.a.jre.javase", Version.create((String)"9.0")));
    }

    private void testTemplate(String productFileName, String productVersion, int expectedRequirementsSize, IInstallableUnit ... requiredInstallableUnits) throws Exception {
        IInstallableUnit[] iInstallableUnitArray = requiredInstallableUnits;
        int n = requiredInstallableUnits.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit requiredUnit = iInstallableUnitArray[n2];
            this.publisherResult.addIU(requiredUnit, "non_root");
            ++n2;
        }
        File productFileLocation = TestData.getFile(TEST_DATA_FOLDER, productFileName);
        IInstallableUnit productIU = this.publishProduct(productFileLocation, productFileName);
        Collection requirements = productIU.getRequirements();
        ProductContentTypeTest.assertEquals((String)"Requirements count doed not match", (int)expectedRequirementsSize, (int)requirements.size());
        this.verifyRequirementsForConfigurationUnits(requirements, productFileName, productVersion);
        IInstallableUnit[] iInstallableUnitArray2 = requiredInstallableUnits;
        int n3 = requiredInstallableUnits.length;
        int n4 = 0;
        while (n4 < n3) {
            IInstallableUnit iu = iInstallableUnitArray2[n4];
            ProductContentTypeTest.assertTrue((String)("Installable unit " + iu.getId() + " is not included in the requirements"), (boolean)this.verifyRequirement((Collection<IRequirement>)requirements, iu));
            ++n4;
        }
    }

    private IInstallableUnit publishProduct(File productFileLocation, String productIUName) throws Exception {
        ProductFile productFile = new ProductFile(productFileLocation.toString());
        this.testAction = new ProductAction(null, (IProductDescriptor)productFile, flavor, null);
        IStatus status = this.testAction.perform((IPublisherInfo)new PublisherInfo(), this.publisherResult, null);
        MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not(StatusMatchers.errorStatus())));
        Collection ius = this.publisherResult.getIUs(productIUName, "non_root");
        ProductContentTypeTest.assertEquals((int)1, (int)ius.size());
        return (IInstallableUnit)ius.iterator().next();
    }

    private void verifyRequirementsForConfigurationUnits(Collection<IRequirement> requirements, String productName, String productVersion) {
        ArrayList<IInstallableUnit> cusListCopy = new ArrayList<IInstallableUnit>(this.requiredUnits);
        cusListCopy.add(ProductContentTypeTest.createIU(flavor + productName + ".configuration", Version.create((String)productVersion)));
        Iterator cusIterator = cusListCopy.iterator();
        while (cusIterator.hasNext()) {
            IInstallableUnit cu = (IInstallableUnit)cusIterator.next();
            if (!this.verifyRequirement(requirements, cu)) continue;
            cusIterator.remove();
        }
        ProductContentTypeTest.assertTrue((String)("Some of the default configuration units are not included in the product - " + String.valueOf(cusListCopy)), (boolean)cusListCopy.isEmpty());
    }

    private boolean verifyRequirement(Collection<IRequirement> requirements, IInstallableUnit iu) {
        for (IRequirement requirement : requirements) {
            if (!requirement.isMatch(iu)) continue;
            return true;
        }
        return false;
    }
}

