/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.util.List;
import java.util.Map;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.eclipse.IMacOsBundleUrlType;
import org.eclipse.equinox.p2.tests.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProductFileTest {
    String productFileLocation = null;
    ProductFile productFile = null;
    ProductFile noLauncherFlag = null;
    ProductFile falseLauncherFlag = null;
    ProductFile trueLauncherFlag = null;
    ProductFile rootFeaturesProduct;
    String configFile = "/org.eclipse.equinox.p2.tests/testData/ProductActionTest/productWithConfig/config.ini";
    private String uidProductFileLocation;
    private ProductFile uidProductFile;

    @Before
    public void setUp() throws Exception {
        this.productFileLocation = TestData.getFile("ProductActionTest/productWithConfig", "sample.product").toString();
        this.noLauncherFlag = new ProductFile(TestData.getFile("ProductActionTest/launcherFlags", "noLauncherFlag.product").toString());
        this.falseLauncherFlag = new ProductFile(TestData.getFile("ProductActionTest/launcherFlags", "falseLauncherFlag.product").toString());
        this.trueLauncherFlag = new ProductFile(TestData.getFile("ProductActionTest/launcherFlags", "trueLauncherFlag.product").toString());
        this.productFile = new ProductFile(this.productFileLocation);
        this.uidProductFileLocation = TestData.getFile("ProductActionTest/productWithConfig", "uidproduct.product").toString();
        this.uidProductFile = new ProductFile(this.uidProductFileLocation);
        this.rootFeaturesProduct = new ProductFile(TestData.getFile("ProductActionTest", "rootFeatures.product").toString());
    }

    @Test
    public void testGetLauncherName() {
        Assert.assertEquals((Object)"sample", (Object)this.productFile.getLauncherName());
    }

    @Test
    public void testGetLocation() {
        Assert.assertEquals((Object)this.productFileLocation, (Object)this.productFile.getLocation().toString());
    }

    @Test
    public void testGetConfigurationProperties() {
        Map properties = this.productFile.getConfigurationProperties();
        Assert.assertEquals((long)4L, (long)properties.size());
        Assert.assertEquals((Object)"bar", properties.get("foo"));
        Assert.assertTrue((boolean)((String)properties.get("foo1")).isEmpty());
        Assert.assertEquals((Object)"test.product", properties.get("eclipse.product"));
        Assert.assertEquals((Object)"test.app", properties.get("eclipse.application"));
    }

    @Test
    public void testGetBundles() {
        List bundles = this.productFile.getBundles();
        Assert.assertEquals((long)2L, (long)bundles.size());
        Assert.assertEquals((Object)"org.eclipse.core.runtime", (Object)((IVersionedId)bundles.get(0)).getId());
        Assert.assertEquals((Object)Version.createOSGi((int)1, (int)0, (int)4), (Object)((IVersionedId)bundles.get(0)).getVersion());
        Assert.assertEquals((Object)"org.eclipse.swt.win32.win32.x86", (Object)((IVersionedId)bundles.get(1)).getId());
        Assert.assertEquals((Object)Version.emptyVersion, (Object)((IVersionedId)bundles.get(1)).getVersion());
    }

    @Test
    public void testGetBundleInfos() {
        List bundleInfos = this.productFile.getBundleInfos();
        BundleInfo info = (BundleInfo)bundleInfos.iterator().next();
        Assert.assertEquals((long)1L, (long)bundleInfos.size());
        Assert.assertEquals((Object)"org.eclipse.core.runtime", (Object)info.getSymbolicName());
        Assert.assertEquals((long)2L, (long)info.getStartLevel());
        Assert.assertTrue((boolean)info.isMarkedAsStarted());
    }

    @Test
    public void testGetFeatures() {
        List features = this.productFile.getFeatures();
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)"org.eclipse.rcp", (Object)((IVersionedId)features.get(0)).getId());
        Assert.assertEquals((Object)Version.create((String)"3.5.0.v20081110-9C9tEvNEla71LZ2jFz-RFB-t"), (Object)((IVersionedId)features.get(0)).getVersion());
    }

    @Test
    public void testGetRootFeatures() {
        List features = this.rootFeaturesProduct.getFeatures(2);
        MatcherAssert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.help", "2.0.102.v20140128")));
        MatcherAssert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.egit", "0.0.0")));
        Assert.assertEquals((long)2L, (long)features.size());
    }

    @Test
    public void testGetIncludedFeatures() {
        List features = this.rootFeaturesProduct.getFeatures(1);
        MatcherAssert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.rcp", "4.4.0.v20140128")));
        MatcherAssert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.e4.rcp", "0.0.0")));
        Assert.assertEquals((long)2L, (long)features.size());
    }

    @Test
    public void testGetFeaturesOnlyReturnsIncludedFeatures() {
        MatcherAssert.assertThat((Object)this.rootFeaturesProduct.getFeatures(), (Matcher)CoreMatchers.is((Object)this.rootFeaturesProduct.getFeatures(1)));
    }

    @Test
    public void testHasFeatures() throws Exception {
        ProductFile featuresOnly = new ProductFile(TestData.getFile("ProductActionTest", "onlyFeatures.product").toString());
        Assert.assertTrue((boolean)featuresOnly.hasFeatures());
        Assert.assertFalse((boolean)featuresOnly.hasBundles());
    }

    @Test
    public void testHasBundles() throws Exception {
        ProductFile bundlesOnly = new ProductFile(TestData.getFile("ProductActionTest", "onlyBundles.product").toString());
        Assert.assertFalse((boolean)bundlesOnly.hasFeatures());
        Assert.assertTrue((boolean)bundlesOnly.hasBundles());
    }

    @Test
    public void testHasFragments() throws Exception {
        ProductFile bundlesOnly = new ProductFile(TestData.getFile("ProductActionTest", "onlyFragments.product").toString());
        Assert.assertFalse((boolean)bundlesOnly.hasFeatures());
        Assert.assertTrue((boolean)bundlesOnly.hasBundles());
    }

    @Test
    public void testGetConfigIniPath() {
        String configIni = this.productFile.getConfigIniPath("win32");
        Assert.assertEquals((Object)"config.ini", (Object)configIni);
    }

    @Test
    public void testGetId() {
        String id = this.productFile.getId();
        Assert.assertEquals((Object)"test.product", (Object)id);
    }

    @Test
    public void testGetUID() {
        String id = this.uidProductFile.getId();
        Assert.assertEquals((Object)"UID.test.product", (Object)id);
    }

    @Test
    public void testGetSplashLocation() {
        String splashLocation = this.productFile.getSplashLocation();
        Assert.assertEquals((Object)"org.eclipse.equinox.p2.tests", (Object)splashLocation);
    }

    @Test
    public void testGetProductName() {
        String productName = this.productFile.getProductName();
        Assert.assertEquals((Object)"aaTestProduct", (Object)productName);
    }

    @Test
    public void testGetApplication() {
        String application = this.productFile.getApplication();
        Assert.assertEquals((Object)"test.app", (Object)application);
    }

    @Test
    public void testUseFeatures() {
        boolean useFeatures = this.productFile.useFeatures();
        Assert.assertFalse((String)"1.0", (boolean)useFeatures);
    }

    @Test
    public void testGetVersion() {
        String version = this.productFile.getVersion();
        Assert.assertEquals((String)"1.0", (Object)Version.create((String)"1"), (Object)Version.create((String)version));
    }

    @Test
    public void testGetVMArguments() {
        String vmArguments = this.productFile.getVMArguments("");
        Assert.assertEquals((Object)"vmArg -Dfoo=\"b a r\"", (Object)vmArguments);
        vmArguments = this.productFile.getVMArguments(null);
        Assert.assertEquals((Object)"vmArg -Dfoo=\"b a r\"", (Object)vmArguments);
    }

    @Test
    public void testIncludeLaunchers() {
        Assert.assertTrue((boolean)this.noLauncherFlag.includeLaunchers());
        Assert.assertFalse((boolean)this.falseLauncherFlag.includeLaunchers());
        Assert.assertTrue((boolean)this.trueLauncherFlag.includeLaunchers());
    }

    @Test
    public void testGetProgramArguments() {
        String programArguments = this.productFile.getProgramArguments("");
        Assert.assertEquals((Object)"programArg -name \"My Name\"", (Object)programArguments);
        programArguments = this.productFile.getProgramArguments(null);
        Assert.assertEquals((Object)"programArg -name \"My Name\"", (Object)programArguments);
    }

    @Test
    public void testGetLicenseURL() throws Exception {
        String productWithLicense = TestData.getFile("ProductActionTest", "productWithLicense.product").toString();
        ProductFile product = new ProductFile(productWithLicense);
        Assert.assertEquals((Object)"http://www.example.com", (Object)product.getLicenseURL());
    }

    @Test
    public void testGetLicenseText() throws Exception {
        String productWithLicense = TestData.getFile("ProductActionTest", "productWithLicense.product").toString();
        ProductFile product = new ProductFile(productWithLicense);
        Assert.assertEquals((Object)"This is the liCenSE.", (Object)product.getLicenseText().trim());
    }

    @Test
    public void testGetVM() throws Exception {
        String productWithVM = TestData.getFile("ProductActionTest", "productWithVM.product").toString();
        ProductFile product = new ProductFile(productWithVM);
        Assert.assertEquals((Object)"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/OSGi%Minimum-1.2", (Object)product.getVM("win32"));
        Assert.assertEquals((Object)"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-9", (Object)product.getVM("linux"));
        Assert.assertNull((Object)product.getVM("macosx"));
    }

    @Test
    public void testGetMacOsBundleUrlTypes() throws Exception {
        String productWithMacOsBundleUrlTypes = TestData.getFile("ProductActionTest", "productWithMacOsBundleUrlTypes.product").toString();
        ProductFile product = new ProductFile(productWithMacOsBundleUrlTypes);
        List macOsBundleUrlTypes = product.getMacOsBundleUrlTypes();
        Assert.assertEquals((long)2L, (long)macOsBundleUrlTypes.size());
        Assert.assertEquals((Object)"eclipse+command", (Object)((IMacOsBundleUrlType)macOsBundleUrlTypes.get(0)).getScheme());
        Assert.assertEquals((Object)"Eclipse Command", (Object)((IMacOsBundleUrlType)macOsBundleUrlTypes.get(0)).getName());
        Assert.assertEquals((Object)"vendor", (Object)((IMacOsBundleUrlType)macOsBundleUrlTypes.get(1)).getScheme());
        Assert.assertEquals((Object)"Vendor Application", (Object)((IMacOsBundleUrlType)macOsBundleUrlTypes.get(1)).getName());
    }
}

