/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ql;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.expression.MatchIteratorFilter;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionParser;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PerformanceTest
extends AbstractProvisioningTest {
    public void testParserPerformance() throws Exception {
        IExpressionParser parser = ExpressionUtil.getParser();
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 50000) {
            parser.parse("providedCapabilities.exists(x | x.name == foo)");
            ++i;
        }
        System.out.println("Parse of 50000 expressions took: " + (System.currentTimeMillis() - start) + " milliseconds");
    }

    public void testMatchQueryVersusExpressionPerformance() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery expressionQuery = QueryUtil.createMatchQuery((String)"id ~= /com.ibm.*/", (Object[])new Object[0]);
        MatchQuery<IInstallableUnit> matchQuery = new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return candidate.getId().startsWith("com.ibm.");
            }
        };
        long matchQueryMS = 0L;
        long exprQueryMS = 0L;
        int i = 0;
        while (i < 5) {
            IQueryResult result;
            long start = System.currentTimeMillis();
            int idx = 0;
            while (idx < 200) {
                result = repo.query(expressionQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)2);
                ++idx;
            }
            exprQueryMS += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            idx = 0;
            while (idx < 200) {
                result = repo.query((IQuery)matchQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)2);
                ++idx;
            }
            matchQueryMS += System.currentTimeMillis() - start;
            ++i;
        }
        System.out.println("ExpressionQuery took: " + exprQueryMS + " milliseconds");
        System.out.println("MatchQuery took: " + matchQueryMS + " milliseconds");
        System.out.println();
    }

    public void testMatchQueryVersusIndexedExpressionPerformance() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery expressionQuery = QueryUtil.createMatchQuery((String)"id == 'org.eclipse.core.resources'", (Object[])new Object[0]);
        MatchQuery<IInstallableUnit> matchQuery = new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return candidate.getId().equals("org.eclipse.core.resources");
            }
        };
        long matchQueryMS = 0L;
        long exprQueryMS = 0L;
        int i = 0;
        while (i < 5) {
            IQueryResult result;
            long start = System.currentTimeMillis();
            int idx = 0;
            while (idx < 200) {
                result = repo.query(expressionQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)1);
                ++idx;
            }
            exprQueryMS += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            idx = 0;
            while (idx < 200) {
                result = repo.query((IQuery)matchQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)1);
                ++idx;
            }
            matchQueryMS += System.currentTimeMillis() - start;
            ++i;
        }
        System.out.println("IndexedExpressionQuery took: " + exprQueryMS + " milliseconds");
        System.out.println("MatchQuery took: " + matchQueryMS + " milliseconds");
        System.out.println();
    }

    public void testMatchQueryVersusIndexedExpressionPerformance2() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery expressionQuery = QueryUtil.createMatchQuery((String)"providedCapabilities.exists(x | x.namespace == 'org.eclipse.equinox.p2.iu' && x.name == 'org.eclipse.core.resources')", (Object[])new Object[0]);
        MatchQuery<IInstallableUnit> matchQuery = new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                for (IProvidedCapability capability : candidate.getProvidedCapabilities()) {
                    if (!"org.eclipse.equinox.p2.iu".equals(capability.getNamespace()) || !"org.eclipse.core.resources".equals(capability.getName())) continue;
                    return true;
                }
                return false;
            }
        };
        long matchQueryMS = 0L;
        long exprQueryMS = 0L;
        int i = 0;
        while (i < 5) {
            IQueryResult result;
            long start = System.currentTimeMillis();
            int idx = 0;
            while (idx < 200) {
                result = repo.query(expressionQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)1);
                ++idx;
            }
            exprQueryMS += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            idx = 0;
            while (idx < 200) {
                result = repo.query((IQuery)matchQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)1);
                ++idx;
            }
            matchQueryMS += System.currentTimeMillis() - start;
            ++i;
        }
        System.out.println("IndexedExpressionQuery took: " + exprQueryMS + " milliseconds");
        System.out.println("MatchQuery took: " + matchQueryMS + " milliseconds");
        System.out.println();
    }

    public void testMatchQueryVersusMatchIteratorPerformance() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        MatchQuery<IInstallableUnit> matchQuery = new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return candidate.getId().startsWith("org.eclipse.");
            }
        };
        long matchFilterMS = 0L;
        long iterationFilterMS = 0L;
        long matchQueryMS = 0L;
        int i = 0;
        while (i < 5) {
            long start = System.currentTimeMillis();
            int idx = 0;
            while (idx < 80) {
                IQueryResult everything = repo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
                MatchIteratorFilter<IInstallableUnit> matchIter = new MatchIteratorFilter<IInstallableUnit>(everything.iterator()){

                    protected boolean isMatch(IInstallableUnit candidate) {
                        return candidate.getId().startsWith("org.eclipse.");
                    }
                };
                int sz = 0;
                while (matchIter.hasNext()) {
                    matchIter.next();
                    ++sz;
                }
                PerformanceTest.assertEquals((int)sz, (int)3240);
                ++idx;
            }
            matchFilterMS += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            idx = 0;
            while (idx < 80) {
                int sz = 0;
                for (IInstallableUnit candidate : repo.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())) {
                    if (!candidate.getId().startsWith("org.eclipse.")) continue;
                    ++sz;
                }
                PerformanceTest.assertEquals((int)sz, (int)3240);
                ++idx;
            }
            iterationFilterMS += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            idx = 0;
            while (idx < 80) {
                int sz = 0;
                Iterator iter = repo.query((IQuery)matchQuery, (IProgressMonitor)new NullProgressMonitor()).iterator();
                while (iter.hasNext()) {
                    iter.next();
                    ++sz;
                }
                PerformanceTest.assertEquals((int)sz, (int)3240);
                ++idx;
            }
            matchQueryMS += System.currentTimeMillis() - start;
            ++i;
        }
        System.out.println("MatchFilter took: " + matchFilterMS + " milliseconds");
        System.out.println("IteratorFilter took: " + iterationFilterMS + " milliseconds");
        System.out.println("MatchQuery took: " + matchQueryMS + " milliseconds");
        System.out.println();
    }

    public void testCapabilityQueryPerformance() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IRequirement capability = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"feature", (VersionRange)new VersionRange("[1.0.0,2.0.0)"), null, (boolean)false, (boolean)false);
        IQuery predicateQuery = QueryUtil.createMatchQuery((String)"this ~= $0", (Object[])new Object[]{capability});
        IQuery capabilityQuery = QueryUtil.createMatchQuery((IExpression)capability.getMatches(), (Object[])new Object[0]);
        long tradQueryMS = 0L;
        long exprQueryMS = 0L;
        int i = 0;
        while (i < 5) {
            IQueryResult result;
            long start = System.currentTimeMillis();
            int idx = 0;
            while (idx < 80) {
                result = repo.query(capabilityQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)487);
                ++idx;
            }
            tradQueryMS += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            idx = 0;
            while (idx < 80) {
                result = repo.query(predicateQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)487);
                ++idx;
            }
            exprQueryMS += System.currentTimeMillis() - start;
            ++i;
        }
        System.out.println("CapabilityQuery took: " + tradQueryMS + " milliseconds");
        System.out.println("PredicateQuery took: " + exprQueryMS + " milliseconds");
        System.out.println();
    }

    public void testCapabilityQueryPerformanceEE() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        Version jreVersion = Version.parseVersion((String)"1.8");
        HashMap<String, String> capAttrs = new HashMap<String, String>();
        capAttrs.put("osgi.ee", "JavaSE");
        capAttrs.put("version", (String)jreVersion);
        IProvidedCapability jreCap = MetadataFactory.createProvidedCapability((String)"osgi.ee", capAttrs);
        IInstallableUnit jre8IU = PerformanceTest.createIU("a.jre.javase", jreVersion, new IProvidedCapability[]{jreCap});
        repo.addInstallableUnits(Collections.singletonList(jre8IU));
        jreVersion = Version.parseVersion((String)"1.9");
        capAttrs = new HashMap();
        capAttrs.put("osgi.ee", "JavaSE");
        capAttrs.put("version", (String)jreVersion);
        jreCap = MetadataFactory.createProvidedCapability((String)"osgi.ee", capAttrs);
        IInstallableUnit jre9IU = PerformanceTest.createIU("b.jre.anotherjavase", jreVersion, new IProvidedCapability[]{jreCap});
        repo.addInstallableUnits(Collections.singletonList(jre9IU));
        IRequirement capability = MetadataFactory.createRequirement((String)"osgi.ee", (String)"(&(osgi.ee=JavaSE)(version=1.8))", null, (int)0, (int)0, (boolean)false);
        IQuery capabilityQuery = QueryUtil.createMatchQuery((IExpression)capability.getMatches(), (Object[])new Object[0]);
        long tradQueryMS = 0L;
        int i = 0;
        while (i < 5) {
            long start = System.currentTimeMillis();
            int idx = 0;
            while (idx < 80) {
                IQueryResult result = repo.query(capabilityQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)1, (int)PerformanceTest.queryResultSize(result));
                PerformanceTest.assertEquals((Object)jre8IU, result.toUnmodifiableSet().iterator().next());
                ++idx;
            }
            tradQueryMS += System.currentTimeMillis() - start;
            ++i;
        }
        System.out.println("CapabilityQuery took: " + tradQueryMS + " milliseconds");
        System.out.println();
    }

    public void testCapabilityQueryPerformanceOsgiService() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/2018-12");
        IRequirement capability = MetadataFactory.createRequirement((String)"osgi.service", (String)"(objectClass=org.osgi.service.event.EventAdmin)", null, (int)0, (int)0, (boolean)false);
        IQuery capabilityQuery = QueryUtil.createMatchQuery((IExpression)capability.getMatches(), (Object[])new Object[0]);
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 1000) {
            IQueryResult result = repo.query(capabilityQuery, (IProgressMonitor)new NullProgressMonitor());
            PerformanceTest.assertEquals((int)1, (int)PerformanceTest.queryResultSize(result));
            PerformanceTest.assertEquals((String)"org.eclipse.equinox.event", (String)((IInstallableUnit)result.iterator().next()).getId());
            ++i;
        }
        System.out.println("1000 * CapabilityQuery for osgi.service took: " + (System.currentTimeMillis() - start) + " milliseconds");
        System.out.println();
    }

    public void testIUPropertyQueryPerformance() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery propertyQuery = QueryUtil.createIUPropertyQuery((String)"df_LT.providerName", (String)"Eclipse.org");
        IQuery predicateQuery = QueryUtil.createMatchQuery((String)"properties[$0] == $1", (Object[])new Object[]{"df_LT.providerName", "Eclipse.org"});
        long tradQueryMS = 0L;
        long exprQueryMS = 0L;
        int i = 0;
        while (i < 5) {
            IQueryResult result;
            long start = System.currentTimeMillis();
            int idx = 0;
            while (idx < 80) {
                result = repo.query(propertyQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)965);
                ++idx;
            }
            tradQueryMS += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            idx = 0;
            while (idx < 80) {
                result = repo.query(predicateQuery, (IProgressMonitor)new NullProgressMonitor());
                PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(result), (int)965);
                ++idx;
            }
            exprQueryMS += System.currentTimeMillis() - start;
            ++i;
        }
        System.out.println("IUPropertyQuery took: " + tradQueryMS + " milliseconds");
        System.out.println("PredicateQuery took: " + exprQueryMS + " milliseconds");
        System.out.println();
    }

    public void testSlicerPerformance() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("osgi.os", "linux");
        env.put("osgi.ws", "gtk");
        env.put("osgi.arch", "x86");
        IInstallableUnit envIU = InstallableUnit.contextIU(env);
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQueryResult r = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.sdk.feature.group", (Version)Version.create((String)"3.5.0.v20090423-7Q7bA7DPR-wM38__Q4iRsmx9z0KOjbpx3AbyvXd-Uq7J2")), (IProgressMonitor)new NullProgressMonitor());
        Iterator itor = r.iterator();
        PerformanceTest.assertTrue((boolean)itor.hasNext());
        IInstallableUnit[] roots = new IInstallableUnit[]{(IInstallableUnit)itor.next()};
        IQuery query = QueryUtil.createQuery((String)"$0.traverse(set(), _, { cache, parent | parent.requirements.unique(cache).select(rc | rc.filter == null || $1 ~= rc.filter).collect(rc | everything.select(iu | iu ~= rc)).flatten()})", (Object[])new Object[]{roots, envIU});
        long sliceTime = 0L;
        long traverseTime = 0L;
        IQueryable slice = null;
        int idx = 0;
        while (idx < 100) {
            long startTime = System.currentTimeMillis();
            r = repo.query(query, (IProgressMonitor)new NullProgressMonitor());
            traverseTime += System.currentTimeMillis() - startTime;
            PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(r), (int)411);
            startTime = System.currentTimeMillis();
            Slicer slicer = new Slicer((IQueryable)new QueryableArray(this.gatherAvailableInstallableUnits((IQueryable<IInstallableUnit>)repo)), env, false);
            slice = slicer.slice((Collection)r.toUnmodifiableSet(), (IProgressMonitor)new NullProgressMonitor());
            sliceTime += System.currentTimeMillis() - startTime;
            ++idx;
        }
        r = slice.query((IQuery)new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit value) {
                return true;
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(r), (int)411);
        System.out.print("100 * Slicing took: ");
        System.out.println(sliceTime);
        System.out.print("100 * Indexed Traverse expression took: ");
        System.out.println(traverseTime);
        System.out.println();
    }

    public void testPermissiveSlicerPerformance() throws Exception {
        HashMap env = new HashMap();
        IInstallableUnit envIU = InstallableUnit.contextIU(env);
        CompositeMetadataRepository compositeMetadataRepository = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)PerformanceTest.getMetadataRepositoryManager().getAgent());
        compositeMetadataRepository.addChild(new URI("https://download.eclipse.org/releases/galileo"));
        CompositeMetadataRepository repo = compositeMetadataRepository;
        IQueryResult r = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.sdk.ide"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit[] roots = (IInstallableUnit[])r.toArray(IInstallableUnit.class);
        IQuery query = QueryUtil.createQuery((String)"$0.traverse(set(), _, { cache, parent | parent.requirements.unique(cache).collect(rc | everything.select(iu | iu ~= rc)).flatten()})", (Object[])new Object[]{roots, envIU});
        long sliceTime = 0L;
        long traverseTime = 0L;
        IQueryable slice = null;
        int idx = 0;
        while (idx < 10) {
            long startTime = System.currentTimeMillis();
            r = repo.query(query, (IProgressMonitor)new NullProgressMonitor());
            traverseTime += System.currentTimeMillis() - startTime;
            PerformanceTest.assertEquals((int)4704, (int)PerformanceTest.queryResultSize(r));
            startTime = System.currentTimeMillis();
            PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, env, true, true, true, false, false);
            slice = slicer.slice((Collection)r.toUnmodifiableSet(), (IProgressMonitor)new NullProgressMonitor());
            sliceTime += System.currentTimeMillis() - startTime;
            ++idx;
        }
        r = slice.query((IQuery)new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit value) {
                return true;
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        PerformanceTest.assertEquals((int)PerformanceTest.queryResultSize(r), (int)4704);
        System.out.print("10 * Slicing took: ");
        System.out.println(sliceTime);
        System.out.print("10 * Indexed Traverse expression took: ");
        System.out.println(traverseTime);
        System.out.println();
    }

    private IMetadataRepository getMDR(String uri) throws Exception {
        URI metadataRepo = PerformanceTest.getTestData("1.1", uri).toURI();
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)PerformanceTest.getAgent().getService(IMetadataRepositoryManager.class);
        PerformanceTest.assertNotNull((Object)metadataManager);
        return metadataManager.loadRepository(metadataRepo, (IProgressMonitor)new NullProgressMonitor());
    }

    private Set<IInstallableUnit> gatherAvailableInstallableUnits(IQueryable<IInstallableUnit> queryable) {
        return queryable.query(QueryUtil.createIUAnyQuery(), null).toUnmodifiableSet();
    }
}

