/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ql;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class TestIndexes
extends AbstractProvisioningTest {
    public void testIdIndexSimple() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery query = QueryUtil.createQuery((String)"select(x | x.id == $0)", (Object[])new Object[]{"org.eclipse.sdk.feature.group"});
        IQueryResult result = repo.query(query, this.getMonitor());
        TestIndexes.assertEquals((int)TestIndexes.queryResultSize(result), (int)1);
    }

    public void testIdIndexWithOR() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery query = QueryUtil.createQuery((String)"select(x | x.id == $0 || x.id == $1)", (Object[])new Object[]{"org.eclipse.sdk.feature.group", "org.eclipse.sdk.feature.jar"});
        IQueryResult result = repo.query(query, this.getMonitor());
        TestIndexes.assertEquals((int)TestIndexes.queryResultSize(result), (int)2);
    }

    public void testIdIndexWithNot() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery query = QueryUtil.createQuery((String)"select(x | x.id == $0 || x.id != $1)", (Object[])new Object[]{"org.eclipse.sdk.feature.group", "org.eclipse.sdk.feature.jar"});
        IQueryResult result = repo.query(query, this.getMonitor());
        TestIndexes.assertEquals((int)TestIndexes.queryResultSize(result), (int)3464);
    }

    public void testCapabilityIndexSimple() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery query = QueryUtil.createQuery((String)"select(x | x.providedCapabilities.exists(pc | pc.namespace == 'org.eclipse.equinox.p2.iu' && pc.name == $0))", (Object[])new Object[]{"org.eclipse.core.resources"});
        IQueryResult result = repo.query(query, this.getMonitor());
        TestIndexes.assertEquals((int)TestIndexes.queryResultSize(result), (int)1);
    }

    public void testCapabilityIndexMatches() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.core.resources", null, null, (int)1, (int)2, (boolean)true);
        IQuery query = QueryUtil.createQuery((String)"select(x | x ~= $0)", (Object[])new Object[]{requirement});
        IQueryResult result = repo.query(query, this.getMonitor());
        TestIndexes.assertEquals((int)TestIndexes.queryResultSize(result), (int)1);
    }

    public void testComplexIndexMatches() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQuery query = QueryUtil.createMatchQuery((String)"id ~= /*.feature.group/ && properties['org.eclipse.equinox.p2.type.group'] == true && providedCapabilities.exists(p | p.namespace == 'org.eclipse.equinox.p2.iu' && p.name == id)", (Object[])new Object[0]);
        IQueryResult result = repo.query(query, this.getMonitor());
        TestIndexes.assertEquals((int)TestIndexes.queryResultSize(result), (int)487);
    }

    private IMetadataRepository getMDR(String uri) throws Exception {
        URI metadataRepo = TestIndexes.getTestData("1.1", uri).toURI();
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)TestIndexes.getAgent().getService(IMetadataRepositoryManager.class);
        TestIndexes.assertNotNull((Object)metadataManager);
        return metadataManager.loadRepository(metadataRepo, (IProgressMonitor)new NullProgressMonitor());
    }
}

