/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ql;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionParser;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class TestQueryReimplementation
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit updateOfA;
    private IInstallableUnit a11;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = TestQueryReimplementation.createIU("A", Version.create((String)"2.0.0"));
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)"A", (VersionRange)new VersionRange("[2.0.0, 2.0.0]"), (int)0, (String)"update description");
        this.updateOfA = TestQueryReimplementation.createIU("UpdateA", Version.createOSGi((int)1, (int)0, (int)0), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, null, NO_TP_DATA, false, update, (IRequirement[])NO_REQUIRES);
        this.a11 = this.createIUUpdate();
    }

    public void testUpdateWithDifferentId() {
        IMetadataRepository repo = this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.updateOfA});
        IQueryResult c = repo.query((IQuery)new UpdateQuery(this.a1), null);
        TestQueryReimplementation.assertEquals((int)1, (int)TestQueryReimplementation.queryResultSize(c));
        TestQueryReimplementation.assertEquals((Object)this.updateOfA, c.iterator().next());
    }

    public void testWithSuperiorVersion() {
        IMetadataRepository repo2 = this.createTestMetdataRepository(new IInstallableUnit[]{this.a11, this.a1});
        IQueryResult c2 = repo2.query((IQuery)new UpdateQuery(this.a1), null);
        TestQueryReimplementation.assertEquals((int)1, (int)TestQueryReimplementation.queryResultSize(c2));
        TestQueryReimplementation.assertEquals((Object)this.a11, c2.iterator().next());
    }

    private IInstallableUnit createIUUpdate() {
        return TestQueryReimplementation.createIU("A", Version.create((String)"2.1.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, MetadataFactory.createUpdateDescriptor((String)"A", (VersionRange)new VersionRange("[2.0.0, 2.1.0]"), (int)0, (String)"update description"), null);
    }

    public static class IUPropertyQuery
    extends ExpressionMatchQuery<IInstallableUnit> {
        private static final IExpression expr = ExpressionUtil.getParser().parse("properties[$0] == $1");

        public IUPropertyQuery(String propertyName, String propertyValue) {
            super(IInstallableUnit.class, (IExpression)ExpressionUtil.getFactory().matchExpression(expr, new Object[]{propertyName, propertyValue}), new Object[0]);
        }
    }

    public static class InstallableUnitQuery
    extends ExpressionMatchQuery<IInstallableUnit> {
        public static final IQuery<IInstallableUnit> ANY = QueryUtil.createMatchQuery((String)"", (Object[])new Object[0]);
        private static final IExpression idVersionQuery;
        private static final IExpression idRangeQuery;

        static {
            IExpressionParser parser = ExpressionUtil.getParser();
            idVersionQuery = parser.parse("($0 == null || $0 == id) && ($1 == null || $1 == version)");
            idRangeQuery = parser.parse("($0 == null || $0 == id) && ($1 == null || version ~= $1)");
        }

        public InstallableUnitQuery(String id) {
            this(id, (Version)null);
        }

        public InstallableUnitQuery(String id, VersionRange range) {
            super(IInstallableUnit.class, (IExpression)ExpressionUtil.getFactory().matchExpression(idRangeQuery, new Object[]{id, range}), new Object[0]);
        }

        public InstallableUnitQuery(String id, Version version) {
            super(IInstallableUnit.class, (IExpression)ExpressionUtil.getFactory().matchExpression(idVersionQuery, new Object[]{id, version}), new Object[0]);
        }

        public InstallableUnitQuery(IVersionedId versionedId) {
            this(versionedId.getId(), versionedId.getVersion());
        }
    }

    public static class UpdateQuery
    extends ExpressionMatchQuery<IInstallableUnit> {
        private static final IExpression expr1;
        private static final IExpression expr2;

        static {
            IExpressionParser parser = ExpressionUtil.getParser();
            expr1 = parser.parse("$0 ~= updateDescriptor && ($0.id != id || $0.version < version)");
            expr2 = parser.parse("this ~= class('org.eclipse.equinox.p2.metadata.IInstallableUnitPatch')? $0 ~= lifeCycle: $0 ~= updateDescriptor && ($0.id != id || $0.version < version)");
        }

        public UpdateQuery(IInstallableUnit updateFrom) {
            super(IInstallableUnit.class, (IExpression)ExpressionUtil.getFactory().matchExpression(updateFrom instanceof IInstallableUnitPatch ? expr1 : expr2, new Object[]{updateFrom, IInstallableUnitPatch.class}), new Object[0]);
        }
    }
}

