/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.engine.SurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.jarprocessor.StreamProcessor;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Feature;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorImpl;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AbstractReconcilerTest
extends AbstractProvisioningTest {
    public static final String VERIFIER_BUNDLE_ID = "org.eclipse.equinox.p2.tests.verifier";
    protected static File output;
    protected static Set<File> toRemove;
    private static boolean initialized;
    private static Properties archiveAndRepositoryProperties;
    private String propertyToPlatformArchive;
    protected boolean debug = false;

    static {
        toRemove = new HashSet<File>();
        initialized = false;
        archiveAndRepositoryProperties = null;
        AbstractReconcilerTest.loadPlatformZipPropertiesFromFile();
    }

    public AbstractReconcilerTest(String name) {
        super(name);
    }

    public AbstractReconcilerTest(String name, String propertyToPlatformArchive) {
        super(name);
        this.propertyToPlatformArchive = propertyToPlatformArchive;
    }

    public void initialize() throws Exception {
        initialized = false;
        File platform = this.getPlatformZip();
        output = AbstractReconcilerTest.getUniqueFolder();
        toRemove.add(output);
        if (platform.isDirectory()) {
            final Path targetPath = output.toPath();
            final Path sourcePath = platform.toPath();
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (platform.getName().toLowerCase().endsWith(".zip")) {
            try {
                FileUtils.unzipFile((File)platform, (File)output);
            }
            catch (IOException e) {
                AbstractReconcilerTest.fail("0.99", e);
            }
        } else if (platform.getName().toLowerCase().endsWith(".dmg")) {
            this.extractDmg("1.1", platform);
        } else {
            this.untar("1.0", platform);
        }
        File exe = new File(output, AbstractReconcilerTest.getExeFolder() + "eclipse.exe");
        if (!exe.exists()) {
            exe = new File(output, AbstractReconcilerTest.getExeFolder() + "eclipse");
            if (!exe.exists()) {
                AbstractReconcilerTest.fail((String)("Executable file: " + exe.getAbsolutePath() + "(or .exe) not found after extracting: " + platform.getAbsolutePath() + " to: " + String.valueOf(output)));
            }
            if (!(exe.canExecute() || exe.setExecutable(true, false) && exe.setExecutable(true, true))) {
                AbstractReconcilerTest.fail((String)("Executable file: " + exe.getAbsolutePath() + " is not executable"));
            }
        }
        initialized = true;
    }

    public void assertInitialized() {
        AbstractReconcilerTest.assertTrue((String)"Test suite not initialized, check log for previous errors.", (boolean)initialized);
    }

    protected static int run(String message, String[] commandArray) {
        try {
            Process process = Runtime.getRuntime().exec(commandArray, null, output);
            StreamProcessor.start((InputStream)process.getErrorStream(), (String)"STDERR", (boolean)true);
            StreamProcessor.start((InputStream)process.getInputStream(), (String)"STDOUT", (boolean)true);
            process.waitFor();
            return process.exitValue();
        }
        catch (IOException e) {
            AbstractReconcilerTest.fail(message, e);
        }
        catch (InterruptedException e) {
            AbstractReconcilerTest.fail(message, e);
        }
        return -1;
    }

    protected static int run(String message, String[] commandArray, File outputFile) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            outputFile.getParentFile().mkdirs();
            Throwable throwable = null;
            Object var6_8 = null;
            PrintStream fileStream = new PrintStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
            try {
                System.setErr(fileStream);
                System.setOut(fileStream);
                int n = AbstractReconcilerTest.run(message, commandArray);
                if (fileStream != null) {
                    fileStream.close();
                }
                return n;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (fileStream != null) {
                            fileStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    return -1;
                }
            }
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }

    private void untar(String message, File file) {
        String name = file.getName();
        File gzFile = new File(output, name);
        output.mkdirs();
        AbstractReconcilerTest.run(message, new String[]{"cp", file.getAbsolutePath(), gzFile.getAbsolutePath()});
        AbstractReconcilerTest.run(message, new String[]{"tar", "-zpxf", gzFile.getAbsolutePath()});
        gzFile.delete();
    }

    private void extractDmg(String message, File file) {
        output.mkdirs();
        AbstractReconcilerTest.run(message, new String[]{"hdiutil", "attach", file.getAbsolutePath()});
        AbstractReconcilerTest.run(message, new String[]{"cp", "-r", "/Volumes/Eclipse/Eclipse.app", output.getAbsolutePath() + "/"});
        AbstractReconcilerTest.run(message, new String[]{"hdiutil", "detach", "/Volumes/Eclipse"});
        AbstractReconcilerTest.run(message, new String[]{"xattr", "-rc", output.getAbsolutePath() + "/Eclipse.app"});
    }

    public static File getUniqueFolder() {
        String tempDir = System.getProperty("java.io.tmpdir");
        return new File(tempDir, AbstractReconcilerTest.getUniqueString());
    }

    public static File getInstallLocation() {
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)TestActivator.getContext(), Location.class, (String)Location.INSTALL_FILTER);
        if (installLocation == null || !installLocation.isSet()) {
            return null;
        }
        URL url = installLocation.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    private String getValueFor(String property) {
        if (property == null) {
            return null;
        }
        String result = TestActivator.getContext().getProperty(property);
        if (result == null && archiveAndRepositoryProperties == null) {
            return null;
        }
        if (result == null) {
            archiveAndRepositoryProperties.getProperty(property);
        }
        if (result == null) {
            result = archiveAndRepositoryProperties.getProperty(property + "." + Platform.getOS());
        }
        return result;
    }

    private File getPlatformZip() {
        String property = null;
        File file = null;
        if (this.propertyToPlatformArchive != null) {
            property = this.getValueFor(this.propertyToPlatformArchive);
            String message = "Need to set the \"" + this.propertyToPlatformArchive + "\" system property with a valid path to the platform binary drop or copy the archive to be a sibling of the install folder.";
            if (property == null) {
                AbstractReconcilerTest.fail((String)message);
            }
            file = new File(property);
            AbstractReconcilerTest.assertNotNull((String)message, (Object)file);
            AbstractReconcilerTest.assertTrue((String)message, (boolean)file.exists());
            AbstractReconcilerTest.assertTrue((String)("File is zero length: " + file.getAbsolutePath()), (file.length() > 0L ? 1 : 0) != 0);
            return file;
        }
        property = this.getValueFor("org.eclipse.equinox.p2.reconciler.tests.platform.archive");
        if (property == null) {
            File[] children;
            File parent;
            File installLocation = AbstractReconcilerTest.getInstallLocation();
            if (Platform.getWS().equals("cocoa")) {
                installLocation = installLocation.getParentFile().getParentFile();
            }
            if (installLocation != null && (parent = installLocation.getParentFile()) != null && (parent = parent.getParentFile()) != null && (children = parent.listFiles(pathname -> {
                String name = pathname.getName();
                return name.startsWith("eclipse-platform-");
            })) != null && children.length == 1) {
                file = children[0];
            }
        } else {
            file = new File(property);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException installLocation) {
                // empty catch block
            }
            if (file.isDirectory()) {
                return file;
            }
        }
        StringBuilder detailedMessage = new StringBuilder(600);
        detailedMessage.append(" propertyToPlatformArchive was ").append(this.propertyToPlatformArchive == null ? " not set " : this.propertyToPlatformArchive).append('\n');
        detailedMessage.append(" org.eclipse.equinox.p2.reconciler.tests.platform.archive was ").append(property == null ? " not set " : property).append('\n');
        detailedMessage.append(" install location is ").append(AbstractReconcilerTest.getInstallLocation()).append('\n');
        String message = "Need to set the \"org.eclipse.equinox.p2.reconciler.tests.platform.archive\" system property with a valid path to the platform binary drop or copy the archive to be a sibling of the install folder.";
        AbstractReconcilerTest.assertNotNull((String)(message + "\n" + String.valueOf(detailedMessage)), (Object)file);
        AbstractReconcilerTest.assertTrue((String)(message + "\nThe file '" + file.getAbsolutePath() + "' does not exist"), (boolean)file.exists());
        AbstractReconcilerTest.assertTrue((String)("File is zero length: " + file.getAbsolutePath()), (file.length() > 0L ? 1 : 0) != 0);
        return file;
    }

    public void add(String message, String target, File file) {
        if (!(target.startsWith("dropins") || target.startsWith("plugins") || target.startsWith("features"))) {
            AbstractReconcilerTest.fail((String)"Destination folder for resource copying should be either dropins, plugins or features.");
        }
        File destinationParent = new File(output, AbstractReconcilerTest.getRootFolder() + target);
        destinationParent.mkdirs();
        AbstractReconcilerTest.copy(message, file, new File(destinationParent, file.getName()));
    }

    public void createLinkFile(String message, String filename, String extensionLocation) {
        File file = new File(output, AbstractReconcilerTest.getRootFolder() + "links/" + filename + ".link");
        file.getParentFile().mkdirs();
        Properties properties = new Properties();
        properties.put("path", extensionLocation);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
                properties.store(writer, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            AbstractReconcilerTest.fail(message, e);
        }
    }

    public void removeLinkFile(String message, String filename) {
        File file = new File(output, AbstractReconcilerTest.getRootFolder() + "links/" + filename + ".link");
        file.delete();
    }

    public void add(String message, String target, File[] files) {
        AbstractReconcilerTest.assertNotNull((Object)files);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.add(message, target, file);
            ++n2;
        }
    }

    public boolean remove(String message, String target, String filename) {
        File folder;
        File targetFile;
        if (!(target.startsWith("dropins") || target.startsWith("plugins") || target.startsWith("features"))) {
            AbstractReconcilerTest.fail((String)"Target folder for resource deletion should be either dropins, plugins or features.");
        }
        if (!(targetFile = new File(folder = new File(output, AbstractReconcilerTest.getRootFolder() + target), filename)).exists()) {
            return false;
        }
        return AbstractReconcilerTest.delete(targetFile);
    }

    public void remove(String message, String target, String[] names) {
        AbstractReconcilerTest.assertNotNull((Object)names);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.remove(message, target, name);
            ++n2;
        }
    }

    public boolean isInBundlesInfo(String bundleId) throws IOException {
        return this.isInBundlesInfo(bundleId, null);
    }

    protected File getBundlesInfo() {
        return new File(output, AbstractReconcilerTest.getRootFolder() + "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
    }

    public boolean isInBundlesInfo(String bundleId, String version) throws IOException {
        return this.isInBundlesInfo(bundleId, version, null);
    }

    public boolean isInBundlesInfo(String bundleId, String version, String location) throws IOException {
        return this.isInBundlesInfo(this.getBundlesInfo(), bundleId, version, location);
    }

    public boolean isInBundlesInfo(File bundlesInfo, String bundleId, String version) throws IOException {
        return this.isInBundlesInfo(bundlesInfo, bundleId, version, null);
    }

    public BundleInfo[] loadBundlesInfo(File location) throws IOException {
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = Files.newInputStream(location.toPath(), new OpenOption[0]);){
            return manipulator.loadConfiguration(input, new File(output, "eclipse").toURI());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void saveBundlesInfo(BundleInfo[] bundles, File location) throws IOException {
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        manipulator.saveConfiguration(bundles, location, null);
    }

    public boolean isInBundlesInfo(File bundlesInfo, String bundleId, String version, String location) throws IOException {
        BundleInfo[] infos = this.loadBundlesInfo(bundlesInfo);
        int i = 0;
        while (infos != null && i < infos.length) {
            BundleInfo info = infos[i];
            if (bundleId.equals(info.getSymbolicName()) && (version == null || version.equals(info.getVersion()))) {
                if (location == null) {
                    return true;
                }
                return info.getLocation().toString().contains(location);
            }
            ++i;
        }
        return false;
    }

    public void reconcile(String message) {
        this.reconcile(message, false);
    }

    public void reconcile(String message, boolean clean) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-application");
        args.add("org.eclipse.equinox.p2.reconciler.application");
        if (clean) {
            args.add("-clean");
        }
        this.runEclipse(message, args.toArray(new String[args.size()]));
    }

    public void assertDoesNotExistInBundlesInfo(String message, String bundleId, String version) {
        try {
            AbstractReconcilerTest.assertTrue((String)message, (!this.isInBundlesInfo(bundleId, version) ? 1 : 0) != 0);
        }
        catch (IOException e) {
            AbstractReconcilerTest.fail(message, e);
        }
    }

    public void assertDoesNotExistInBundlesInfo(String message, String bundleId) {
        this.assertDoesNotExistInBundlesInfo(message, bundleId, null);
    }

    public void assertExistsInBundlesInfo(String message, String bundleId, String version) {
        this.assertExistsInBundlesInfo(message, bundleId, version, null);
    }

    public void assertExistsInBundlesInfo(String message, String bundleId, String version, String location) {
        try {
            AbstractReconcilerTest.assertTrue((String)message, (boolean)this.isInBundlesInfo(bundleId, version, location));
        }
        catch (IOException e) {
            AbstractReconcilerTest.fail(message, e);
        }
    }

    public void assertExistsInBundlesInfo(String message, String bundleId) {
        this.assertExistsInBundlesInfo(message, bundleId, null);
    }

    public void cleanup() throws Exception {
        boolean leaveDirty = Boolean.parseBoolean(TestActivator.getContext().getProperty("p2.tests.doNotClean"));
        if (leaveDirty) {
            return;
        }
        for (File next : toRemove) {
            AbstractReconcilerTest.delete(next);
        }
        output = null;
        toRemove.clear();
    }

    public Configuration getConfiguration() {
        File configLocation = new File(output, AbstractReconcilerTest.getRootFolder() + "configuration/org.eclipse.update/platform.xml");
        File installLocation = new File(output, AbstractReconcilerTest.getRootFolder());
        return this.loadConfiguration(configLocation, installLocation);
    }

    public Configuration loadConfiguration(File configLocation, File installLocation) {
        try {
            return Configuration.load((File)configLocation, (URL)installLocation.toURI().toURL());
        }
        catch (ProvisionException e) {
            AbstractReconcilerTest.fail((String)("Error while reading configuration from " + String.valueOf(configLocation)));
        }
        catch (MalformedURLException e) {
            AbstractReconcilerTest.fail((String)("Unable to convert install location to URL " + String.valueOf(installLocation)));
        }
        AbstractReconcilerTest.assertTrue((String)("Unable to read configuration from " + String.valueOf(configLocation)), (boolean)false);
        return null;
    }

    public void save(String message, Configuration configuration) {
        File configLocation = new File(output, AbstractReconcilerTest.getRootFolder() + "configuration/org.eclipse.update/platform.xml");
        File installLocation = new File(output, AbstractReconcilerTest.getRootFolder());
        try {
            configuration.save(configLocation, installLocation.toURI().toURL());
        }
        catch (ProvisionException e) {
            AbstractReconcilerTest.fail(message, e);
        }
        catch (MalformedURLException e) {
            AbstractReconcilerTest.fail(message, e);
        }
    }

    public boolean removeSite(Configuration configuration, String location) throws IOException, URISyntaxException {
        File left = new File(new URI(location)).getCanonicalFile();
        for (Site tempSite : configuration.getSites()) {
            String siteURL = tempSite.getUrl();
            File right = new File(new URI(siteURL)).getCanonicalFile();
            if (!left.equals(right)) continue;
            return configuration.removeSite(tempSite);
        }
        return false;
    }

    public Feature createFeature(Site site, String id, String version, String url) {
        Feature result = new Feature(site);
        result.setId(id);
        result.setVersion(version);
        result.setUrl(url);
        return result;
    }

    public Site createSite(String policy, boolean enabled, boolean updateable, String uri, String[] plugins) {
        Site result = new Site();
        result.setPolicy(policy);
        result.setEnabled(enabled);
        result.setUpdateable(updateable);
        result.setUrl(uri);
        if (plugins != null) {
            String[] stringArray = plugins;
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                String plugin = stringArray[n2];
                result.addPlugin(plugin);
                ++n2;
            }
        }
        return result;
    }

    public void copyBundle(String bundlename, File source, File destination) throws IOException {
        if (destination == null) {
            destination = output;
        }
        destination = new File(destination, "eclipse/plugins");
        if (source == null) {
            Bundle bundle = TestActivator.getBundle(bundlename);
            if (bundle == null) {
                throw new IOException("Could not find: " + bundlename);
            }
            String location = bundle.getLocation();
            if (location.startsWith("reference:")) {
                location = location.substring("reference:".length());
            }
            source = new File(FileLocator.toFileURL((URL)new URL(location)).getFile());
        }
        if ((destination = new File(destination, source.getName())).exists()) {
            return;
        }
        FileUtils.copy((File)source, (File)destination, (File)new File(""), (boolean)false);
        AbstractReconcilerTest.assertTrue((String)("Unable to copy " + String.valueOf(source) + " to " + String.valueOf(destination)), (boolean)destination.exists());
    }

    public void assertFeatureExists(String message, Configuration configuration, String id, String version) {
        List sites = configuration.getSites();
        AbstractReconcilerTest.assertNotNull((String)message, (Object)sites);
        boolean found = false;
        for (Site site : sites) {
            Feature[] features = site.getFeatures();
            int i = 0;
            while (features != null && i < features.length) {
                if (id.equals(features[i].getId())) {
                    if (version == null) {
                        found = true;
                    } else if (version.equals(features[i].getVersion())) {
                        found = true;
                    }
                }
                ++i;
            }
        }
        AbstractReconcilerTest.assertTrue((String)message, (boolean)found);
    }

    public boolean isInstalled(String id, String version) {
        File location = new File(output, AbstractReconcilerTest.getRootFolder() + "/p2/org.eclipse.equinox.p2.engine/profileRegistry");
        SimpleProfileRegistry registry = new SimpleProfileRegistry(AbstractReconcilerTest.getAgent(), location, (ISurrogateProfileHandler)new SurrogateProfileHandler(AbstractReconcilerTest.getAgent()), false);
        IProfile[] profiles = registry.getProfiles();
        AbstractReconcilerTest.assertEquals((String)"1.0 Should only be one profile in registry.", (int)1, (int)profiles.length);
        IQueryResult queryResult = profiles[0].query(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version)), null);
        return !queryResult.isEmpty();
    }

    public IInstallableUnit getRemoteIU(String id, String version) {
        File location = new File(output, AbstractReconcilerTest.getRootFolder() + "/p2/org.eclipse.equinox.p2.engine/profileRegistry");
        SimpleProfileRegistry registry = new SimpleProfileRegistry(AbstractReconcilerTest.getAgent(), location, (ISurrogateProfileHandler)new SurrogateProfileHandler(AbstractReconcilerTest.getAgent()), false);
        IProfile[] profiles = registry.getProfiles();
        AbstractReconcilerTest.assertEquals((String)"1.0 Should only be one profile in registry.", (int)1, (int)profiles.length);
        IQueryResult queryResult = profiles[0].query(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version)), null);
        AbstractReconcilerTest.assertEquals((String)"1.1 Should not have more than one IU wth the same ID and version.", (int)1, (int)AbstractReconcilerTest.queryResultSize(queryResult));
        return (IInstallableUnit)queryResult.iterator().next();
    }

    protected int runEclipse(String message, String[] args) {
        return this.runEclipse(message, null, args);
    }

    protected int runEclipse(String message, File location, String[] args) {
        return this.runEclipse(message, location, args, null);
    }

    protected int runEclipse(String message, File location, String[] args, File extensions) {
        int result;
        File root = new File(Activator.getBundleContext().getProperty("java.home"));
        File exe = new File(root = new File(root, "bin"), "javaw.exe");
        if (!exe.exists()) {
            exe = new File(root, "java");
        }
        AbstractReconcilerTest.assertTrue((String)("Java executable not found in: " + exe.getAbsolutePath()), (boolean)exe.exists());
        ArrayList command = new ArrayList();
        Collections.addAll(command, new File(location == null ? output : location, AbstractReconcilerTest.getExeFolder() + "eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-nosplash", "-vm", exe.getAbsolutePath());
        Collections.addAll(command, args);
        Collections.addAll(command, "-vmArgs", "-Dosgi.checkConfiguration=true", "-Dosgi.dataAreaRequiresExplicitInit=false");
        if (this.debug) {
            Collections.addAll(command, "-Xdebug", "-Xnoagent", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8787");
        }
        if ((result = AbstractReconcilerTest.run(message, command.toArray(new String[command.size()]))) == 13) {
            this.parseExitdata(message);
        }
        return result;
    }

    protected void debugEclipse(boolean on) {
        this.debug = on;
    }

    protected void parseExitdata(String message) {
        String errors;
        String data = TestActivator.getContext().getProperty("eclipse.exitdata");
        if (data == null) {
            return;
        }
        String log = null;
        StringTokenizer tokenizer = new StringTokenizer(data);
        while (tokenizer.hasMoreTokens()) {
            log = tokenizer.nextToken();
        }
        if (log == null) {
            return;
        }
        if (log.endsWith(".")) {
            log = log.substring(0, log.length() - 1);
        }
        if ((errors = this.read(log)) == null) {
            return;
        }
        AbstractReconcilerTest.assertOK(message, (IStatus)new Status(4, "org.eclipse.equinox.p2.test", errors));
    }

    private String read(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public int runInitialize(String message) {
        return this.runEclipse(message, new String[]{"-initialize"});
    }

    public int runDirectorToUpdate(String message, String sourceRepo, String iuToInstall, String iuToUninstall) {
        return this.runEclipse(message, new String[]{"-application", "org.eclipse.equinox.p2.director", "-repository", sourceRepo, "-installIU", iuToInstall, "-uninstallIU", iuToUninstall});
    }

    public int runDirectorToRevert(String message, String sourceRepo, String timestampToRevertTo) {
        return this.runEclipse(message, new String[]{"-application", "org.eclipse.equinox.p2.director", "-repository", sourceRepo, "-revert", timestampToRevertTo});
    }

    public int runDirectorToInstall(String message, File installFolder, String sourceRepo, String iuToInstall) {
        String[] command = new String[]{"-application", "org.eclipse.equinox.p2.director", "-repository", sourceRepo, "-installIU", iuToInstall, "-destination", installFolder.getAbsolutePath(), "-bundlepool", installFolder.getAbsolutePath(), "-roaming", "-profile", "PlatformProfile", "-profileProperties", "org.eclipse.update.install.features=true", "-p2.os", Platform.getOS(), "-p2.ws", Platform.getWS(), "-p2.arch", Platform.getOSArch()};
        return this.runEclipse(message, command);
    }

    public int runVerifierBundle(File destination) {
        if (destination == null) {
            destination = output;
        }
        String message = "Running the verifier bundle at: " + String.valueOf(destination);
        return this.runEclipse(message, destination, new String[]{"-application", "org.eclipse.equinox.p2.tests.verifier.application", "-consoleLog"});
    }

    public int installAndRunVerifierBundle(File destination) {
        if (destination == null) {
            destination = output;
        }
        try {
            this.copyBundle(VERIFIER_BUNDLE_ID, null, destination);
        }
        catch (IOException e) {
            AbstractReconcilerTest.fail((String)"Could not find the verifier bundle");
        }
        int returnCode = this.runVerifierBundle(destination);
        this.deleteVerifierBundle(destination);
        return returnCode;
    }

    public int installAndRunVerifierBundle35(File destination) {
        if (destination == null) {
            destination = output;
        }
        try {
            this.copyBundle(VERIFIER_BUNDLE_ID, AbstractReconcilerTest.getTestData("org.eclipse.equinox.p2.tests.verifier3.5", "testData/VerifierBundle35/org.eclipse.equinox.p2.tests.verifier_1.0.0.jar"), destination);
        }
        catch (IOException e) {
            AbstractReconcilerTest.fail((String)"Could not find the verifier bundle");
        }
        int returnCode = this.runVerifierBundle(destination);
        this.deleteVerifierBundle(destination);
        return returnCode;
    }

    private void deleteVerifierBundle(File destination) {
        File[] verifierBundle;
        if (destination == null) {
            destination = output;
        }
        if ((verifierBundle = (destination = new File(destination, AbstractReconcilerTest.getRootFolder() + "plugins")).listFiles((dir, name) -> name.startsWith(VERIFIER_BUNDLE_ID))) != null && verifierBundle.length > 0) {
            verifierBundle[0].delete();
        }
    }

    private static void loadPlatformZipPropertiesFromFile() {
        File parent;
        File installLocation = AbstractReconcilerTest.getInstallLocation();
        if (installLocation != null && (parent = installLocation.getParentFile()) != null && (parent = parent.getParentFile()) != null) {
            File propertiesFile = new File(parent, "equinoxp2tests.properties");
            if (!propertiesFile.exists()) {
                return;
            }
            archiveAndRepositoryProperties = new Properties();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
                    archiveAndRepositoryProperties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return;
            }
        }
    }

    protected static String getRootFolder() {
        String eclipseFolder = "eclipse/";
        if (Platform.getWS().equals("cocoa")) {
            eclipseFolder = "Eclipse.app/Contents/Eclipse/";
        }
        return eclipseFolder;
    }

    protected static String getExeFolder() {
        String eclipseFolder = "eclipse/";
        if (Platform.getWS().equals("cocoa")) {
            eclipseFolder = "Eclipse.app/Contents/MacOS/";
        }
        return eclipseFolder;
    }
}

