/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import junit.framework.Test;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Feature;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.tests.reconciler.dropins.AbstractReconcilerTest;
import org.eclipse.equinox.p2.tests.reconciler.dropins.ReconcilerTestSuite;

public class ConfigurationTests
extends AbstractReconcilerTest {
    public ConfigurationTests(String name) {
        super(name);
    }

    public static Test suite() {
        ReconcilerTestSuite suite = new ReconcilerTestSuite();
        suite.setName(ConfigurationTests.class.getName());
        suite.addTest((Test)new ConfigurationTests("testDiscoverOne"));
        suite.addTest((Test)new ConfigurationTests("test_247095"));
        suite.addTest((Test)new ConfigurationTests("test_247095b"));
        suite.addTest((Test)new ConfigurationTests("test_249607"));
        suite.addTest((Test)new ConfigurationTests("test_249898"));
        suite.addTest((Test)new ConfigurationTests("testSiteEnabled"));
        suite.addTest((Test)new ConfigurationTests("test_232094a"));
        suite.addTest((Test)new ConfigurationTests("test_232094b"));
        return suite;
    }

    public void testDiscoverOne() {
        this.assertInitialized();
        File featureFile = ConfigurationTests.getTestData("2.0", "testData/reconciler/features/myFeature_1.0.0");
        this.add("2.2", "dropins/features", featureFile);
        File bundleFile = ConfigurationTests.getTestData("2.3", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("2.4", "dropins/plugins", bundleFile);
        this.assertDoesNotExistInBundlesInfo("2.5", "myBundle");
        ConfigurationTests.assertFalse((String)"2.6", (boolean)this.isInstalled("myBundle", "1.0.0"));
        this.reconcile("2.7");
        Configuration config = this.getConfiguration();
        this.assertFeatureExists("3.0", config, "myFeature", "1.0.0");
        ConfigurationTests.assertTrue((String)"3.1", (boolean)this.isInstalled("myFeature.feature.group", "1.0.0"));
        ConfigurationTests.assertTrue((String)"3.2", (boolean)this.isInstalled("myBundle", "1.0.0"));
        this.assertExistsInBundlesInfo("3.3", "myBundle");
        this.remove("99.0", "dropins/plugins", bundleFile.getName());
        this.remove("99.1", "dropins/features", featureFile.getName());
        this.reconcile("99.2");
        config = this.getConfiguration();
        ConfigurationTests.assertFalse((String)"99.4", (boolean)this.isInstalled("myFeature.feature.group", "1.0.0"));
        this.assertDoesNotExistInBundlesInfo("99.5", "myBundle");
        ConfigurationTests.assertFalse((String)"99.6", (boolean)this.isInstalled("myBundle", "1.0.0"));
    }

    public void testSiteEnabled() throws IOException, URISyntaxException {
        this.assertInitialized();
        File temp = this.getTempFolder();
        toRemove.add(temp);
        Configuration configuration = this.getConfiguration();
        String siteLocation = new File(temp, "eclipse").getCanonicalFile().toURI().toString();
        File source = ConfigurationTests.getTestData("2.0", "testData/reconciler/ext.jar");
        ConfigurationTests.copy("2.1", source, temp);
        this.assertDoesNotExistInBundlesInfo("3.01", "bbb");
        this.assertDoesNotExistInBundlesInfo("3.02", "ccc");
        ConfigurationTests.assertFalse((String)"3.11", (boolean)this.isInstalled("bbb", "1.0.0"));
        ConfigurationTests.assertFalse((String)"3.12", (boolean)this.isInstalled("ccc", "1.0.0"));
        Site site = this.createSite("USER-EXCLUDE", true, false, siteLocation, null);
        Feature feature = this.createFeature(site, "bbb.feature", "1.0.0", "features/bbb.feature_1.0.0/");
        site.addFeature(feature);
        configuration.add(site);
        this.save("3.2", configuration);
        this.reconcile("3.3");
        this.assertExistsInBundlesInfo("3.41", "bbb");
        this.assertExistsInBundlesInfo("3.42", "ccc");
        ConfigurationTests.assertTrue((String)"3.51", (boolean)this.isInstalled("bbb", "1.0.0"));
        ConfigurationTests.assertTrue((String)"3.52", (boolean)this.isInstalled("ccc", "1.0.0"));
        configuration = this.getConfiguration();
        this.assertFeatureExists("3.6", configuration, "bbb.feature", "1.0.0");
        ConfigurationTests.assertTrue((String)"4.0", (boolean)this.removeSite(configuration, siteLocation));
        site = this.createSite("USER-EXCLUDE", false, false, siteLocation, null);
        feature = this.createFeature(site, "bbb.feature", "1.0.0", "features/bbb.feature_1.0.0/");
        site.addFeature(feature);
        configuration.add(site);
        this.save("4.1", configuration);
        this.reconcile("4.2");
        this.assertDoesNotExistInBundlesInfo("5.01", "bbb");
        this.assertDoesNotExistInBundlesInfo("5.02", "ccc");
        ConfigurationTests.assertFalse((String)"5.11", (boolean)this.isInstalled("bbb", "1.0.0"));
        ConfigurationTests.assertFalse((String)"5.12", (boolean)this.isInstalled("ccc", "1.0.0"));
    }

    public void test_247095() throws IOException, URISyntaxException {
        this.assertInitialized();
        Configuration configuration = this.getConfiguration();
        File temp = this.getTempFolder();
        toRemove.add(temp);
        String siteLocation = null;
        siteLocation = new File(temp, "eclipse").getCanonicalFile().toURI().toString();
        File source = ConfigurationTests.getTestData("1.0", "testData/reconciler/247095");
        ConfigurationTests.copy("1.1", source, temp);
        Site site = this.createSite("USER-INCLUDE", true, false, siteLocation, new String[]{"plugins/bbb_1.0.0.jar,plugins/ccc_1.0.0.jar"});
        Feature feature = this.createFeature(site, "bbb.feature", "1.0.0", "features/bbb.feature_1.0.0/");
        site.addFeature(feature);
        configuration.add(site);
        this.save("5.0", configuration);
        this.reconcile("6.0");
        this.assertExistsInBundlesInfo("7.0", "bbb", "1.0.0");
        ConfigurationTests.assertTrue((String)"7.1", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertExistsInBundlesInfo("7.2", "ccc", "1.0.0");
        ConfigurationTests.assertTrue((String)"7.3", (boolean)this.isInstalled("ccc", "1.0.0"));
        configuration = this.getConfiguration();
        this.assertFeatureExists("8.0", configuration, "bbb.feature", "1.0.0");
        configuration = this.getConfiguration();
        ConfigurationTests.assertTrue((String)"9.0", (boolean)this.removeSite(configuration, siteLocation));
        site = this.createSite("USER-INCLUDE", true, false, siteLocation, new String[]{"plugins/ccc_1.0.0.jar"});
        configuration.add(site);
        this.save("9.1", configuration);
        this.reconcile("10.0");
        this.assertDoesNotExistInBundlesInfo("10.1", "bbb", "1.0.0");
        ConfigurationTests.assertFalse((String)"10.2", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertExistsInBundlesInfo("10.3", "ccc", "1.0.0");
        ConfigurationTests.assertTrue((String)"10.4", (boolean)this.isInstalled("ccc", "1.0.0"));
        configuration = this.getConfiguration();
        this.removeSite(configuration, siteLocation);
        this.save("99.2", configuration);
        this.reconcile("99.3");
        this.assertDoesNotExistInBundlesInfo("99.4", "ccc", "1.0.0");
        ConfigurationTests.assertFalse((String)"99.5", (boolean)this.isInstalled("ccc", "1.0.0"));
    }

    public void test_247095b() throws IOException, URISyntaxException {
        this.assertInitialized();
        Configuration configuration = this.getConfiguration();
        File temp = this.getTempFolder();
        toRemove.add(temp);
        String siteLocation = null;
        siteLocation = new File(temp, "eclipse").getCanonicalFile().toURI().toString();
        File source = ConfigurationTests.getTestData("1.0", "testData/reconciler/247095");
        ConfigurationTests.copy("1.1", source, temp);
        Site site = this.createSite("USER-INCLUDE", true, false, siteLocation, new String[]{"plugins/bbb_1.0.0.jar,plugins/ccc_1.0.0.jar"});
        Feature feature = this.createFeature(site, "bbb.feature", "1.0.0", "features/bbb.feature_1.0.0/");
        site.addFeature(feature);
        configuration.add(site);
        this.save("5.0", configuration);
        this.reconcile("6.0");
        this.assertExistsInBundlesInfo("7.0", "bbb", "1.0.0");
        ConfigurationTests.assertTrue((String)"7.1", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertExistsInBundlesInfo("7.2", "ccc", "1.0.0");
        ConfigurationTests.assertTrue((String)"7.3", (boolean)this.isInstalled("ccc", "1.0.0"));
        configuration = this.getConfiguration();
        this.assertFeatureExists("8.0", configuration, "bbb.feature", "1.0.0");
        configuration = this.getConfiguration();
        ConfigurationTests.assertTrue((String)"9.0", (boolean)this.removeSite(configuration, siteLocation));
        site = this.createSite("USER-INCLUDE", true, false, siteLocation, new String[]{"plugins/ccc_1.0.0.jar"});
        configuration.add(site);
        this.save("9.1", configuration);
        File parent = new File(temp, "eclipse");
        ConfigurationTests.assertTrue((String)"9.2", (boolean)ConfigurationTests.delete(new File(parent, "plugins/bbb_1.0.0.jar")));
        ConfigurationTests.assertTrue((String)"9.3", (boolean)ConfigurationTests.delete(new File(parent, "features/bbb.feature_1.0.0")));
        this.reconcile("10.0");
        this.assertDoesNotExistInBundlesInfo("10.1", "bbb", "1.0.0");
        ConfigurationTests.assertFalse((String)"10.2", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertExistsInBundlesInfo("10.3", "ccc", "1.0.0");
        ConfigurationTests.assertTrue((String)"10.4", (boolean)this.isInstalled("ccc", "1.0.0"));
        configuration = this.getConfiguration();
        this.removeSite(configuration, siteLocation);
        this.save("99.2", configuration);
        this.reconcile("99.3");
        this.assertDoesNotExistInBundlesInfo("99.4", "ccc", "1.0.0");
        ConfigurationTests.assertFalse((String)"99.5", (boolean)this.isInstalled("ccc", "1.0.0"));
    }

    public void test_249607() throws IOException, URISyntaxException {
        this.assertInitialized();
        Configuration configuration = this.getConfiguration();
        File temp = this.getTempFolder();
        toRemove.add(temp);
        String siteLocation = null;
        siteLocation = new File(temp, "eclipse").getCanonicalFile().toURI().toString();
        File source = ConfigurationTests.getTestData("1.0", "testData/reconciler/247095");
        ConfigurationTests.copy("1.1", source, temp);
        Site site = this.createSite("USER-EXCLUDE", true, false, siteLocation, new String[]{"plugins/ccc_1.0.0.jar"});
        Feature feature = this.createFeature(site, "bbb.feature", "1.0.0", "features/bbb.feature_1.0.0/");
        site.addFeature(feature);
        configuration.add(site);
        this.save("2.0", configuration);
        this.reconcile("2.1");
        this.assertExistsInBundlesInfo("2.2", "bbb", "1.0.0");
        ConfigurationTests.assertTrue((String)"2.3", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertDoesNotExistInBundlesInfo("2.4", "ccc");
        ConfigurationTests.assertFalse((String)"2.4", (boolean)this.isInstalled("ccc", "1.0.0"));
        configuration = this.getConfiguration();
        this.assertFeatureExists("3.0", configuration, "bbb.feature", "1.0.0");
        ConfigurationTests.assertTrue((String)"3.1", (boolean)this.isInstalled("bbb.feature.feature.group", "1.0.0"));
        configuration = this.getConfiguration();
        this.removeSite(configuration, siteLocation);
        this.save("99.2", configuration);
        this.reconcile("99.3");
        this.assertDoesNotExistInBundlesInfo("99.4", "bbb", "1.0.0");
        ConfigurationTests.assertFalse((String)"99.5", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertDoesNotExistInBundlesInfo("99.6", "ccc", "1.0.0");
        ConfigurationTests.assertFalse((String)"99.7", (boolean)this.isInstalled("ccc", "1.0.0"));
    }

    public void test_249898() throws IOException, URISyntaxException {
        this.assertInitialized();
        Configuration configuration = this.getConfiguration();
        File temp = this.getTempFolder();
        toRemove.add(temp);
        String siteLocation = new File(temp, "eclipse").getCanonicalFile().toURI().toString();
        File source = ConfigurationTests.getTestData("1.0", "testData/reconciler/247095");
        ConfigurationTests.copy("1.1", source, temp);
        Site site = this.createSite("USER-INCLUDE", true, false, siteLocation, new String[]{"plugins/bbb_1.0.0.jar,plugins/ccc_1.0.0.jar"});
        Feature feature = this.createFeature(site, "bbb.feature", "1.0.0", "features/bbb.feature_1.0.0/");
        site.addFeature(feature);
        configuration.add(site);
        this.save("5.0", configuration);
        this.reconcile("6.0");
        this.assertExistsInBundlesInfo("7.0", "bbb", "1.0.0");
        ConfigurationTests.assertTrue((String)"7.1", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertExistsInBundlesInfo("7.2", "ccc", "1.0.0");
        ConfigurationTests.assertTrue((String)"7.3", (boolean)this.isInstalled("ccc", "1.0.0"));
        configuration = this.getConfiguration();
        this.assertFeatureExists("8.0", configuration, "bbb.feature", "1.0.0");
        configuration = this.getConfiguration();
        ConfigurationTests.assertTrue((String)"9.0", (boolean)this.removeSite(configuration, siteLocation));
        this.save("9.1", configuration);
        this.reconcile("10.0");
        this.assertDoesNotExistInBundlesInfo("10.1", "bbb", "1.0.0");
        ConfigurationTests.assertFalse((String)"10.2", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertDoesNotExistInBundlesInfo("10.3", "ccc", "1.0.0");
        ConfigurationTests.assertFalse((String)"10.4", (boolean)this.isInstalled("ccc", "1.0.0"));
    }

    public void test_232094a() throws IOException {
        this.assertInitialized();
        this.internal_test_232094(ConfigurationTests.getTestData("1.0", "testData/reconciler/ext.dir"));
    }

    public void test_232094b() throws IOException {
        this.assertInitialized();
        this.internal_test_232094(ConfigurationTests.getTestData("1.0", "testData/reconciler/ext.jar"));
    }

    private void internal_test_232094(File source) throws IOException {
        File temp = this.getTempFolder();
        toRemove.add(temp);
        ConfigurationTests.copy("1.1", source, temp);
        this.createLinkFile("2.0", "myLink", temp.getCanonicalFile().getAbsolutePath());
        this.reconcile("3.0");
        this.assertExistsInBundlesInfo("4.0", "bbb");
        ConfigurationTests.assertTrue((String)"4.1", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertExistsInBundlesInfo("4.2", "ccc");
        ConfigurationTests.assertTrue((String)"4.3", (boolean)this.isInstalled("ccc", "1.0.0"));
        ConfigurationTests.assertTrue((String)"4.4", (boolean)this.isInstalled("bbb.feature.feature.group", "1.0.0"));
        this.assertFeatureExists("4.5", this.getConfiguration(), "bbb.feature", "1.0.0");
        this.removeLinkFile("5.0", "myLink");
        this.reconcile("6.0");
        this.assertDoesNotExistInBundlesInfo("7.0", "bbb");
        ConfigurationTests.assertFalse((String)"7.1", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertDoesNotExistInBundlesInfo("7.2", "ccc");
        ConfigurationTests.assertFalse((String)"7.3", (boolean)this.isInstalled("ccc", "1.0.0"));
        ConfigurationTests.assertFalse((String)"7.4", (boolean)this.isInstalled("bbb.feature.feature.group", "1.0.0"));
        boolean found = false;
        for (Site site : this.getConfiguration().getSites()) {
            String link = site.getLinkFile();
            if (link == null || !link.contains("myLink")) continue;
            found = true;
        }
        ConfigurationTests.assertFalse((String)"7.5", (boolean)found);
    }

    public void test_p2Site() throws IOException, URISyntaxException {
        this.assertInitialized();
        this.reconcile("0.1");
        File temp = this.getTempFolder();
        toRemove.add(temp);
        File source = ConfigurationTests.getTestData("1.0", "testData/reconciler/basicRepo");
        ConfigurationTests.copy("1.1", source, temp);
        String siteLocation = temp.toURI().toString();
        Configuration configuration = this.getConfiguration();
        Site site = this.createSite("USER-EXCLUDE", true, false, siteLocation, null);
        Feature feature = this.createFeature(site, "zFeature", "1.0.0", "features/zFeature_1.0.0/");
        site.addFeature(feature);
        configuration.add(site);
        this.save("2.0", configuration);
        this.reconcile("2.1");
        this.assertExistsInBundlesInfo("3.0", "zzz");
        ConfigurationTests.assertTrue((String)"3.1", (boolean)this.isInstalled("zzz", "1.0.0"));
        ConfigurationTests.assertTrue((String)"3.2", (boolean)this.isInstalled("zFeature.feature.group", "1.0.0"));
        IInstallableUnit unit = this.getRemoteIU("zzz", "1.0.0");
        ConfigurationTests.assertEquals((String)"3.3", (String)"foo", (String)unit.getProperty("test"));
        configuration = this.getConfiguration();
        ConfigurationTests.assertTrue((String)"99.0", (boolean)this.removeSite(configuration, siteLocation));
        this.save("99.1", configuration);
        this.reconcile("99.2");
        this.assertDoesNotExistInBundlesInfo("99.3", "zzz", "1.0.0");
        ConfigurationTests.assertFalse((String)"99.4", (boolean)this.isInstalled("zzz", "1.0.0"));
        ConfigurationTests.assertFalse((String)"99.5", (boolean)this.isInstalled("zFeature.feature.group", "1.0.0"));
    }
}

