/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import junit.framework.Test;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.p2.tests.reconciler.dropins.AbstractReconcilerTest;
import org.eclipse.equinox.p2.tests.reconciler.dropins.ReconcilerTestSuite;

public class SharedInstallTests
extends AbstractReconcilerTest {
    protected static final boolean WINDOWS = File.separatorChar == '\\';
    protected static File readOnlyBase;
    protected static File userBase;

    public static Test suite() {
        ReconcilerTestSuite suite = new ReconcilerTestSuite();
        suite.setName(SharedInstallTests.class.getName());
        suite.addTest((Test)new SharedInstallTests("testBasicStartup"));
        suite.addTest((Test)new SharedInstallTests("testReadOnlyDropinsStartup"));
        suite.addTest((Test)new SharedInstallTests("testUserDropinsStartup"));
        return suite;
    }

    public SharedInstallTests(String name) {
        super(name);
    }

    public void reconcileReadOnly(String message) {
        File root = new File(Activator.getBundleContext().getProperty("java.home"));
        File exe = new File(root = new File(root, "bin"), "javaw.exe");
        if (!exe.exists()) {
            exe = new File(root, "java");
        }
        String configuration = new File(userBase, "configuration").getAbsolutePath();
        String[] command = new String[]{new File(output, SharedInstallTests.getExeFolder() + "/eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-nosplash", "-application", "org.eclipse.equinox.p2.reconciler.application", "-configuration", configuration, "-vm", exe.getAbsolutePath(), "-vmArgs", "-Dosgi.checkConfiguration=true"};
        SharedInstallTests.run(message, command);
    }

    public static void setReadOnly(File target, boolean readOnly) {
        if (WINDOWS) {
            Object targetPath = target.getAbsolutePath();
            String[] command = new String[]{"attrib", readOnly ? "+r" : "-r", targetPath, "/s", "/d"};
            SharedInstallTests.run("setReadOnly " + readOnly + " failed on" + target.getAbsolutePath(), command);
            if (target.isDirectory()) {
                targetPath = (String)targetPath + "\\*.*";
                command = new String[]{"attrib", readOnly ? "+r" : "-r", targetPath, "/s", "/d"};
                SharedInstallTests.run("setReadOnly " + readOnly + " failed on" + target.getAbsolutePath(), command);
            }
        } else {
            String[] command = new String[]{"chmod", "-R", readOnly ? "a-w" : "a+w", target.getAbsolutePath()};
            SharedInstallTests.run("setReadOnly " + readOnly + " failed on" + target.getAbsolutePath(), command);
        }
    }

    protected static void cleanupReadOnlyInstall() {
        SharedInstallTests.delete(userBase);
        SharedInstallTests.setReadOnly(readOnlyBase, false);
        SharedInstallTests.assertTrue((String)"0.7", (boolean)readOnlyBase.canWrite());
    }

    protected void setupReadOnlyInstall() {
        readOnlyBase = new File(output, SharedInstallTests.getRootFolder());
        SharedInstallTests.assertTrue((boolean)readOnlyBase.canWrite());
        SharedInstallTests.setReadOnly(readOnlyBase, true);
        userBase = new File(output, "user");
        userBase.mkdir();
    }

    public void testBasicStartup() throws IOException {
        this.assertInitialized();
        this.setupReadOnlyInstall();
        try {
            File userBundlesInfo = new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
            File userConfigIni = new File(userBase, "configuration/config.ini");
            SharedInstallTests.assertFalse((String)"0.1", (boolean)userBundlesInfo.exists());
            SharedInstallTests.assertFalse((String)"0.2", (boolean)userConfigIni.exists());
            this.reconcileReadOnly("0.21");
            SharedInstallTests.assertFalse((String)"0.3", (boolean)userBundlesInfo.exists());
            SharedInstallTests.assertTrue((String)"0.4", (boolean)userConfigIni.exists());
            Properties props = new Properties();
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = Files.newInputStream(userConfigIni.toPath(), new OpenOption[0]);){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            SharedInstallTests.assertTrue((String)"0.5", (boolean)props.containsKey("osgi.sharedConfiguration.area"));
            SharedInstallTests.assertTrue((String)"0.6", (props.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            SharedInstallTests.cleanupReadOnlyInstall();
        }
    }

    public void testReadOnlyDropinsStartup() throws IOException {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "myBundle");
        File jar = SharedInstallTests.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("0.2", "dropins", jar);
        this.setupReadOnlyInstall();
        try {
            File userBundlesInfo = new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
            File userConfigIni = new File(userBase, "configuration/config.ini");
            SharedInstallTests.assertFalse((String)"0.1", (boolean)userBundlesInfo.exists());
            SharedInstallTests.assertFalse((String)"0.2", (boolean)userConfigIni.exists());
            this.reconcileReadOnly("0.21");
            SharedInstallTests.assertTrue((String)"0.3", (boolean)userBundlesInfo.exists());
            SharedInstallTests.assertTrue((String)"0.4", (boolean)userConfigIni.exists());
            SharedInstallTests.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTests.setReadOnly(readOnlyBase, false);
            SharedInstallTests.assertTrue((String)"0.7", (boolean)readOnlyBase.canWrite());
            this.remove("1.0", "dropins", "myBundle_1.0.0.jar");
            SharedInstallTests.setReadOnly(readOnlyBase, true);
            this.reconcileReadOnly("0.21");
            SharedInstallTests.assertFalse((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
        }
        finally {
            SharedInstallTests.cleanupReadOnlyInstall();
            this.remove("1.0", "dropins", "myBundle_1.0.0.jar");
        }
    }

    public void testUserDropinsStartup() throws IOException {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "myBundle");
        File jar = SharedInstallTests.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        File dropins = new File(userBase, "dropins");
        this.setupReadOnlyInstall();
        try {
            dropins.mkdir();
            SharedInstallTests.copy("copying to dropins", jar, new File(dropins, jar.getName()));
            File userBundlesInfo = new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
            File userConfigIni = new File(userBase, "configuration/config.ini");
            SharedInstallTests.assertFalse((String)"0.1", (boolean)userBundlesInfo.exists());
            SharedInstallTests.assertFalse((String)"0.2", (boolean)userConfigIni.exists());
            this.reconcileReadOnly("0.21");
            SharedInstallTests.assertTrue((String)"0.3", (boolean)userBundlesInfo.exists());
            SharedInstallTests.assertTrue((String)"0.4", (boolean)userConfigIni.exists());
            SharedInstallTests.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTests.delete(dropins);
            this.reconcileReadOnly("0.21");
            SharedInstallTests.assertFalse((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
        }
        finally {
            SharedInstallTests.delete(dropins);
            SharedInstallTests.cleanupReadOnlyInstall();
        }
    }
}

